/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.join;

import uk.ac.starlink.table.join.JoinType;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.TaskException;

public class JoinTypeParameter
extends ChoiceParameter<JoinType> {
    public JoinTypeParameter(String name) {
        super(name, (Object[])JoinType.getPairTypes());
        StringBuffer items = new StringBuffer();
        JoinType[] joins = JoinType.getPairTypes();
        for (int i = 0; i < joins.length; ++i) {
            JoinType join = joins[i];
            items.append("<li><code>").append(join.getName()).append("</code>: ").append(join.getDescription()).append("</li>\n");
        }
        this.setDescription(new String[]{"<p>Determines which rows are included in the output table.", "The matching algorithm determines which of the rows from", "the first table correspond to which rows from the second.", "This parameter determines what to do with that information.", "Perhaps the most obvious thing is to write out a table", "containing only rows which correspond to a row in both of", "the two input tables.  However, you may also want to see", "the unmatched rows from one or both input tables,", "or rows present in one table but unmatched in the other,", "or other possibilities.", "The options are:", "<ul>", items.toString(), "</ul>", "</p>"});
        this.setPrompt("Selection criteria for output rows");
        this.setDefaultOption(JoinType._1AND2);
    }

    public JoinType joinTypeValue(Environment env) throws TaskException {
        return (JoinType)this.objectValue(env);
    }

    public String stringifyOption(JoinType type) {
        return type.getName();
    }
}

