/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Color;
import uk.ac.starlink.ttools.plot.DataColorTweaker;

public class Fogger {
    private final double scale_;
    private final int[] iFogRgb_;
    private final float[] fFogRgb_;
    private final float[] work3 = new float[3];
    private double fogScale_;

    public Fogger(double scale) {
        this.scale_ = scale;
        int ifog = 255;
        float ffog = (float)ifog / 255.0f;
        this.iFogRgb_ = new int[]{ifog, ifog, ifog};
        this.fFogRgb_ = new float[]{ffog, ffog, ffog};
    }

    public double getScale() {
        return this.scale_;
    }

    public void setFogginess(double fogginess) {
        this.fogScale_ = fogginess / this.scale_;
    }

    public double getFogginess() {
        return this.fogScale_ * this.scale_;
    }

    private float getClarityAt(double z) {
        double ked = this.fogScale_ * z;
        return ked <= 0.0 ? 1.0f : (float)Math.exp(-ked);
    }

    private float getClarityBetween(double zlo, double zhi) {
        double ked = Math.max(0.0, zhi) - Math.max(0.0, zlo);
        return ked <= 0.0 ? 1.0f : (float)Math.exp(-ked);
    }

    private int fogComponent(float clarity, int value, int icomp) {
        return icomp < 3 ? (int)(clarity * (float)value + (1.0f - clarity) * (float)this.iFogRgb_[icomp]) : value;
    }

    private float fogComponent(float clarity, float value, int icomp) {
        return icomp < 3 ? clarity * value + (1.0f - clarity) * this.fFogRgb_[icomp] : value;
    }

    public Color fogAt(double z, Color color) {
        float clarity = this.getClarityAt(z);
        return clarity == 1.0f ? color : new Color(this.fogComponent(clarity, color.getRed(), 0), this.fogComponent(clarity, color.getGreen(), 1), this.fogComponent(clarity, color.getBlue(), 2), this.fogComponent(clarity, color.getAlpha(), 3));
    }

    public void fogAt(double z, int[] rgba) {
        float clarity = this.getClarityAt(z);
        if (clarity != 1.0f) {
            for (int i = 0; i < 4; ++i) {
                rgba[i] = this.fogComponent(clarity, rgba[i], i);
            }
        }
    }

    public void fogAt(double z, float[] rgba) {
        float clarity = this.getClarityAt(z);
        if (clarity != 1.0f) {
            for (int i = 0; i < 4; ++i) {
                rgba[i] = this.fogComponent(clarity, rgba[i], i);
            }
        }
    }

    public int fogAt(double z, int argb) {
        float clarity = this.getClarityAt(z);
        if (clarity == 1.0f) {
            return argb;
        }
        int b = argb >> 0 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int a = argb >> 24 & 0xFF;
        return (this.fogComponent(clarity, b, 0) & 0xFF) << 0 | (this.fogComponent(clarity, g, 1) & 0xFF) << 8 | (this.fogComponent(clarity, r, 2) & 0xFF) << 16 | (this.fogComponent(clarity, a, 3) & 0xFF) << 24;
    }

    public DataColorTweaker createTweaker(final int ifog, final int ncoord) {
        return new DataColorTweaker(){
            private double z_;

            @Override
            public boolean setCoords(double[] coords) {
                double z = coords[ifog];
                if (Double.isNaN(z)) {
                    return false;
                }
                this.z_ = z;
                return true;
            }

            @Override
            public int getNcoord() {
                return ncoord;
            }

            @Override
            public Color tweakColor(Color color) {
                return Fogger.this.fogAt(this.z_, color);
            }

            @Override
            public void tweakColor(float[] rgba) {
                Fogger.this.fogAt(this.z_, rgba);
            }
        };
    }

    public DataColorTweaker createTweaker(final int ifog, final DataColorTweaker base) {
        return new DataColorTweaker(){
            private double z_;

            @Override
            public boolean setCoords(double[] coords) {
                if (base.setCoords(coords)) {
                    double z = coords[ifog];
                    if (Double.isNaN(z)) {
                        return false;
                    }
                    this.z_ = z;
                    return true;
                }
                return false;
            }

            @Override
            public int getNcoord() {
                return base.getNcoord();
            }

            @Override
            public Color tweakColor(Color color) {
                if (Fogger.this.getClarityAt(this.z_) == 1.0f) {
                    return base.tweakColor(color);
                }
                float[] rgba = color.getRGBComponents(null);
                this.tweakColor(rgba);
                return new Color(rgba[0], rgba[1], rgba[2], rgba[3]);
            }

            @Override
            public void tweakColor(float[] rgba) {
                base.tweakColor(rgba);
                Fogger.this.fogAt(this.z_, rgba);
            }
        };
    }
}

