/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.util.ArrayList;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.ColorTweaker;
import uk.ac.starlink.ttools.plot.DefaultStyle;
import uk.ac.starlink.ttools.plot.Drawing;
import uk.ac.starlink.ttools.plot.ErrorMode;
import uk.ac.starlink.ttools.plot.ErrorModeSelection;
import uk.ac.starlink.ttools.plot.ErrorRenderer;
import uk.ac.starlink.ttools.plot.GraphicsBitmap;
import uk.ac.starlink.ttools.plot.MarkShape;
import uk.ac.starlink.ttools.plot.Pixellator;
import uk.ac.starlink.ttools.plot.PlotData;
import uk.ac.starlink.ttools.plot.PointArrayPixellator;
import uk.ac.starlink.ttools.plot.TablePlot;
import uk.ac.starlink.ttools.plot.TranslatedPixellator;
import uk.ac.starlink.util.IntList;

public abstract class MarkStyle
extends DefaultStyle {
    private final int size_;
    private final int maxr_;
    private final MarkShape shapeId_;
    private Line line_;
    private boolean hidePoints_;
    private int opaqueLimit_ = 1;
    private ErrorRenderer errorRenderer_;
    private Pixellator pixoffs_;
    private static final RenderingHints pixHints_;
    private ErrorModeSelection[] errorModeSelections_;
    public static final Line DOT_TO_DOT;
    public static final Line LINEAR;
    public static final int LEGEND_ICON_WIDTH = 20;
    public static final int LEGEND_ICON_HEIGHT = 12;
    private static final RenderingHints.Key AA_KEY;
    private static final Object AA_ON;
    private static final Font LABEL_FONT;
    private static final FontRenderContext PIXEL_FRC;

    protected MarkStyle(Color color, Object otherAtts, MarkShape shapeId, int size, int maxr) {
        super(color, otherAtts);
        this.shapeId_ = shapeId;
        this.size_ = size;
        this.maxr_ = maxr;
        this.errorRenderer_ = ErrorRenderer.DEFAULT;
        this.errorModeSelections_ = new ErrorModeSelection[0];
    }

    public abstract void drawShape(Graphics var1);

    public void drawLegendShape(Graphics g) {
        if (TablePlot.isVectorContext(g)) {
            this.drawShape(g);
        } else {
            Pixellator pixer = this.getPixelOffsets();
            pixer.start();
            while (pixer.next()) {
                g.fillRect(pixer.getX(), pixer.getY(), 1, 1);
            }
        }
    }

    public int getMaximumRadius() {
        return this.maxr_;
    }

    public MarkShape getShapeId() {
        return this.shapeId_;
    }

    public int getSize() {
        return this.size_;
    }

    public void setLine(Line line) {
        this.line_ = line;
    }

    public Line getLine() {
        return this.line_;
    }

    public void setHidePoints(boolean visible) {
        this.hidePoints_ = visible;
    }

    public boolean getHidePoints() {
        return this.hidePoints_;
    }

    public void setOpaqueLimit(int lim) {
        if (lim < 1) {
            throw new IllegalArgumentException(lim + " < 1");
        }
        this.opaqueLimit_ = lim;
    }

    public int getOpaqueLimit() {
        return this.opaqueLimit_;
    }

    public void setErrorRenderer(ErrorRenderer errorRenderer) {
        this.errorRenderer_ = errorRenderer;
    }

    public ErrorRenderer getErrorRenderer() {
        return this.errorRenderer_;
    }

    public void setErrorModeModels(ErrorModeSelection[] errSelections) {
        this.errorModeSelections_ = errSelections;
    }

    public Color getLabelColor() {
        return Color.BLACK;
    }

    public void drawMarker(Graphics g, int x, int y) {
        this.drawMarker(g, x, y, null);
    }

    public void drawMarker(Graphics g, int x, int y, ColorTweaker fixer) {
        Color origColor = g.getColor();
        Color markColor = fixer == null ? this.getColor() : fixer.tweakColor(this.getColor());
        g.setColor(markColor);
        g.translate(x, y);
        this.drawShape(g);
        g.translate(-x, -y);
        g.setColor(origColor);
    }

    public void drawErrors(Graphics g, int x, int y, int[] xoffs, int[] yoffs) {
        this.drawErrors(g, x, y, xoffs, yoffs, null);
    }

    public void drawErrors(Graphics g, int x, int y, int[] xoffs, int[] yoffs, ColorTweaker fixer) {
        Color origColor = g.getColor();
        Color errColor = fixer == null ? this.getColor() : fixer.tweakColor(this.getColor());
        g.setColor(errColor);
        this.errorRenderer_.drawErrors(g, x, y, xoffs, yoffs);
        g.setColor(origColor);
    }

    public void drawLabel(Graphics g, int x, int y, String label) {
        this.drawLabel(g, x, y, label, null);
    }

    public void drawLabel(Graphics g, int x, int y, String label, ColorTweaker fixer) {
        Color origColor = g.getColor();
        Color labelColor = fixer == null ? this.getLabelColor() : fixer.tweakColor(this.getLabelColor());
        g.setColor(labelColor);
        g.drawString(label, x + 4, y - 4);
        g.setColor(origColor);
    }

    @Override
    public Icon getLegendIcon() {
        int nerr = this.errorModeSelections_.length;
        ErrorMode[] modes = new ErrorMode[nerr];
        for (int ierr = 0; ierr < nerr; ++ierr) {
            modes[ierr] = this.errorModeSelections_[ierr].getErrorMode();
        }
        return this.getLegendIcon(modes);
    }

    public Icon getLegendIcon(ErrorMode[] errorModes) {
        final Icon errorIcon = this.errorRenderer_.isBlank(errorModes) ? null : this.errorRenderer_.getLegendIcon(errorModes, 20, 12, 1, 1);
        return new Icon(){

            @Override
            public int getIconHeight() {
                return 12;
            }

            @Override
            public int getIconWidth() {
                return 20;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Object aaHint;
                Graphics2D g2 = (Graphics2D)g;
                boolean hide = MarkStyle.this.getHidePoints();
                if (MarkStyle.this.getLine() != null) {
                    aaHint = g2.getRenderingHint(AA_KEY);
                    g2.setRenderingHint(AA_KEY, AA_ON);
                    Stroke stroke = g2.getStroke();
                    g2.setStroke(MarkStyle.this.getStroke(0, 0));
                    Color color = g2.getColor();
                    g2.setColor(MarkStyle.this.getColor());
                    int ypos = y + 6;
                    g2.drawLine(x, ypos, x + 20, ypos);
                    g2.setColor(color);
                    g2.setStroke(stroke);
                    g2.setRenderingHint(AA_KEY, aaHint);
                }
                if (errorIcon != null) {
                    aaHint = g2.getRenderingHint(AA_KEY);
                    g2.setRenderingHint(AA_KEY, AA_ON);
                    Color color = g2.getColor();
                    g2.setColor(MarkStyle.this.getColor());
                    errorIcon.paintIcon(c, g2, x, y);
                    g2.setColor(color);
                    g2.setRenderingHint(AA_KEY, aaHint);
                }
                if (!hide) {
                    Color color = g2.getColor();
                    g2.setColor(MarkStyle.this.getColor());
                    int xoff = x + 10;
                    int yoff = y + 6;
                    g2.translate(xoff, yoff);
                    MarkStyle.this.drawLegendShape(g2);
                    g2.translate(-xoff, -yoff);
                    g2.setColor(color);
                }
            }
        };
    }

    public Icon getIcon(final int width, final int height) {
        return new Icon(){

            @Override
            public int getIconHeight() {
                return height;
            }

            @Override
            public int getIconWidth() {
                return width;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int xoff, int yoff) {
                int x = xoff + width / 2;
                int y = yoff + height / 2;
                MarkStyle.this.drawMarker(g, x, y);
            }
        };
    }

    public Pixellator getPixelOffsets() {
        if (this.pixoffs_ == null) {
            int xdim = 2 * this.maxr_ + 1;
            int ydim = 2 * this.maxr_ + 1;
            int xoff = this.maxr_;
            int yoff = this.maxr_;
            BufferedImage im = new BufferedImage(xdim, ydim, 2);
            Graphics2D g = im.createGraphics();
            g.setRenderingHints(pixHints_);
            this.drawMarker(g, xoff, yoff, null);
            Raster raster = im.getData();
            ArrayList<Point> pointList = new ArrayList<Point>(xdim * ydim);
            for (int ix = 0; ix < xdim; ++ix) {
                for (int iy = 0; iy < ydim; ++iy) {
                    int alpha = raster.getSample(ix, iy, 3);
                    if (alpha <= 0) continue;
                    assert (alpha == 255) : alpha;
                    pointList.add(new Point(ix - xoff, iy - yoff));
                }
            }
            Point[] points = pointList.toArray(new Point[0]);
            this.pixoffs_ = new PointArrayPixellator(points);
        }
        return this.pixoffs_;
    }

    public int[] getFlattenedPixelOffsets(int xStride) {
        IntList offList = new IntList();
        Pixellator pixer = this.getPixelOffsets();
        pixer.start();
        while (pixer.next()) {
            offList.add(pixer.getX() + pixer.getY() * xStride);
        }
        return offList.toIntArray();
    }

    public Pixellator getLabelPixels(String label, int x, int y, Rectangle clip) {
        return MarkStyle.bitmapTextPixellator(label, x += 4, y -= 4, this.getLabelFont(), clip);
    }

    private Font getLabelFont() {
        return LABEL_FONT;
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            MarkStyle other = (MarkStyle)o;
            return this.line_ == other.line_ && this.hidePoints_ == other.hidePoints_ && this.opaqueLimit_ == other.opaqueLimit_ && this.errorRenderer_.equals(other.errorRenderer_);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int code = super.hashCode();
        code = code * 23 + (this.line_ == null ? 1 : this.line_.hashCode());
        code = code * 23 + (this.hidePoints_ ? 0 : 1);
        code = code * 23 + this.opaqueLimit_;
        code = code * 23 + this.errorRenderer_.hashCode();
        return code;
    }

    public static boolean hasErrors(MarkStyle style, PlotData plotData) {
        return plotData.getNerror() > 0 && !style.getErrorRenderer().isBlank(null);
    }

    public static MarkStyle targetStyle() {
        return new MarkStyle(new Color(0, 0, 0, 192), new Object(), null, 1, 7){
            final Stroke stroke_ = new BasicStroke(2.0f, 1, 1);

            @Override
            public void drawShape(Graphics g) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setStroke(this.stroke_);
                g2.drawOval(-6, -6, 13, 13);
                g2.drawLine(0, 4, 0, 8);
                g2.drawLine(0, -4, 0, -8);
                g2.drawLine(4, 0, 8, 0);
                g2.drawLine(-4, 0, -8, 0);
            }
        };
    }

    private static Pixellator bitmapTextPixellator(String text, int x, int y, Font font, Rectangle clip) {
        Rectangle bounds = font.getStringBounds(text, PIXEL_FRC).getBounds();
        int xoff = bounds.x;
        int yoff = bounds.y;
        if (clip != null) {
            bounds = new Rectangle(clip.x - x, clip.y - y, clip.width, clip.height).intersection(bounds);
        }
        if (bounds.isEmpty()) {
            return null;
        }
        GraphicsBitmap bitmap = new GraphicsBitmap(bounds.width, bounds.height);
        Graphics2D g = bitmap.createGraphics();
        g.setFont(font);
        ((Graphics)g).drawString(text, -bounds.x, -bounds.y);
        return new TranslatedPixellator(bitmap.createPixellator(), x + bounds.x, y + bounds.y);
    }

    private static Pixellator glyphTextPixellator(String text, int x, int y, Font font, Rectangle clip) {
        Shape outline = font.createGlyphVector(PIXEL_FRC, text).getOutline(x, y);
        Rectangle bounds = outline.getBounds();
        if (clip != null) {
            bounds = bounds.intersection(clip);
        }
        Drawing drawing = new Drawing(bounds);
        drawing.fill(outline);
        return drawing;
    }

    static {
        DOT_TO_DOT = new Line("DotToDot");
        LINEAR = new Line("LinearRegression");
        AA_KEY = RenderingHints.KEY_ANTIALIASING;
        AA_ON = RenderingHints.VALUE_ANTIALIAS_ON;
        LABEL_FONT = new GraphicsBitmap(1, 1).createGraphics().getFont();
        PIXEL_FRC = new FontRenderContext(null, false, false);
        pixHints_ = new RenderingHints(null);
        pixHints_.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        pixHints_.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        pixHints_.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        pixHints_.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    public static class Line {
        private final String name_;

        private Line(String name) {
            this.name_ = name;
        }

        public String toString() {
            return this.name_;
        }
    }
}

