/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.jibble.epsgraphics.EpsGraphics2D;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.plot.PdfGraphicExporter;
import uk.ac.starlink.ttools.plot.Picture;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot2.AuxReader;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.BasicRanger;
import uk.ac.starlink.ttools.plot2.Caption;
import uk.ac.starlink.ttools.plot2.CoordSequence;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.Gang;
import uk.ac.starlink.ttools.plot2.IndicatedRow;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotPlacement;
import uk.ac.starlink.ttools.plot2.PointCloud;
import uk.ac.starlink.ttools.plot2.RangeCollector;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.Slow;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.SplitRunner;
import uk.ac.starlink.ttools.plot2.SubCloud;
import uk.ac.starlink.ttools.plot2.Subrange;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.SurfaceFactory;
import uk.ac.starlink.ttools.plot2.Tick;
import uk.ac.starlink.ttools.plot2.ZoneContent;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.TupleRunner;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.paper.PaperType;
import uk.ac.starlink.util.SplitCollector;

public class PlotUtil {
    private static Boolean dfltAntialias_;
    private static final DecimalFormatSymbols UK_SYMBOLS;
    private static final Logger logger_;
    public static final TupleSequence EMPTY_TUPLE_SEQUENCE;
    public static final Span EMPTY_SPAN;
    private static final String LATEX_FONT_PATHS = "latex_fonts.txt";
    public static final PdfGraphicExporter LATEX_PDF_EXPORTER;
    public static final double NEAR_PIXELS = 4.0;
    public static final int DEFAULT_MAX_PIXELS = 20;
    public static final short MAX_MARKSIZE = 100;
    public static final int MIN_RAMP_UNIT = 12;
    private static final double PAD_FRACTION = 0.02;
    private static final double TINY_FRACTION = 1.0E-7;
    private static final Level REPORT_LEVEL;
    public static SplitRunner<CoordSequence> COORD_RUNNER;

    private PlotUtil() {
    }

    public static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static boolean doubleEquals(double d1, double d2) {
        return Double.isNaN(d1) ? Double.isNaN(d2) : d1 == d2;
    }

    public static int hashCode(Object obj) {
        return obj == null ? 0 : obj.hashCode();
    }

    public static boolean storeFullPrecision() {
        return true;
    }

    public static synchronized boolean getDefaultTextAntialiasing() {
        if (dfltAntialias_ == null) {
            String os;
            try {
                os = System.getProperty("os.name");
            }
            catch (SecurityException e) {
                os = "?";
            }
            boolean isMac = os != null && (os.toLowerCase().indexOf("macos") >= 0 || os.toLowerCase().indexOf("mac os") >= 0);
            dfltAntialias_ = isMac;
            logger_.info("Use default text antialias setting " + dfltAntialias_ + " (os.name=" + os + ")");
        }
        return dfltAntialias_;
    }

    public static String getIndexSuffix(int ipos) {
        return Integer.toString(1 + ipos);
    }

    public static void logTimeElapsed(Logger logger, String phase, long elapsed) {
        if (elapsed > 0L) {
            logger.info(phase + " time: " + elapsed);
        }
    }

    public static void logTimeFromStart(Logger logger, String phase, long start) {
        PlotUtil.logTimeElapsed(logger, phase, System.currentTimeMillis() - start);
    }

    public static <T> T[] arrayConcat(T[] a1, T[] a2) {
        int count = a1.length + a2.length;
        ArrayList<T> list = new ArrayList<T>(count);
        list.addAll(Arrays.asList(a1));
        list.addAll(Arrays.asList(a2));
        Class<?> eClazz = a1.getClass().getComponentType();
        Object[] result = list.toArray((Object[])Array.newInstance(eClazz, count));
        return result;
    }

    public static String concatLines(String[] lines) {
        int leng = 0;
        for (String line : lines) {
            leng += line.length() + 1;
        }
        StringBuffer sbuf = new StringBuffer(leng);
        for (String line : lines) {
            sbuf.append(line).append('\n');
        }
        return sbuf.toString();
    }

    public static double toDouble(Number value) {
        return value == null ? Double.NaN : value.doubleValue();
    }

    public static boolean isFinite(double value) {
        return !Double.isNaN(value) && !Double.isInfinite(value);
    }

    public static boolean isPointFinite(Point2D.Double gp) {
        return PlotUtil.isFinite(gp.x) && PlotUtil.isFinite(gp.y);
    }

    public static boolean isPointReal(Point2D.Double gp) {
        return !Double.isNaN(gp.x) && !Double.isNaN(gp.y);
    }

    public static void quantisePoint(Point2D.Double dpos, Point gpos) {
        gpos.x = PlotUtil.ifloor(dpos.x);
        gpos.y = PlotUtil.ifloor(dpos.y);
    }

    public static int ifloor(double x) {
        int y = (int)x;
        return x >= 0.0 || x == (double)y || y == Integer.MIN_VALUE ? y : y - 1;
    }

    public static double[] orderPair(double p1, double p2) {
        double[] dArray;
        if (p1 <= p2) {
            double[] dArray2 = new double[2];
            dArray2[0] = p1;
            dArray = dArray2;
            dArray2[1] = p2;
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = p2;
            dArray = dArray3;
            dArray3[1] = p1;
        }
        return dArray;
    }

    public static Rectangle getGangBounds(Gang gang) {
        int nz = gang.getZoneCount();
        int xmin = Integer.MAX_VALUE;
        int ymin = Integer.MAX_VALUE;
        int xmax = Integer.MIN_VALUE;
        int ymax = Integer.MIN_VALUE;
        for (int iz = 0; iz < nz; ++iz) {
            Rectangle rect = gang.getZonePlotBounds(iz);
            xmin = Math.min(xmin, rect.x);
            ymin = Math.min(ymin, rect.y);
            xmax = Math.max(xmax, rect.x + rect.width);
            ymax = Math.max(ymax, rect.y + rect.height);
        }
        return xmax >= xmin && ymax >= ymin ? new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin) : null;
    }

    public static <T> T[] singletonArray(T object) {
        Object[] array = (Object[])Array.newInstance(object.getClass(), 1);
        array[0] = object;
        return array;
    }

    public static <P> P[] createProfileArray(SurfaceFactory<P, ?> surfFact, int length) {
        P profile = surfFact.createProfile(new ConfigMap());
        Object[] array = (Object[])Array.newInstance(profile.getClass(), length);
        return array;
    }

    public static <P, A> A[] createAspectArray(SurfaceFactory<P, A> surfFact, int length) {
        ConfigMap config = new ConfigMap();
        P profile = surfFact.createProfile(config);
        A aspect = surfFact.createAspect(profile, config, null);
        Object[] array = (Object[])Array.newInstance(aspect.getClass(), length);
        return array;
    }

    public static <P, A> ZoneContent<P, A>[] createZoneContentArray(SurfaceFactory<P, A> surfFact, int length) {
        ZoneContent[] contents = new ZoneContent[length];
        return contents;
    }

    public static Picture toPicture(final Icon icon) {
        return new Picture(){

            @Override
            public int getPictureWidth() {
                return icon.getIconWidth();
            }

            @Override
            public int getPictureHeight() {
                return icon.getIconHeight();
            }

            @Override
            public void paintPicture(Graphics2D g2) {
                icon.paintIcon(null, g2, 0, 0);
            }
        };
    }

    @Slow
    public static <A> A tupleCollect(SplitCollector<TupleSequence, A> collector, DataSpec dataSpec, DataStore dataStore) {
        return dataStore.getTupleRunner().collect(collector, () -> dataStore.getTupleSequence(dataSpec));
    }

    @Slow
    public static void extendCoordinateRanges(PlotLayer[] layers, Range[] ranges, Scale[] scales, boolean doPad, DataStore dataStore) {
        final int nDataDim = ranges.length;
        SubCloud[] subClouds = PlotUtil.arrayConcat(SubCloud.createSubClouds(layers, true), SubCloud.createPartialSubClouds(layers, true));
        if (subClouds.length > 0) {
            PointCloud cloud = new PointCloud(subClouds);
            RangeCollector<CoordSequence> rangeCollector = new RangeCollector<CoordSequence>(nDataDim){

                public void accumulate(CoordSequence cseq, Range[] ranges) {
                    double[] dpos = cseq.getCoords();
                    while (cseq.next()) {
                        for (int idim = 0; idim < nDataDim; ++idim) {
                            ranges[idim].submit(dpos[idim]);
                        }
                    }
                }
            };
            Range[] cloudRanges = dataStore.getTupleRunner().coordRunner().collect(rangeCollector, cloud.createDataPosSupplier(dataStore));
            rangeCollector.mergeRanges(ranges, cloudRanges);
        }
        for (int il = 0; il < layers.length; ++il) {
            layers[il].extendCoordinateRanges(ranges, scales, dataStore);
        }
        if (doPad) {
            for (int idim = 0; idim < nDataDim; ++idim) {
                PlotUtil.padRange(ranges[idim], scales[idim]);
            }
        }
    }

    public static void padRange(Range range, Scale scale) {
        double hi;
        double[] bounds = range.getFiniteBounds(scale.isPositiveDefinite());
        double lo = bounds[0];
        if (lo < (hi = bounds[1])) {
            boolean hiNearZero;
            boolean loNearZero;
            double padFrac = 0.02;
            double tinyFrac = 1.0E-7;
            if (scale.isPositiveDefinite()) {
                loNearZero = false;
                hiNearZero = false;
            } else {
                double ztol = 2.0 * padFrac;
                double zfrac = PlotUtil.unscaleValue(lo, hi, 0.0, scale);
                loNearZero = 0.0 - zfrac >= 0.0 && 0.0 - zfrac <= ztol;
                hiNearZero = zfrac - 1.0 >= 0.0 && zfrac - 1.0 <= ztol;
            }
            double loPadFrac = loNearZero ? tinyFrac : padFrac;
            double hiPadFrac = hiNearZero ? tinyFrac : padFrac;
            range.submit(PlotUtil.scaleValue(lo, hi, 0.0 - loPadFrac, scale));
            range.submit(PlotUtil.scaleValue(lo, hi, 1.0 + hiPadFrac, scale));
        }
    }

    public static ValueInfo getScaleInfo(PlotLayer[] layers, AuxScale scale) {
        for (PlotLayer layer : layers) {
            ValueInfo info;
            AuxReader rdr = layer.getAuxRangers().get(scale);
            if (rdr == null || (info = rdr.getAxisInfo(layer.getDataSpec())) == null) continue;
            return info;
        }
        return null;
    }

    public static String getScaleAxisLabel(PlotLayer[] layers, AuxScale scale) {
        ValueInfo info = PlotUtil.getScaleInfo(layers, scale);
        if (info != null) {
            String name = info.getName();
            String unit = info.getUnitString();
            if (name != null && unit != null) {
                return name + " / " + unit;
            }
            if (name != null) {
                return name;
            }
        }
        return null;
    }

    @Slow
    public static IndicatedRow getClosestRow(Surface surface, DataGeom geom, int iPosCoord, Supplier<TupleSequence> tupleSupplier, TupleRunner runner, Point2D point) {
        IndexDist ixdist = runner.collect(new ClosestCollector(surface, geom, iPosCoord, point), tupleSupplier);
        return ixdist.bestIndex_ < 0L || Thread.currentThread().isInterrupted() ? null : new IndicatedRow(ixdist.bestIndex_, Math.sqrt(ixdist.bestDist2_), ixdist.bestDpos_);
    }

    @Slow
    public static Icon createPlotIcon(PlotPlacement placer, PlotLayer[] layers, Map<AuxScale, Span> auxSpans, DataStore dataStore, PaperType paperType, boolean cached, Collection<Object> storedPlans) {
        Surface surface = placer.getSurface();
        int nl = layers.length;
        logger_.info("Layers: " + nl + ", Paper: " + paperType);
        Drawing[] drawings = new Drawing[nl];
        Object[] plans = new Object[nl];
        HashSet<Object> knownPlans = new HashSet<Object>();
        if (storedPlans != null) {
            knownPlans.addAll(storedPlans);
        }
        for (int il = 0; il < nl; ++il) {
            drawings[il] = layers[il].createDrawing(surface, auxSpans, paperType);
            plans[il] = drawings[il].calculatePlan(knownPlans.toArray(), dataStore);
            knownPlans.add(plans[il]);
        }
        if (storedPlans != null) {
            storedPlans.clear();
            storedPlans.addAll(new HashSet<Object>(Arrays.asList(plans)));
        }
        Icon dataIcon = paperType.createDataIcon(surface, drawings, plans, dataStore, cached);
        if (logger_.isLoggable(REPORT_LEVEL)) {
            for (int il = 0; il < nl; ++il) {
                String rtxt;
                ReportMap report = drawings[il].getReport(plans[il]);
                if (report == null || (rtxt = report.toString(false)).length() <= 0) continue;
                String msg = new StringBuffer().append("Layer ").append(il).append(": ").append(rtxt).toString();
                logger_.log(REPORT_LEVEL, msg);
            }
        }
        return placer.createPlotIcon(dataIcon);
    }

    public static int getButtonChangedIndex(MouseEvent evt) {
        int iButt = evt.getButton();
        int exmods = evt.getModifiersEx();
        if (iButt == 3) {
            return 3;
        }
        if (iButt == 2) {
            return 2;
        }
        if (iButt == 1) {
            if ((exmods & 0x80) != 0) {
                return 3;
            }
            if ((exmods & 0x40) != 0) {
                return 2;
            }
            return 1;
        }
        if (iButt == 0) {
            return 0;
        }
        return 0;
    }

    public static int getButtonDownIndex(MouseEvent evt) {
        int exmods = evt.getModifiersEx();
        if ((exmods & 0x1000) != 0) {
            return 3;
        }
        if ((exmods & 0x800) != 0) {
            return 2;
        }
        if ((exmods & 0x400) != 0) {
            if ((exmods & 0x80) != 0) {
                return 3;
            }
            if ((exmods & 0x40) != 0) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public static double toZoom(double unitFactor, int wheelrot) {
        return Math.pow(unitFactor, -wheelrot);
    }

    public static double toZoom(double unitFactor, Point p0, Point p1, Boolean isY) {
        int dx = p1.x - p0.x;
        int dy = -p1.y + p0.y;
        int npix = isY == null ? dx + dy : (isY != false ? dy : dx);
        return Math.pow(unitFactor, (double)npix / 24.0);
    }

    public static double scaleValue(double min, double max, double frac, Scale scale) {
        return scale.scaleToData(scale.dataToScale(min) * (1.0 - frac) + scale.dataToScale(max) * frac);
    }

    public static double scaleValue(double min, double max, double frac) {
        return PlotUtil.scaleValue(min, max, frac, Scale.LINEAR);
    }

    public static double unscaleValue(double min, double max, double point, Scale scale) {
        return (scale.dataToScale(point) - scale.dataToScale(min)) / (scale.dataToScale(max) - scale.dataToScale(min));
    }

    public static double[] scaleRange(double min, double max, Subrange subrange, Scale scale) {
        return new double[]{PlotUtil.scaleValue(min, max, subrange.getLow(), scale), PlotUtil.scaleValue(min, max, subrange.getHigh(), scale)};
    }

    public static Span createSpan(double lo, double hi) {
        return EMPTY_SPAN.limit(lo, hi);
    }

    public static boolean approxEquals(double v0, double v1) {
        if (v0 == 0.0) {
            return v1 == 0.0;
        }
        double r = v1 / v0;
        return r >= 0.9999 && r <= 1.0001;
    }

    public static String formatNumber(double value, String baseFmt, int nFracDigits) {
        DecimalFormat fmt = new DecimalFormat(baseFmt, UK_SYMBOLS);
        fmt.setMaximumFractionDigits(nFracDigits);
        fmt.setMinimumFractionDigits(nFracDigits);
        String out = fmt.format(value);
        return out.matches("-0+\\.0+") ? out.substring(1) : out;
    }

    public static String formatNumberSf(double value, int nsf) {
        String txt = PlotUtil.doFormatNumberSf(value, nsf);
        assert (Double.isNaN(value) || Double.isInfinite(value) || value == 0.0 || Math.abs((value - Double.parseDouble(txt)) / value) < Math.pow(10.0, -(nsf - 1))) : "nsf: " + nsf + "\t" + value + " -> " + txt;
        return txt;
    }

    private static String doFormatNumberSf(double value, int nsf) {
        if (value == 0.0) {
            return "0";
        }
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return Double.toString(value);
        }
        double absVal = Math.abs(value);
        double log10 = Math.log10(absVal);
        if (log10 >= -1.0 && log10 < (double)nsf) {
            int ndp = nsf - (int)Math.ceil(log10);
            StringBuffer fbuf = new StringBuffer(2 + ndp);
            fbuf.append("0.");
            for (int i = 0; i < ndp; ++i) {
                fbuf.append('#');
            }
            DecimalFormat fmt = new DecimalFormat(fbuf.toString(), UK_SYMBOLS);
            return fmt.format(value);
        }
        StringBuffer fbuf = new StringBuffer(4 + nsf);
        fbuf.append("0.");
        for (int i = 0; i < nsf - 1; ++i) {
            fbuf.append('#');
        }
        fbuf.append("E0");
        DecimalFormat fmt = new DecimalFormat(fbuf.toString(), UK_SYMBOLS);
        return fmt.format(value);
    }

    public static String formatNumber(double value, double epsilon) {
        if (epsilon == 0.0 || Double.isNaN(epsilon)) {
            return Double.toString(value);
        }
        epsilon = Math.abs(epsilon);
        double aval = Math.abs(value);
        int nsf = Math.max(0, (int)Math.round(-Math.log10(epsilon / aval)));
        if (aval <= Double.MIN_NORMAL) {
            return "0";
        }
        if (aval >= 1000000.0 || aval <= 1.0E-4) {
            return PlotUtil.formatNumber(value, "0.#E0", nsf);
        }
        if (epsilon >= 0.9) {
            return Long.toString(Math.round(value));
        }
        int ndp = (int)Math.round(Math.max(0.0, -Math.log10(epsilon)));
        return ndp == 0 ? Long.toString(Math.round(value)) : PlotUtil.formatNumber(value, "0.0", ndp);
    }

    public static String[] formatAxisRangeLimits(double dlo, double dhi, Scale scale, int npix) {
        double slo = scale.dataToScale(dlo);
        double shi = scale.dataToScale(dhi);
        double spix = (shi - slo) / (double)npix;
        return new String[]{PlotUtil.formatNumber(dlo, Math.abs(scale.scaleToData(slo + spix) - dlo)), PlotUtil.formatNumber(dhi, Math.abs(scale.scaleToData(shi + spix) - dhi))};
    }

    public static double roundNumber(double x, double epsilon) {
        if (Double.isNaN(x)) {
            return x;
        }
        try {
            return Double.parseDouble(PlotUtil.formatNumber(x, epsilon));
        }
        catch (NumberFormatException e) {
            assert (false) : PlotUtil.formatNumber(x, epsilon) + " -> " + e;
            return x;
        }
    }

    public static ConfigMap configLimits(ConfigKey<Double> minKey, ConfigKey<Double> maxKey, double min, double max, int npix) {
        double epsilon = (max - min) / (double)npix;
        ConfigMap config = new ConfigMap();
        config.put(minKey, PlotUtil.roundNumber(min, epsilon));
        config.put(maxKey, PlotUtil.roundNumber(max, epsilon));
        return config;
    }

    public static Rectangle subtractInsets(Rectangle base, Insets insets) {
        return new Rectangle(base.x + insets.left, base.y + insets.top, base.width - insets.left - insets.right, base.height - insets.top - insets.bottom);
    }

    public static double getPixelScaleExtent(Axis axis) {
        int[] glimits = axis.getGraphicsLimits();
        int g0 = glimits[0];
        int g1 = g0 + 1;
        double d0 = axis.graphicsToData(g0);
        double d1 = axis.graphicsToData(g1);
        Scale scale = axis.getScale();
        double s0 = scale.dataToScale(d0);
        double s1 = scale.dataToScale(d1);
        return Math.abs(s1 - s0);
    }

    public static Tick[] getShadowTicks(Tick[] ticks) {
        int ntick = ticks.length;
        Tick[] ticks2 = new Tick[ntick];
        for (int itick = 0; itick < ntick; ++itick) {
            Tick tick1 = ticks[itick];
            Caption label1 = tick1.getLabel();
            double value1 = tick1.getValue();
            Caption label2 = label1 == null ? null : Caption.createCaption("");
            ticks2[itick] = new Tick(value1, label2);
        }
        return ticks2;
    }

    public static Graphics createLineGraphics(Graphics g, Color color) {
        float[] rgba;
        float alpha;
        Graphics g2 = g.create();
        g2.setColor(color);
        if (g2 instanceof EpsGraphics2D && color.getAlpha() < 255 && (alpha = (rgba = color.getRGBComponents(null))[3]) < 1.0f) {
            BasicStroke stroke1;
            Stroke stroke0 = ((Graphics2D)g2).getStroke();
            if (stroke0 instanceof BasicStroke) {
                BasicStroke bstroke0 = (BasicStroke)stroke0;
                float width0 = bstroke0.getLineWidth();
                int cap0 = bstroke0.getEndCap();
                int join0 = bstroke0.getLineJoin();
                float miter0 = bstroke0.getMiterLimit();
                float[] dashArray0 = bstroke0.getDashArray();
                float dashPhase0 = bstroke0.getDashPhase();
                stroke1 = new BasicStroke(alpha * width0, cap0, join0, miter0, dashArray0, dashPhase0);
            } else {
                stroke1 = new BasicStroke(alpha);
            }
            ((Graphics2D)g2).setStroke(stroke1);
            g2.setColor(new Color(rgba[0], rgba[1], rgba[2]));
        }
        return g2;
    }

    static {
        UK_SYMBOLS = DecimalFormatSymbols.getInstance(Locale.UK);
        logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2");
        EMPTY_TUPLE_SEQUENCE = new TupleSequence(){

            @Override
            public boolean next() {
                return false;
            }

            public TupleSequence split() {
                return null;
            }

            public long splittableSize() {
                return 0L;
            }

            @Override
            public long getRowIndex() {
                return -1L;
            }

            @Override
            public Object getObjectValue(int icol) {
                throw new IllegalStateException();
            }

            @Override
            public double getDoubleValue(int icol) {
                throw new IllegalStateException();
            }

            @Override
            public int getIntValue(int icol) {
                throw new IllegalStateException();
            }

            @Override
            public long getLongValue(int icol) {
                throw new IllegalStateException();
            }

            @Override
            public boolean getBooleanValue(int icol) {
                throw new IllegalStateException();
            }
        };
        EMPTY_SPAN = new BasicRanger(true).createSpan();
        LATEX_PDF_EXPORTER = PdfGraphicExporter.createExternalFontExporter(PlotUtil.class.getResource(LATEX_FONT_PATHS));
        REPORT_LEVEL = Level.INFO;
        COORD_RUNNER = SplitRunner.createDefaultRunner();
    }

    private static class ClosestCollector
    implements SplitCollector<TupleSequence, IndexDist> {
        private final Surface surface_;
        private final DataGeom geom_;
        private final int iPosCoord_;
        private final Point2D point_;

        public ClosestCollector(Surface surface, DataGeom geom, int iPosCoord, Point2D point) {
            this.surface_ = surface;
            this.geom_ = geom;
            this.iPosCoord_ = iPosCoord;
            this.point_ = point;
        }

        public IndexDist createAccumulator() {
            return new IndexDist();
        }

        public void accumulate(TupleSequence tseq, IndexDist acc) {
            double[] dpos = new double[this.surface_.getDataDimCount()];
            Point2D.Double gp = new Point2D.Double();
            while (tseq.next()) {
                double dist2;
                if (!this.geom_.readDataPos(tseq, this.iPosCoord_, dpos) || !this.surface_.dataToGraphics(dpos, true, gp) || !((dist2 = gp.distanceSq(this.point_)) < acc.bestDist2_)) continue;
                acc.bestDist2_ = dist2;
                acc.bestIndex_ = tseq.getRowIndex();
                acc.bestDpos_ = (double[])dpos.clone();
            }
        }

        public IndexDist combine(IndexDist acc1, IndexDist acc2) {
            return acc1.bestDist2_ <= acc2.bestDist2_ ? acc1 : acc2;
        }
    }

    private static class IndexDist {
        long bestIndex_ = -1L;
        double bestDist2_ = Double.POSITIVE_INFINITY;
        double[] bestDpos_ = null;

        private IndexDist() {
        }
    }
}

