/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.util.LinkedHashMap;
import java.util.Map;
import uk.ac.starlink.ttools.plot2.config.ConfigException;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;

public abstract class ChoiceConfigKey<T>
extends ConfigKey<T> {
    private final boolean nullPermitted_;
    private final Map<String, T> optMap_;

    public ChoiceConfigKey(ConfigMeta meta, Class<T> clazz, T dflt, boolean nullPermitted) {
        super(meta, clazz, dflt);
        this.nullPermitted_ = nullPermitted;
        this.optMap_ = new LinkedHashMap<String, T>();
    }

    public void addOption(T option) {
        String sval = this.stringifyValue(option);
        if (sval == null) {
            throw new IllegalArgumentException("Can't stringify " + option);
        }
        this.optMap_.put(sval, option);
    }

    public Map<String, T> getOptionMap() {
        return this.optMap_;
    }

    public abstract T decodeString(String var1);

    public abstract String stringifyValue(T var1);

    @Override
    public T stringToValue(String sval) throws ConfigException {
        if (sval == null || sval.length() == 0) {
            if (this.nullPermitted_) {
                return null;
            }
            throw new ConfigException(this, "null not permitted");
        }
        T mapVal = this.optMap_.get(sval);
        if (mapVal != null) {
            return mapVal;
        }
        T decodeVal = this.decodeString(sval);
        if (decodeVal != null) {
            return decodeVal;
        }
        throw new ConfigException(this, "Unknown value \"" + sval + "\"");
    }

    @Override
    public String valueToString(T value) {
        if (value == null) {
            return null;
        }
        for (Map.Entry<String, T> entry : this.optMap_.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        String sval = this.stringifyValue(value);
        if (sval != null) {
            return sval;
        }
        return sval.toString();
    }
}

