/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.starlink.ttools.plot2.config.Specifier;

public abstract class SpecifierPanel<V>
implements Specifier<V> {
    private final boolean isXFill_;
    private final List<ActionListener> listeners_;
    private final ActionListener actionForwarder_;
    private final ChangeListener changeForwarder_;
    private JComponent component_;

    protected SpecifierPanel(boolean isXFill) {
        this.isXFill_ = isXFill;
        this.listeners_ = new ArrayList<ActionListener>();
        this.actionForwarder_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpecifierPanel.this.forwardAction(evt);
            }
        };
        this.changeForwarder_ = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SpecifierPanel.this.forwardAction(new ActionEvent(evt.getSource(), 0, "Change"));
            }
        };
    }

    @Override
    public boolean isXFill() {
        return this.isXFill_;
    }

    protected abstract JComponent createComponent();

    @Override
    public JComponent getComponent() {
        if (this.component_ == null) {
            this.component_ = this.createComponent();
        }
        return this.component_;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.listeners_.add(listener);
    }

    @Override
    public void removeActionListener(ActionListener listener) {
        this.listeners_.remove(listener);
    }

    protected ActionListener getActionForwarder() {
        return this.actionForwarder_;
    }

    protected ChangeListener getChangeForwarder() {
        return this.changeForwarder_;
    }

    protected void fireAction() {
        this.forwardAction(new ActionEvent(this, 0, "Act"));
    }

    private void forwardAction(ActionEvent evt) {
        for (ActionListener listener : this.listeners_) {
            listener.actionPerformed(evt);
        }
    }
}

