/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import java.util.function.Function;
import uk.ac.starlink.table.Domain;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.TimeDomain;
import uk.ac.starlink.table.TimeMapper;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.SimpleDomain;
import uk.ac.starlink.ttools.plot2.data.SingleCoord;
import uk.ac.starlink.ttools.plot2.data.StorageType;
import uk.ac.starlink.ttools.plot2.data.Tuple;

public class FloatingCoord
extends SingleCoord {
    private final Number nan_;
    public static FloatingCoord WEIGHT_COORD = FloatingCoord.createCoord(new InputMeta("weight", "Weight").setShortDescription("Non-unit weighting of data points").setXmlDescription(new String[]{"<p>Weighting of data points.", "If supplied, each point contributes a value", "to the histogram equal to the data value", "multiplied by this coordinate.", "If not supplied, the effect is the same as", "supplying a fixed value of one.", "</p>"}), false);

    private FloatingCoord(InputMeta meta, boolean isRequired, Domain<?> domain, boolean isDouble) {
        super(meta, isRequired, domain, isDouble ? StorageType.DOUBLE : StorageType.FLOAT);
        this.nan_ = isDouble ? Double.valueOf(Double.NaN) : (double)Float.valueOf(Float.NaN).floatValue();
    }

    public Function<Object[], Number> inputStorage(ValueInfo[] infos, DomainMapper[] dms) {
        return userValues -> {
            Object c = userValues[0];
            return c instanceof Number ? (Number)((Number)c) : (Number)this.nan_;
        };
    }

    public double readDoubleCoord(Tuple tuple, int icol) {
        return tuple.getDoubleValue(icol);
    }

    public static FloatingCoord createCoord(InputMeta meta, boolean isRequired) {
        return new FloatingCoord(meta, isRequired, SimpleDomain.NUMERIC_DOMAIN, PlotUtil.storeFullPrecision());
    }

    public static FloatingCoord createTimeCoord(InputMeta meta, boolean isRequired) {
        Double nan = Double.NaN;
        return new FloatingCoord(meta, isRequired, (Domain)TimeDomain.INSTANCE, true){

            @Override
            public Function<Object[], Number> inputStorage(ValueInfo[] infos, DomainMapper[] dms) {
                if (dms[0] instanceof TimeMapper) {
                    TimeMapper tMap = (TimeMapper)dms[0];
                    return userValues -> tMap.toUnixSeconds(userValues[0]);
                }
                return userValues -> Double.NaN;
            }
        };
    }
}

