/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.table.RowData;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.data.CachedColumn;
import uk.ac.starlink.ttools.plot2.data.CachedReader;
import uk.ac.starlink.ttools.plot2.data.CachedTupleSequence;
import uk.ac.starlink.ttools.plot2.data.ColumnStorage;
import uk.ac.starlink.ttools.plot2.data.CoordSpec;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.DataStoreFactory;
import uk.ac.starlink.ttools.plot2.data.DiskCache;
import uk.ac.starlink.ttools.plot2.data.MaskSpec;
import uk.ac.starlink.ttools.plot2.data.StorageType;
import uk.ac.starlink.ttools.plot2.data.TupleRunner;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.task.ConsumerTask;
import uk.ac.starlink.util.URLUtils;

public class PersistentDataStoreFactory
implements DataStoreFactory {
    private final DiskCache cache_;
    private final TupleRunner tupleRunner_;
    private final DataStore dataStore_;
    private final Set<CacheEntry> inProgress_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2.data");

    public PersistentDataStoreFactory(DiskCache cache, TupleRunner tupleRunner) {
        this.cache_ = cache == null ? new DiskCache(PersistentDataStoreFactory.toCacheDir(null), 0L) : cache;
        this.tupleRunner_ = tupleRunner == null ? TupleRunner.DEFAULT : tupleRunner;
        this.dataStore_ = new PersistentDataStore();
        this.inProgress_ = new HashSet<CacheEntry>();
    }

    public PersistentDataStoreFactory() {
        this(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStore readDataStore(DataSpec[] dataSpecs, DataStore store0) throws IOException {
        if (store0 != null) {
            boolean hasAll = true;
            for (DataSpec dspec : dataSpecs) {
                hasAll = hasAll && store0.hasData(dspec);
            }
            if (hasAll) {
                return store0;
            }
        }
        this.cache_.ready();
        HashSet<MaskSpec> mSet = new HashSet<MaskSpec>();
        HashSet<CoordSpec> cSet = new HashSet<CoordSpec>();
        HashSet<StarTable> tSet = new HashSet<StarTable>();
        for (DataSpec dspec : dataSpecs) {
            if (dspec == null) continue;
            tSet.add(dspec.getSourceTable());
            if (!dspec.isMaskTrue()) {
                mSet.add(new MaskSpec(dspec));
            }
            int nc = dspec.getCoordCount();
            for (int ic = 0; ic < nc; ++ic) {
                cSet.add(new CoordSpec(dspec, ic));
            }
        }
        HashSet<CacheEntry> waitings = new HashSet<CacheEntry>();
        LinkedHashMap<StarTable, List> tMap = new LinkedHashMap<StarTable, List>();
        Set<CacheEntry> set = this.inProgress_;
        synchronized (set) {
            for (MaskSpec mspec : mSet) {
                CacheEntry mEntry = this.createMaskCacheEntry(mspec);
                if (this.inProgress_.contains(mEntry)) {
                    waitings.add(mEntry);
                    continue;
                }
                if (mEntry.dataExists()) {
                    mEntry.touch();
                    continue;
                }
                this.inProgress_.add(mEntry);
                tMap.computeIfAbsent(mspec.getTable(), k -> new ArrayList()).add(mEntry);
            }
            for (CoordSpec cspec : cSet) {
                CacheEntry cEntry = this.createCoordCacheEntry(cspec);
                if (this.inProgress_.contains(cEntry)) {
                    waitings.add(cEntry);
                    continue;
                }
                if (cEntry.dataExists()) {
                    cEntry.touch();
                    continue;
                }
                this.inProgress_.add(cEntry);
                tMap.computeIfAbsent(cspec.getTable(), k -> new ArrayList()).add(cEntry);
            }
        }
        for (StarTable table : tMap.keySet()) {
            RowSequence rseq = table.getRowSequence();
            List tEntries = (List)tMap.get(table);
            int nent = tEntries.size();
            CoordSpec.Reader[] objRdrs = new CoordSpec.Reader[nent];
            CachedColumn[] wcols = new CachedColumn[nent];
            ArrayList<File> files = new ArrayList<File>();
            for (int ient = 0; ient < nent; ++ient) {
                CacheEntry entry = (CacheEntry)tEntries.get(ient);
                objRdrs[ient] = entry.createObjectReader((RowData)rseq);
                wcols[ient] = entry.createWriter();
                files.addAll(Arrays.asList(entry.files_));
            }
            assert (nent > 0);
            try {
                long irow = 0L;
                while (rseq.next()) {
                    for (int ient = 0; ient < nent; ++ient) {
                        wcols[ient].add(objRdrs[ient].readValue(irow));
                    }
                    ++irow;
                }
                for (int ient = 0; ient < nent; ++ient) {
                    wcols[ient].endAdd();
                }
            }
            catch (IOException e) {
                this.cache_.log("Plot cache data write failure; deleting files " + files);
                for (File f : files) {
                    f.delete();
                }
                throw e;
            }
            finally {
                rseq.close();
                Set<CacheEntry> set2 = this.inProgress_;
                synchronized (set2) {
                    this.inProgress_.removeAll(tEntries);
                    this.inProgress_.notifyAll();
                }
            }
            for (File f : files) {
                this.cache_.fileAdded(f);
            }
        }
        if (tMap.size() > 0) {
            this.cache_.tidy();
        }
        try {
            set = this.inProgress_;
            synchronized (set) {
                while (waitings.size() > 0) {
                    this.inProgress_.wait();
                    waitings.retainAll(this.inProgress_);
                }
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        return this.dataStore_;
    }

    private CacheEntry createMaskCacheEntry(final MaskSpec mspec) {
        String id = new StringBuffer().append("T-").append(DiskCache.hashText(PersistentDataStoreFactory.getTableId(mspec.getTable()))).append("-M-").append(DiskCache.hashText(PersistentDataStoreFactory.getMaskId(mspec))).toString();
        return new CacheEntry(id, StorageType.BOOLEAN){

            @Override
            CoordSpec.Reader createObjectReader(RowData rdata) {
                MaskSpec.Reader maskRdr = mspec.flagReader(rdata);
                return ir -> maskRdr.readFlag(ir);
            }
        };
    }

    private CacheEntry createCoordCacheEntry(final CoordSpec cspec) {
        String id = new StringBuffer().append("T-").append(DiskCache.hashText(PersistentDataStoreFactory.getTableId(cspec.getTable()))).append("-C-").append(DiskCache.hashText(PersistentDataStoreFactory.getCoordId(cspec))).toString();
        return new CacheEntry(id, cspec.getStorageType()){

            @Override
            CoordSpec.Reader createObjectReader(RowData rdata) {
                return cspec.valueReader(rdata);
            }
        };
    }

    public static File toCacheDir(File baseDir) {
        return DiskCache.toCacheDir(baseDir, "plot2-data");
    }

    private static String getTableId(StarTable table) {
        String identity = ConsumerTask.getIdentity(table);
        assert (identity != null);
        File file = PersistentDataStoreFactory.getUnderlyingFile(table);
        long modTime = file == null ? 0L : file.lastModified();
        identity = identity + "-@" + Long.toString(modTime);
        return identity;
    }

    private static File getUnderlyingFile(StarTable table) {
        if (table == null) {
            return null;
        }
        URL url = table.getURL();
        if (url != null) {
            return URLUtils.urlToFile((String)url.toString());
        }
        return table instanceof WrapperStarTable ? PersistentDataStoreFactory.getUnderlyingFile(((WrapperStarTable)table).getBaseTable()) : null;
    }

    private static String getMaskId(MaskSpec mspec) {
        return mspec.getMaskId();
    }

    private static String getCoordId(CoordSpec cspec) {
        return cspec.getCoordId();
    }

    private static CachedReader createTrueReader() {
        return new CachedReader(){

            @Override
            public boolean getBooleanValue(long ix) {
                return true;
            }

            @Override
            public double getDoubleValue(long ix) {
                return -1.0;
            }

            @Override
            public int getIntValue(long ix) {
                return -1;
            }

            @Override
            public long getLongValue(long ix) {
                return -1L;
            }

            @Override
            public Object getObjectValue(long ix) {
                return null;
            }
        };
    }

    private static CachedReader createBlankReader() {
        return new CachedReader(){

            @Override
            public boolean getBooleanValue(long ix) {
                return false;
            }

            @Override
            public double getDoubleValue(long ix) {
                return Double.NaN;
            }

            @Override
            public int getIntValue(long ix) {
                return 0;
            }

            @Override
            public long getLongValue(long ix) {
                return 0L;
            }

            @Override
            public Object getObjectValue(long ix) {
                return null;
            }
        };
    }

    static /* synthetic */ CachedReader access$200() {
        return PersistentDataStoreFactory.createTrueReader();
    }

    static /* synthetic */ CachedReader access$300() {
        return PersistentDataStoreFactory.createBlankReader();
    }

    @Equality
    private abstract class CacheEntry {
        private final String baseName_;
        private final ColumnStorage colStorage_;
        private final File[] files_;

        CacheEntry(String baseName, StorageType storageType) {
            this.baseName_ = baseName;
            this.colStorage_ = ColumnStorage.getStorage(storageType);
            this.files_ = this.colStorage_.getFileNames(new File(PersistentDataStoreFactory.this.cache_.getDir(), baseName));
        }

        boolean dataExists() {
            for (File file : this.files_) {
                if (file.isFile()) continue;
                return false;
            }
            return true;
        }

        long getRowCount() {
            return this.colStorage_.getDiskRowCount(this.files_);
        }

        CachedColumn createWriter() throws IOException {
            PersistentDataStoreFactory.this.cache_.log("Writing plot cache data to " + Arrays.toString(this.files_));
            return this.colStorage_.createDiskColumn(this.files_);
        }

        abstract CoordSpec.Reader createObjectReader(RowData var1);

        CachedReader createReader() throws IOException {
            return this.colStorage_.createDiskReader(this.files_);
        }

        void touch() {
            long now = System.currentTimeMillis();
            for (File file : this.files_) {
                if (file.setLastModified(now)) continue;
                logger_.warning("Touch " + file + " failed");
            }
        }

        public int hashCode() {
            int code = 55413;
            code = 23 * code + this.colStorage_.hashCode();
            for (File f : this.files_) {
                code = 23 * code + f.hashCode();
            }
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof CacheEntry) {
                CacheEntry other = (CacheEntry)o;
                return this.colStorage_.equals(other.colStorage_) && Arrays.equals(this.files_, other.files_);
            }
            return false;
        }

        public String toString() {
            return this.baseName_;
        }
    }

    private class PersistentDataStore
    implements DataStore {
        private final CachedReader TRUE_READER = PersistentDataStoreFactory.access$200();
        private final CachedReader BLANK_READER = PersistentDataStoreFactory.access$300();

        private PersistentDataStore() {
        }

        @Override
        public TupleRunner getTupleRunner() {
            return PersistentDataStoreFactory.this.tupleRunner_;
        }

        @Override
        public boolean hasData(DataSpec dspec) {
            if (!PersistentDataStoreFactory.this.createMaskCacheEntry(new MaskSpec(dspec)).dataExists()) {
                return false;
            }
            for (int ic = 0; ic < dspec.getCoordCount(); ++ic) {
                if (PersistentDataStoreFactory.this.createCoordCacheEntry(new CoordSpec(dspec, ic)).dataExists()) continue;
                return false;
            }
            return true;
        }

        @Override
        public TupleSequence getTupleSequence(DataSpec dspec) {
            CacheEntry maskEntry = PersistentDataStoreFactory.this.createMaskCacheEntry(new MaskSpec(dspec));
            int nc = dspec.getCoordCount();
            CacheEntry[] coordEntries = new CacheEntry[nc];
            for (int ic = 0; ic < nc; ++ic) {
                coordEntries[ic] = PersistentDataStoreFactory.this.createCoordCacheEntry(new CoordSpec(dspec, ic));
            }
            Supplier<CachedReader> maskSupplier = () -> {
                if (dspec.isMaskTrue()) {
                    return this.TRUE_READER;
                }
                try {
                    return maskEntry.createReader();
                }
                catch (IOException e) {
                    logger_.log(Level.WARNING, "Mask read error", e);
                    return this.TRUE_READER;
                }
            };
            Supplier<CachedReader[]> coordsSupplier = () -> {
                CachedReader[] rdrs = new CachedReader[nc];
                for (int ic = 0; ic < nc; ++ic) {
                    CachedReader rdr;
                    if (dspec.isCoordBlank(ic)) {
                        rdr = this.BLANK_READER;
                    } else {
                        try {
                            rdr = coordEntries[ic].createReader();
                        }
                        catch (IOException e) {
                            logger_.log(Level.WARNING, "Coord read error", e);
                            rdr = this.BLANK_READER;
                        }
                    }
                    rdrs[ic] = rdr;
                }
                return rdrs;
            };
            long nrow = dspec.getSourceTable().getRowCount();
            for (int ic = 0; ic < nc; ++ic) {
                if (nrow >= 0L) continue;
                nrow = coordEntries[ic].getRowCount();
            }
            return new CachedTupleSequence(maskSupplier, coordsSupplier, nrow);
        }
    }
}

