/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowData;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.DataStoreFactory;
import uk.ac.starlink.ttools.plot2.data.TupleRunner;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.data.UserDataReader;

public class SimpleDataStoreFactory
implements DataStoreFactory,
DataStore {
    private final TupleRunner runner_;
    private static Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2");

    public SimpleDataStoreFactory(TupleRunner runner) {
        this.runner_ = runner;
    }

    @Override
    public boolean hasData(DataSpec spec) {
        return true;
    }

    @Override
    public DataStore readDataStore(DataSpec[] specs, DataStore prevStore) {
        return this;
    }

    @Override
    public TupleSequence getTupleSequence(DataSpec spec) {
        StarTable table = spec.getSourceTable();
        try {
            if (table.isRandom() && table.getRowCount() > 2L) {
                return new RandomSimpleTupleSequence(spec, table);
            }
            RowSequence rseq = spec.getSourceTable().getRowSequence();
            return new SequentialSimpleTupleSequence(spec, rseq);
        }
        catch (IOException e) {
            logger_.log(Level.WARNING, "Error reading plot data", e);
            return PlotUtil.EMPTY_TUPLE_SEQUENCE;
        }
    }

    @Override
    public TupleRunner getTupleRunner() {
        return this.runner_;
    }

    private static class RandomSimpleTupleSequence
    extends SimpleTupleSequence {
        private final StarTable table_;
        private final RowAccess racc_;
        private long nrow_;

        RandomSimpleTupleSequence(DataSpec spec, StarTable table) throws IOException {
            this(spec, table, -1L, table.getRowCount());
        }

        RandomSimpleTupleSequence(DataSpec spec, StarTable table, long irow, long nrow) throws IOException {
            super(spec, (RowData)table.getRowAccess());
            this.table_ = table;
            this.racc_ = (RowAccess)this.rowdata_;
            this.irow_ = irow;
            this.nrow_ = nrow;
        }

        @Override
        public boolean next() {
            try {
                while (!this.failed_ && this.irow_ < this.nrow_ - 1L) {
                    if (!this.reader_.getMaskFlag((RowData)this.racc_, ++this.irow_)) continue;
                    this.racc_.setRowIndex(this.irow_);
                    return true;
                }
            }
            catch (IOException e) {
                this.logError(e);
            }
            return false;
        }

        public TupleSequence split() {
            if (this.nrow_ - this.irow_ > 2L) {
                RandomSimpleTupleSequence split;
                long mid = (this.irow_ + this.nrow_) / 2L;
                try {
                    split = new RandomSimpleTupleSequence(this.spec_, this.table_, this.irow_, mid);
                }
                catch (IOException e) {
                    logger_.log(Level.WARNING, "Error re-reading plot data", e);
                    return null;
                }
                this.irow_ = mid - 1L;
                return split;
            }
            return null;
        }

        public long splittableSize() {
            return this.nrow_ - this.irow_;
        }
    }

    private static class SequentialSimpleTupleSequence
    extends SimpleTupleSequence {
        private final RowSequence rseq_;

        SequentialSimpleTupleSequence(DataSpec spec, RowSequence rseq) {
            super(spec, (RowData)rseq);
            this.rseq_ = rseq;
        }

        @Override
        public boolean next() {
            try {
                while (!this.failed_ && this.rseq_.next()) {
                    if (!this.reader_.getMaskFlag((RowData)this.rseq_, ++this.irow_)) continue;
                    return true;
                }
            }
            catch (IOException e) {
                this.logError(e);
            }
            try {
                this.rseq_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }

        public TupleSequence split() {
            return null;
        }

        public long splittableSize() {
            return this.spec_.getSourceTable().getRowCount();
        }
    }

    private static abstract class SimpleTupleSequence
    implements TupleSequence {
        final DataSpec spec_;
        final RowData rowdata_;
        final UserDataReader reader_;
        final List<Function<Object[], ?>> inputStorages_;
        long irow_;
        boolean failed_;

        SimpleTupleSequence(DataSpec spec, RowData rowdata) {
            this.spec_ = spec;
            this.rowdata_ = rowdata;
            this.reader_ = spec.createUserDataReader();
            this.inputStorages_ = new ArrayList();
            for (int ic = 0; ic < spec.getCoordCount(); ++ic) {
                ValueInfo[] infos = spec.getUserCoordInfos(ic);
                DomainMapper[] dms = spec.getUserCoordMappers(ic);
                this.inputStorages_.add(spec.getCoord(ic).inputStorage(infos, dms));
            }
            this.irow_ = -1L;
        }

        @Override
        public long getRowIndex() {
            return this.irow_;
        }

        @Override
        public Object getObjectValue(int icol) {
            try {
                Object[] userCoords = this.reader_.getUserCoordValues(this.rowdata_, this.irow_, icol);
                Object value = this.inputStorages_.get(icol).apply(userCoords);
                assert (value != null);
                return value;
            }
            catch (IOException e) {
                this.logError(e);
                return null;
            }
        }

        @Override
        public double getDoubleValue(int icol) {
            Object obj = this.getObjectValue(icol);
            return obj instanceof Number ? ((Number)obj).doubleValue() : Double.NaN;
        }

        @Override
        public int getIntValue(int icol) {
            Object obj = this.getObjectValue(icol);
            return obj instanceof Number ? ((Number)obj).intValue() : Integer.MIN_VALUE;
        }

        @Override
        public long getLongValue(int icol) {
            Object obj = this.getObjectValue(icol);
            return obj instanceof Number ? ((Number)obj).longValue() : Long.MIN_VALUE;
        }

        @Override
        public boolean getBooleanValue(int icol) {
            return Boolean.TRUE.equals(this.getObjectValue(icol));
        }

        void logError(IOException err) {
            this.failed_ = true;
            logger_.log(Level.WARNING, "Error reading plot data - truncating sequence", err);
        }
    }
}

