/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import uk.ac.starlink.ttools.plot2.data.CachedColumn;
import uk.ac.starlink.ttools.plot2.data.CachedColumnFactory;
import uk.ac.starlink.ttools.plot2.data.CachedReader;
import uk.ac.starlink.ttools.plot2.data.MemoryColumnFactory;
import uk.ac.starlink.ttools.plot2.data.StorageType;

public class SmartColumnFactory
implements CachedColumnFactory {
    private final CachedColumnFactory bulkColumnFactory_;
    private final CachedColumnFactory singleColumnFactory_;
    private static final Map<StorageType, ValueComparison> comparisonMap_ = SmartColumnFactory.createComparisonMap();

    public SmartColumnFactory(CachedColumnFactory bulkColumnFactory) {
        this.bulkColumnFactory_ = bulkColumnFactory;
        this.singleColumnFactory_ = new MemoryColumnFactory();
    }

    @Override
    public CachedColumn createColumn(StorageType type, long nrow) {
        return new SmartCachedColumn(type, nrow);
    }

    private static Map<StorageType, ValueComparison> createComparisonMap() {
        HashMap<StorageType, ValueComparison> map = new HashMap<StorageType, ValueComparison>();
        ValueComparison immutableComparison = new ValueComparison(){

            @Override
            public boolean equalValues(Object v1, Object v2) {
                return v1.equals(v2);
            }

            @Override
            public Object copyValue(Object v) {
                return v;
            }
        };
        map.put(StorageType.BOOLEAN, immutableComparison);
        map.put(StorageType.DOUBLE, immutableComparison);
        map.put(StorageType.FLOAT, immutableComparison);
        map.put(StorageType.LONG, immutableComparison);
        map.put(StorageType.INT, immutableComparison);
        map.put(StorageType.SHORT, immutableComparison);
        map.put(StorageType.BYTE, immutableComparison);
        map.put(StorageType.STRING, immutableComparison);
        map.put(StorageType.INT3, new ValueComparison(){

            @Override
            public boolean equalValues(Object v1, Object v2) {
                return Arrays.equals((int[])v1, (int[])v2);
            }

            @Override
            public Object copyValue(Object v) {
                return ((int[])v).clone();
            }
        });
        map.put(StorageType.DOUBLE3, new ValueComparison(){

            @Override
            public boolean equalValues(Object v1, Object v2) {
                return Arrays.equals((double[])v1, (double[])v2);
            }

            @Override
            public Object copyValue(Object v) {
                return ((double[])v).clone();
            }
        });
        map.put(StorageType.FLOAT3, new ValueComparison(){

            @Override
            public boolean equalValues(Object v1, Object v2) {
                return Arrays.equals((float[])v1, (float[])v2);
            }

            @Override
            public Object copyValue(Object v) {
                return ((float[])v).clone();
            }
        });
        map.put(StorageType.DOUBLE_ARRAY, new ValueComparison(){

            @Override
            public boolean equalValues(Object v1, Object v2) {
                return Arrays.equals((double[])v1, (double[])v2);
            }

            @Override
            public Object copyValue(Object v) {
                return ((double[])v).clone();
            }
        });
        map.put(StorageType.FLOAT_ARRAY, new ValueComparison(){

            @Override
            public boolean equalValues(Object v1, Object v2) {
                return Arrays.equals((float[])v1, (float[])v2);
            }

            @Override
            public Object copyValue(Object v) {
                return ((float[])v).clone();
            }
        });
        assert (map.keySet().containsAll(Arrays.asList(StorageType.values())));
        return Collections.unmodifiableMap(map);
    }

    private static interface ValueComparison {
        public boolean equalValues(Object var1, Object var2);

        public Object copyValue(Object var1);
    }

    private static class ConstantReader
    implements CachedReader {
        private final boolean booleanValue_;
        private final int intValue_;
        private final long longValue_;
        private final double doubleValue_;
        private final Object objectValue_;

        ConstantReader(CachedColumn col1) {
            if (col1.getRowCount() > 0L) {
                CachedReader constRdr = col1.createReader();
                this.booleanValue_ = constRdr.getBooleanValue(0L);
                this.intValue_ = constRdr.getIntValue(0L);
                this.longValue_ = constRdr.getLongValue(0L);
                this.doubleValue_ = constRdr.getDoubleValue(0L);
                this.objectValue_ = constRdr.getObjectValue(0L);
            } else {
                this.booleanValue_ = false;
                this.intValue_ = Integer.MIN_VALUE;
                this.longValue_ = Long.MIN_VALUE;
                this.doubleValue_ = Double.NaN;
                this.objectValue_ = null;
            }
        }

        @Override
        public boolean getBooleanValue(long ix) {
            return this.booleanValue_;
        }

        @Override
        public int getIntValue(long ix) {
            return this.intValue_;
        }

        @Override
        public long getLongValue(long ix) {
            return this.longValue_;
        }

        @Override
        public double getDoubleValue(long ix) {
            return this.doubleValue_;
        }

        @Override
        public Object getObjectValue(long ix) {
            return this.objectValue_;
        }
    }

    private class SmartCachedColumn
    implements CachedColumn {
        private final StorageType type_;
        private final long nrow_;
        private final ValueComparison comparison_;
        private CachedColumn constCol_;
        private CachedColumn bulkCol_;
        private Object value1_;
        private long constCount_;
        private long count_;

        SmartCachedColumn(StorageType type, long nrow) {
            this.type_ = type;
            this.nrow_ = nrow;
            this.comparison_ = (ValueComparison)comparisonMap_.get((Object)type);
            this.constCol_ = SmartColumnFactory.this.singleColumnFactory_.createColumn(type, 1L);
        }

        @Override
        public void add(Object value) throws IOException {
            ++this.count_;
            if (this.bulkCol_ != null) {
                this.bulkCol_.add(value);
            } else if (this.constCount_ == 0L) {
                assert (this.value1_ == null);
                this.value1_ = this.comparison_.copyValue(value);
                this.constCol_.add(value);
                ++this.constCount_;
            } else if (this.comparison_.equalValues(this.value1_, value)) {
                ++this.constCount_;
            } else {
                this.constCol_ = null;
                this.bulkCol_ = SmartColumnFactory.this.bulkColumnFactory_.createColumn(this.type_, this.nrow_);
                int i = 0;
                while ((long)i < this.constCount_) {
                    this.bulkCol_.add(this.value1_);
                    ++i;
                }
                this.bulkCol_.add(value);
            }
        }

        @Override
        public void endAdd() throws IOException {
            (this.bulkCol_ != null ? this.bulkCol_ : this.constCol_).endAdd();
        }

        @Override
        public long getRowCount() {
            return this.count_;
        }

        @Override
        public CachedReader createReader() {
            return this.bulkCol_ != null ? this.bulkCol_.createReader() : new ConstantReader(this.constCol_);
        }
    }
}

