/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.util.Arrays;
import uk.ac.starlink.ttools.plot2.PlotUtil;

public class LabelUnit
implements Comparable<LabelUnit> {
    private final String name_;
    private final double factor_;

    public LabelUnit(String name, double factor) {
        this.name_ = name;
        this.factor_ = factor;
    }

    public String getName() {
        return this.name_;
    }

    public double getFactor() {
        return this.factor_;
    }

    @Override
    public int compareTo(LabelUnit other) {
        return Double.compare(this.getFactor(), other.getFactor());
    }

    public static LabelUnit getUnit(double value, LabelUnit[] units) {
        LabelUnit[] sunits = (LabelUnit[])units.clone();
        Arrays.sort(units);
        for (int i = 1; i < sunits.length; ++i) {
            if (!(value < units[i].factor_)) continue;
            return units[i - 1];
        }
        return units[units.length - 1];
    }

    public static String formatValue(double value, double eps, LabelUnit[] units) {
        LabelUnit unit = LabelUnit.getUnit(value, units);
        double factor = unit.getFactor();
        return PlotUtil.formatNumber(value / factor, eps / factor) + unit.getName();
    }
}

