/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.SkyCoord;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.geom.Rotation;
import uk.ac.starlink.ttools.plot2.geom.SkySys;

public abstract class SkyDataGeom
implements DataGeom {
    private final String variantName_;
    private final SkySys viewSys_;
    private static final SkyCoord SKY_COORD = SkyCoord.createCoord(SkyCoord.SkyVariant.SURFACE, true);
    public static final SkyDataGeom GENERIC = SkyDataGeom.createGeom(null, null);

    protected SkyDataGeom(String variantName, SkySys viewSys) {
        this.variantName_ = variantName;
        this.viewSys_ = viewSys;
    }

    @Override
    public int getDataDimCount() {
        return 3;
    }

    @Override
    public String getVariantName() {
        return this.variantName_;
    }

    @Override
    public Coord[] getPosCoords() {
        return new Coord[]{SKY_COORD};
    }

    @Override
    public boolean readDataPos(Tuple tuple, int ic, double[] dpos) {
        return SKY_COORD.readSkyCoord(tuple, ic, dpos);
    }

    public abstract void rotate(double[] var1);

    public abstract void unrotate(double[] var1);

    public SkySys getViewSystem() {
        return this.viewSys_;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public static SkyDataGeom createGeom(SkySys userSys, SkySys viewSys) {
        if (userSys == null || viewSys == null) {
            return new UnitSkyDataGeom("generic", null);
        }
        if (userSys == viewSys) {
            return new UnitSkyDataGeom(userSys.toString(), viewSys);
        }
        return new RotateSkyDataGeom(userSys + "-" + viewSys, viewSys, Rotation.createRotation(userSys, viewSys));
    }

    private static class RotateSkyDataGeom
    extends SkyDataGeom {
        private final Rotation rotation_;
        private final Rotation inverseRotation_;

        RotateSkyDataGeom(String variantName, SkySys viewSys, Rotation rotation) {
            super(variantName, viewSys);
            this.rotation_ = rotation;
            this.inverseRotation_ = rotation.invert();
        }

        @Override
        public boolean readDataPos(Tuple tuple, int ic, double[] dpos) {
            if (super.readDataPos(tuple, ic, dpos)) {
                this.rotation_.rotate(dpos);
                return true;
            }
            return false;
        }

        @Override
        public void rotate(double[] dpos) {
            this.rotation_.rotate(dpos);
        }

        @Override
        public void unrotate(double[] dpos) {
            this.inverseRotation_.rotate(dpos);
        }

        @Override
        public int hashCode() {
            int code = 55442;
            code = 23 * code + this.rotation_.hashCode();
            return code;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof RotateSkyDataGeom) {
                RotateSkyDataGeom other = (RotateSkyDataGeom)o;
                return this.rotation_.equals(other.rotation_);
            }
            return false;
        }
    }

    private static class UnitSkyDataGeom
    extends SkyDataGeom {
        UnitSkyDataGeom(String variantName, SkySys viewSys) {
            super(variantName, viewSys);
        }

        @Override
        public void rotate(double[] dpos) {
        }

        @Override
        public void unrotate(double[] dpos) {
        }

        @Override
        public int hashCode() {
            int code = UnitSkyDataGeom.class.hashCode();
            return code;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof UnitSkyDataGeom) {
                UnitSkyDataGeom other = (UnitSkyDataGeom)o;
                return true;
            }
            return false;
        }
    }
}

