/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import uk.ac.starlink.pal.Pal;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.plot.Matrices;
import uk.ac.starlink.ttools.plot2.PlotUtil;

public class SkySys {
    private final String name_;
    private final String description_;
    private final String lonName_;
    private final String latName_;
    private final String ucd1pBase_;
    private final String ucd1Base_;
    private final String lonLabel_;
    private final String latLabel_;
    private final String[][] namePairs_;
    private final double[] toEq_;
    public static final SkySys EQUATORIAL;
    public static final SkySys GALACTIC;
    public static final SkySys SUPERGALACTIC;
    public static final SkySys ECLIPTIC2000;
    private static double[] EQ2GAL;
    private static double[] GAL2SUP;
    private static final SkySys[] KNOWN_SYSTEMS;

    private SkySys(String name, String description, String lonName, String latName, String ucd1pBase, String ucd1Base, String lonLabel, String latLabel, String[][] namePairs, double[] toEquatorial) {
        this.name_ = name;
        this.description_ = description;
        this.lonName_ = lonName;
        this.latName_ = latName;
        this.ucd1pBase_ = ucd1pBase;
        this.ucd1Base_ = ucd1Base;
        this.lonLabel_ = lonLabel;
        this.latLabel_ = latLabel;
        this.namePairs_ = namePairs;
        this.toEq_ = toEquatorial;
        if (this.toEq_.length != 9) {
            throw new IllegalArgumentException();
        }
    }

    public String getSysName() {
        return this.name_;
    }

    public String getSysDescription() {
        return this.description_;
    }

    public String getLongitudeName() {
        return this.lonName_;
    }

    public String getLatitudeName() {
        return this.latName_;
    }

    public double[] toEquatorial() {
        return (double[])this.toEq_.clone();
    }

    public int[] getCoordPair(ValueInfo[] infos) {
        int ninfo = infos.length;
        String[] ucds = new String[ninfo];
        String[] names = new String[ninfo];
        for (int i = 0; i < ninfo; ++i) {
            ucds[i] = infos[i].getUCD();
            names[i] = infos[i].getName();
        }
        String lonUcd1p = "pos." + this.ucd1pBase_ + "." + this.lonLabel_;
        String latUcd1p = "pos." + this.ucd1pBase_ + "." + this.latLabel_;
        String lonUcd1 = "POS_" + this.ucd1Base_ + "_" + this.lonLabel_.toUpperCase();
        String latUcd1 = "POS_" + this.ucd1Base_ + "_" + this.latLabel_.toUpperCase();
        int[] pair = new int[]{-1, -1};
        if (SkySys.getPair(pair, ucds, lonUcd1p + ";meta.main", latUcd1p + ";meta.main") || SkySys.getPair(pair, ucds, lonUcd1p, latUcd1p) || SkySys.getPair(pair, ucds, lonUcd1 + "_MAIN", latUcd1 + "_MAIN") || SkySys.getPair(pair, ucds, lonUcd1, latUcd1)) {
            return pair;
        }
        for (int is = 0; is < this.namePairs_.length; ++is) {
            String[] np = this.namePairs_[is];
            if (!SkySys.getPair(pair, names, np[0], np[1])) continue;
            return pair;
        }
        return null;
    }

    private static boolean getPair(int[] pair, String[] options, String lonValue, String latValue) {
        String lonval = lonValue.toLowerCase();
        String latval = latValue.toLowerCase();
        int ilon = -1;
        int ilat = -1;
        for (int iopt = 0; iopt < options.length; ++iopt) {
            String option = options[iopt];
            if (option == null) continue;
            if (lonval.equals(option = option.toLowerCase())) {
                ilon = iopt;
            }
            if (!latval.equals(option)) continue;
            ilat = iopt;
        }
        if (ilon >= 0 && ilat >= 0) {
            pair[0] = ilon;
            pair[1] = ilat;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.name_;
    }

    public static SkySys[] getKnownSystems(boolean includeNull) {
        SkySys[] skySysArray;
        if (includeNull) {
            SkySys[] skySysArray2 = new SkySys[1];
            skySysArray = skySysArray2;
            skySysArray2[0] = null;
        } else {
            skySysArray = new SkySys[]{};
        }
        return PlotUtil.arrayConcat(skySysArray, KNOWN_SYSTEMS);
    }

    static {
        EQ2GAL = new double[]{-0.054875539726, -0.87343710801, -0.483834985808, 0.494109453312, -0.444829589425, 0.74698225181, -0.867666135858, -0.198076386122, 0.455983795705};
        GAL2SUP = new double[]{-0.735742574804, 0.677261296414, 0.0, -0.074553778365, -0.080991471307, 0.9939225904, 0.673145302109, 0.731271165817, 0.110081262225};
        EQUATORIAL = new SkySys("Equatorial", "J2000 equatorial system", "Right Ascension", "Declination", "eq", "EQ", "ra", "dec", new String[][]{{"ra", "dec"}, {"alpha", "delta"}, {"ra2000", "dec2000"}, {"ra2000", "de2000"}, {"_RAJ2000", "_DEJ2000"}, {"right_ascension", "declination"}}, new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0});
        GALACTIC = new SkySys("Galactic", "IAU 1958 galactic system", "Galactic Longitude", "Galactic Latitude", "galactic", "GAL", "lon", "lat", new String[][]{{"gal_lon", "gal_lat"}, {"gal_lon", "gal_lat"}, {"glon", "glat"}, {"glong", "glat"}}, Matrices.invert(EQ2GAL));
        KNOWN_SYSTEMS = new SkySys[]{EQUATORIAL, GALACTIC, SUPERGALACTIC = new SkySys("SuperGalactic", "De Vaucouleurs supergalactic system", "Super-Galactic Longitude", "Super-Galactic Latitude", "supergalactic", "SG", "lon", "lat", new String[0][], Matrices.mmMult(Matrices.invert(EQ2GAL), Matrices.invert(GAL2SUP))), ECLIPTIC2000 = new SkySys("Ecliptic", "ecliptic system based on conversion at 2000.0", "Ecliptic Longitude", "Ecliptic Latitude", "ecliptic2000", "EC", "lon", "lat", new String[0][], Matrices.invert(Matrices.fromPal(new Pal().Ecmat(51544.0))))};
    }
}

