/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.layer.CartesianMultiPointCoordSet;

public class CartesianErrorCoordSet
implements CartesianMultiPointCoordSet {
    private final int nSpaceDim_;
    private final int nErrDim_;
    private final int[] iErrDims_;
    private final FloatingCoord[] pCoords_;
    private final FloatingCoord[] mCoords_;

    public CartesianErrorCoordSet(String[] axisNames, int[] iErrDims) {
        this.nSpaceDim_ = axisNames.length;
        this.iErrDims_ = iErrDims;
        this.nErrDim_ = iErrDims.length;
        this.pCoords_ = new FloatingCoord[this.nErrDim_];
        this.mCoords_ = new FloatingCoord[this.nErrDim_];
        for (int jdim = 0; jdim < this.nErrDim_; ++jdim) {
            int iErrDim = iErrDims[jdim];
            String axName = axisNames[iErrDim];
            String axname = axName.toLowerCase();
            this.pCoords_[jdim] = FloatingCoord.createCoord(new InputMeta(axname + "errhi", axName + " Positive Error").setShortDescription("Error in " + axName + " positive direction").setXmlDescription(new String[]{"<p>Error in the " + axName + " coordinate", "in the positive direction.", "If no corresponding negative error value is supplied,", "then this value is also used in the negative", "direction, i.e. in that case errors are assumed", "to be symmetric.", "</p>"}), false);
            this.mCoords_[jdim] = FloatingCoord.createCoord(new InputMeta(axname + "errlo", axName + " Negative Error").setShortDescription("Error in " + axName + " negative direction").setXmlDescription(new String[]{"<p>Error in the " + axName + " coordinate", "in the negative direction.", "If left blank, it is assumed to take the same value", "as the positive error.", "</p>"}), false);
        }
    }

    @Override
    public Coord[] getCoords() {
        Coord[] coords = new Coord[this.nErrDim_ * 2];
        for (int jdim = 0; jdim < this.nErrDim_; ++jdim) {
            coords[jdim * 2 + 0] = this.pCoords_[jdim];
            coords[jdim * 2 + 1] = this.mCoords_[jdim];
        }
        return coords;
    }

    @Override
    public int getPointCount() {
        return this.nErrDim_ * 2;
    }

    @Override
    public boolean readPoints(Tuple tuple, int icol, double[] dpos0, double[][] dposExtras) {
        boolean hasErrors = false;
        for (int jdim = 0; jdim < this.nErrDim_; ++jdim) {
            int iErrDim = this.iErrDims_[jdim];
            int pIndex = jdim * 2 + 0;
            int mIndex = jdim * 2 + 1;
            double pErr = this.pCoords_[jdim].readDoubleCoord(tuple, icol + pIndex);
            double mErr = this.mCoords_[jdim].readDoubleCoord(tuple, icol + mIndex);
            if (Double.isNaN(mErr)) {
                mErr = pErr;
            }
            boolean pOk = pErr > 0.0;
            boolean mOk = mErr > 0.0;
            double[] pDpos = dposExtras[pIndex];
            double[] mDpos = dposExtras[mIndex];
            for (int i = 0; i < this.nSpaceDim_; ++i) {
                double dp;
                pDpos[i] = dp = dpos0[i];
                mDpos[i] = dp;
            }
            if (pOk) {
                int n = iErrDim;
                pDpos[n] = pDpos[n] + pErr;
            }
            if (mOk) {
                int n = iErrDim;
                mDpos[n] = mDpos[n] - mErr;
            }
            hasErrors = hasErrors || pOk || mOk;
        }
        return hasErrors;
    }

    public static CartesianErrorCoordSet createAllAxesErrorCoordSet(String[] axisNames) {
        int ndim = axisNames.length;
        int[] idims = new int[ndim];
        for (int i = 0; i < ndim; ++i) {
            idims[i] = i;
        }
        return new CartesianErrorCoordSet(axisNames, idims);
    }

    public static CartesianErrorCoordSet createSingleAxisErrorCoordSet(int ndim, int iErrDim, String errAxisName) {
        String[] axisNames = new String[ndim];
        axisNames[iErrDim] = errAxisName;
        int[] iErrDims = new int[]{iErrDim};
        return new CartesianErrorCoordSet(axisNames, iErrDims);
    }
}

