/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.geom.Point2D;
import java.util.function.BiConsumer;
import javax.swing.Icon;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot2.AuxReader;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Ranger;
import uk.ac.starlink.ttools.plot2.Scaling;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.MultiPointConfigKey;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.layer.CartesianMultiPointCoordSet;
import uk.ac.starlink.ttools.plot2.layer.MultiPointForm;
import uk.ac.starlink.ttools.plot2.layer.MultiPointReader;

public class CartesianMultiPointForm
extends MultiPointForm {
    private final CartesianMultiPointCoordSet extraCoordSet_;
    private final boolean canScale_;

    public CartesianMultiPointForm(String name, Icon icon, String description, CartesianMultiPointCoordSet extraCoordSet, MultiPointConfigKey shapeKey, boolean canScale) {
        ConfigKey[] configKeyArray;
        ConfigKey<Double> configKey = canScale ? StyleKeys.SCALE : null;
        if (canScale) {
            ConfigKey[] configKeyArray2 = new ConfigKey[1];
            configKeyArray = configKeyArray2;
            configKeyArray2[0] = StyleKeys.AUTOSCALE;
        } else {
            configKeyArray = new ConfigKey[]{};
        }
        super(name, icon, description, extraCoordSet, shapeKey, configKey, configKeyArray);
        this.extraCoordSet_ = extraCoordSet;
        this.canScale_ = canScale;
    }

    @Override
    protected MultiPointReader createReader(ConfigMap config) {
        boolean isAutoscale = this.canScale_ && config.get(StyleKeys.AUTOSCALE) != false;
        return new CartesianMultiPointReader(this.extraCoordSet_, isAutoscale);
    }

    public static MultiPointForm createErrorForm(String name, CartesianMultiPointCoordSet extraCoordSet, MultiPointConfigKey shapeKey) {
        String descrip = String.join((CharSequence)"\n", "<p>Plots symmetric or asymmetric error bars in some or", "all of the plot dimensions.", "The shape of the error \"bars\" is quite configurable,", "including (for 2-d and 3-d errors)", "ellipses, rectangles etc aligned with the axes.", "</p>");
        return new CartesianMultiPointForm(name, ResourceIcon.FORM_ERROR, descrip, extraCoordSet, shapeKey, false);
    }

    public static MultiPointForm createVectorForm(String name, CartesianMultiPointCoordSet extraCoordSet, boolean canScale) {
        String descrip = String.join((CharSequence)"\n", "<p>Plots directed lines from the data position", "given delta values for the coordinates.", "The plotted markers are typically little arrows,", "but there are other options.", "</p>");
        if (canScale) {
            descrip = descrip + CartesianMultiPointForm.getDefaultScalingDescription("vector");
        }
        return new CartesianMultiPointForm(name, ResourceIcon.FORM_VECTOR, descrip, extraCoordSet, StyleKeys.VECTOR_SHAPE, canScale);
    }

    private static class CartesianMultiPointReader
    implements MultiPointReader {
        private final CartesianMultiPointCoordSet extraCoordSet_;
        private final boolean isAutoscale_;

        CartesianMultiPointReader(CartesianMultiPointCoordSet extraCoordSet, boolean isAutoscale) {
            this.extraCoordSet_ = extraCoordSet;
            this.isAutoscale_ = isAutoscale;
        }

        @Override
        public boolean isAutoscale() {
            return this.isAutoscale_;
        }

        @Override
        public CartesianMultiPointCoordSet getExtraCoordSet() {
            return this.extraCoordSet_;
        }

        @Override
        public double getBaseScale(Surface surface, Span sizeSpan) {
            if (sizeSpan == null) {
                return 1.0;
            }
            double[] bounds = sizeSpan.getFiniteBounds(false);
            double gmax = Math.max(-bounds[0], bounds[1]);
            assert (gmax >= 0.0);
            return gmax == 0.0 ? 1.0 : 32.0 / gmax;
        }

        @Override
        public MultiPointReader.ExtrasReader createExtrasReader(DataGeom geom, Span sizeSpan) {
            final int icExtra = MultiPointForm.getExtrasCoordIndex(geom);
            return new MultiPointReader.ExtrasReader(){

                @Override
                public boolean readPoints(Tuple tuple, double[] dpos0, double[][] dposExtras) {
                    return extraCoordSet_.readPoints(tuple, icExtra, dpos0, dposExtras);
                }
            };
        }

        @Override
        public AuxReader createSizeReader(final DataGeom geom) {
            boolean scaleFromVisible = true;
            Span dummySpan = null;
            final MultiPointReader.ExtrasReader extrasReader = this.createExtrasReader(geom, dummySpan);
            final int ndim = geom.getDataDimCount();
            final int nextra = this.extraCoordSet_.getPointCount();
            return new AuxReader(){

                @Override
                public int getCoordIndex() {
                    return -1;
                }

                @Override
                public ValueInfo getAxisInfo(DataSpec dataSpec) {
                    return null;
                }

                @Override
                public Scaling getScaling() {
                    return null;
                }

                @Override
                public void adjustAuxRange(Surface surface, DataSpec dataSpec, DataStore dataStore, Object[] plans, Ranger ranger) {
                    BiConsumer<TupleSequence, Ranger> rangeFiller = (tseq, r) -> this.fillRange((TupleSequence)tseq, (Ranger)r, surface);
                    dataStore.getTupleRunner().rangeData(rangeFiller, ranger, dataSpec, dataStore);
                }

                private void fillRange(TupleSequence tseq, Ranger ranger, Surface surface) {
                    double[] dpos0 = new double[ndim];
                    double[][] dposExtras = new double[nextra][ndim];
                    Point2D.Double gpos0 = new Point2D.Double();
                    Point2D.Double gpos1 = new Point2D.Double();
                    while (tseq.next()) {
                        if (!geom.readDataPos(tseq, 0, dpos0) || !surface.dataToGraphics(dpos0, true, gpos0) || !PlotUtil.isPointFinite(gpos0) || !extrasReader.readPoints(tseq, dpos0, dposExtras)) continue;
                        for (int ie = 0; ie < nextra; ++ie) {
                            if (!surface.dataToGraphicsOffset(dpos0, gpos0, dposExtras[ie], false, gpos1) || !PlotUtil.isPointFinite(gpos1)) continue;
                            ranger.submitDatum(gpos1.x - gpos0.x);
                            ranger.submitDatum(gpos1.y - gpos0.y);
                        }
                    }
                }
            };
        }

        public int hashCode() {
            int code = 88165;
            code = 23 * this.extraCoordSet_.hashCode();
            code = 23 * (this.isAutoscale_ ? 23 : 27);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof CartesianMultiPointReader) {
                CartesianMultiPointReader other = (CartesianMultiPointReader)o;
                return this.extraCoordSet_.equals(other.extraCoordSet_) && this.isAutoscale_ == other.isAutoscale_;
            }
            return false;
        }
    }
}

