/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.layer.MarkerShape;
import uk.ac.starlink.ttools.plot2.layer.MarkerStyle;
import uk.ac.starlink.ttools.plot2.layer.Pixers;

public class FatMarkerShapes {
    public static final int IFAT = 1;
    public static final MarkerShape FAT_CIRCLE = new FatOpenShape("fat circle", 1, false, MarkerShape.OPEN_CIRCLE, MarkerShape.FILLED_CIRCLE);
    public static final MarkerShape FAT_SQUARE = new FatOpenShape("fat square", 1, false, MarkerShape.OPEN_SQUARE, MarkerShape.FILLED_SQUARE);
    public static final MarkerShape FAT_DIAMOND = new FatOpenShape("fat diamond", 1, true, MarkerShape.OPEN_DIAMOND, MarkerShape.FILLED_DIAMOND);
    public static final MarkerShape FAT_TRIANGLE_UP = new FatOpenShape("fat triangle up", 1, true, MarkerShape.OPEN_TRIANGLE_UP, MarkerShape.FILLED_TRIANGLE_UP);
    public static final MarkerShape FAT_TRIANGLE_DOWN = new FatOpenShape("fat triangle down", 1, true, MarkerShape.OPEN_TRIANGLE_DOWN, MarkerShape.FILLED_TRIANGLE_DOWN);
    public static final MarkerShape FAT_CROSS = new FatCross("fat cross", 1);
    public static final MarkerShape FAT_CROXX = new FatCroxx("fat x", 1);

    private static class FatCroxx
    extends MarkerShape {
        private final int ifat_;

        public FatCroxx(String name, int ifat) {
            super(name);
            this.ifat_ = ifat;
        }

        @Override
        public MarkerStyle getStyle(Color color, int size) {
            BasicStroke stroke = new BasicStroke(this.ifat_ * 2, 1, 1);
            Consumer<Graphics> drawShape = g -> {
                Graphics2D g2 = (Graphics2D)g;
                Stroke stroke0 = g2.getStroke();
                g2.setStroke(stroke);
                g2.drawLine(-size, -size, size, size);
                g2.drawLine(size, -size, -size, size);
                g2.setStroke(stroke0);
            };
            HashSet<Point> points = new HashSet<Point>();
            for (int i = 1 - size; i < size; ++i) {
                for (int j = -this.ifat_; j <= this.ifat_; ++j) {
                    points.add(new Point(i + j, i));
                    points.add(new Point(i + j, -i));
                }
            }
            int s1 = size - 1;
            points.add(new Point(-s1, -size));
            points.add(new Point(-s1, size));
            points.add(new Point(s1, -size));
            points.add(new Point(s1, size));
            points.add(new Point(-size, -size));
            points.add(new Point(-size, size));
            points.add(new Point(size, -size));
            points.add(new Point(size, size));
            Pixer pixer = Pixers.createPointsPixer(points.toArray(new Point[0]));
            return new MarkerStyle((MarkerShape)this, color, size, drawShape, pixer);
        }
    }

    private static class FatCross
    extends MarkerShape {
        private final int ifat_;

        public FatCross(String name, int ifat) {
            super(name);
            this.ifat_ = ifat;
        }

        @Override
        public MarkerStyle getStyle(Color color, int size) {
            Integer otherAtts = this.ifat_ << 16 | size;
            int s1 = 2 * size + 1;
            int s2 = 2 * this.ifat_ + 1;
            Consumer<Graphics> drawShape = g -> {
                g.fillRect(-size, -this.ifat_, s1, s2);
                g.fillRect(-this.ifat_, -size, s2, s1);
            };
            return new MarkerStyle((MarkerShape)this, color, size, size + 1, drawShape);
        }
    }

    private static class FatOpenShape
    extends MarkerShape {
        private final int ifat_;
        private final boolean isBoost_;
        private final MarkerShape openShape_;
        private final MarkerShape fillShape_;
        private final BasicStroke stroke_;

        FatOpenShape(String name, int ifat, boolean isBoost, MarkerShape openShape, MarkerShape fillShape) {
            super(name);
            this.ifat_ = ifat;
            this.isBoost_ = isBoost;
            this.openShape_ = openShape;
            this.fillShape_ = fillShape;
            this.stroke_ = new BasicStroke(ifat * 2);
        }

        @Override
        public MarkerStyle getStyle(Color color, int size) {
            MarkerStyle openStyle = this.openShape_.getStyle(color, size - this.ifat_ + (this.isBoost_ ? 1 : 0));
            Consumer<Graphics> drawShape = g -> {
                Graphics2D g2 = (Graphics2D)g;
                Stroke stroke0 = g2.getStroke();
                g2.setStroke(this.stroke_);
                openStyle.drawShape(g2);
                g2.setStroke(stroke0);
            };
            Pixer pixer = this.createPixer(size);
            return new MarkerStyle((MarkerShape)this, color, size, drawShape, pixer);
        }

        private Pixer createPixer(int size) {
            Set<Point> points = this.getFillPoints(size + (this.isBoost_ ? 1 : 0));
            int innerSize = size - (this.ifat_ * 2 + 0);
            if (innerSize > 0) {
                points.removeAll(this.getFillPoints(innerSize));
            }
            return Pixers.createPointsPixer(points.toArray(new Point[0]));
        }

        private Set<Point> getFillPoints(int size) {
            HashSet<Point> set = new HashSet<Point>();
            Pixer pixer = this.fillShape_.getStyle(Color.BLACK, size).getPixerFactory().createPixer();
            while (pixer.next()) {
                set.add(new Point(pixer.getX(), pixer.getY()));
            }
            return set;
        }
    }
}

