/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Rectangle;
import java.util.Arrays;
import java.util.function.IntSupplier;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.PlotUtil;

public class FillPixer
implements Pixer {
    private final int np_;
    private final boolean hasBounds_;
    private final int[] us_;
    private final int[] vs_;
    private final int umin_;
    private final int umax_;
    private final int vmin_;
    private final int vmax_;
    private final double[] grads_;
    private final IntSupplier getX_;
    private final IntSupplier getY_;
    private final int[] nodes_;
    private int nspan_;
    private int ispan_;
    private int spanhi_;
    private int u_;
    private int v_;
    private static final boolean OPTIMISE_XY = false;

    public FillPixer(int[] xs, int[] ys, int np, Rectangle bounds) {
        int ip;
        this.np_ = np;
        this.nodes_ = new int[np];
        int xlo = xs[0];
        int xhi = xs[0];
        int ylo = ys[0];
        int yhi = ys[0];
        for (ip = 1; ip < np; ++ip) {
            int x = xs[ip];
            int y = ys[ip];
            xlo = Math.min(xlo, x);
            xhi = Math.max(xhi, x);
            ylo = Math.min(ylo, y);
            yhi = Math.max(yhi, y);
        }
        if (bounds == null) {
            this.hasBounds_ = false;
        } else {
            boolean hasBounds = false;
            int bxlo = bounds.x;
            int bxhi = bounds.x + bounds.width - 1;
            int bylo = bounds.y;
            int byhi = bounds.y + bounds.height - 1;
            if (bxlo > xlo) {
                xlo = bxlo;
                hasBounds = true;
            }
            if (bylo > ylo) {
                ylo = bylo;
                hasBounds = true;
            }
            if (bxhi < xhi) {
                xhi = bxhi;
                hasBounds = true;
            }
            if (byhi < yhi) {
                yhi = byhi;
                hasBounds = true;
            }
            this.hasBounds_ = hasBounds;
        }
        this.us_ = xs;
        this.vs_ = ys;
        this.umin_ = xlo;
        this.umax_ = xhi;
        this.vmin_ = ylo;
        this.vmax_ = yhi;
        this.getX_ = () -> this.u_;
        this.getY_ = () -> this.v_;
        this.grads_ = new double[np];
        for (ip = 0; ip < np; ++ip) {
            int ip1 = (ip + 1) % np;
            this.grads_[ip] = (double)(this.us_[ip1] - this.us_[ip]) / (double)(this.vs_[ip1] - this.vs_[ip]);
        }
        this.v_ = this.vmin_ - 1;
    }

    @Override
    public boolean next() {
        while (++this.u_ > this.spanhi_) {
            while (++this.ispan_ >= this.nspan_) {
                if (++this.v_ > this.vmax_) {
                    return false;
                }
                this.updateSpans(this.v_);
                --this.ispan_;
            }
            this.u_ = this.nodes_[this.ispan_ * 2];
            this.spanhi_ = this.nodes_[this.ispan_ * 2 + 1];
        }
        return true;
    }

    @Override
    public int getX() {
        return this.getX_.getAsInt();
    }

    @Override
    public int getY() {
        return this.getY_.getAsInt();
    }

    private void updateSpans(int v) {
        int in = 0;
        for (int ip = 0; ip < this.np_; ++ip) {
            int ip1;
            int v1;
            int v0 = this.vs_[ip];
            if (!(v >= v0 ^ v >= (v1 = this.vs_[ip1 = (ip + 1) % this.np_]))) continue;
            this.nodes_[in++] = this.us_[ip] + PlotUtil.ifloor(this.grads_[ip] * (double)(v - v0));
        }
        assert (in % 2 == 0);
        this.nspan_ = in / 2;
        this.ispan_ = 0;
        if (this.ispan_ < this.nspan_) {
            Arrays.sort(this.nodes_, 0, in);
            if (this.hasBounds_) {
                while (this.ispan_ < this.nspan_ && this.nodes_[2 * this.ispan_ + 1] < this.umin_) {
                    ++this.ispan_;
                }
                while (this.ispan_ < this.nspan_ && this.nodes_[this.nspan_ * 2 - 2] >= this.umax_) {
                    --this.nspan_;
                }
                if (this.ispan_ < this.nspan_) {
                    this.nodes_[this.ispan_ * 2] = Math.max(this.nodes_[this.ispan_ * 2], this.umin_);
                    this.nodes_[this.nspan_ * 2 - 1] = Math.min(this.nodes_[this.nspan_ * 2 - 1], this.umax_);
                }
            }
        }
    }

    private /* synthetic */ int lambda$new$3() {
        return this.u_;
    }

    private /* synthetic */ int lambda$new$2() {
        return this.v_;
    }
}

