/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Rectangle;
import java.awt.Shape;
import java.util.BitSet;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.layer.FillPixer;
import uk.ac.starlink.ttools.plot2.layer.PixerFactory;

public class PixelDrawing
implements PixerFactory {
    private final BitSet pixelMask_;
    private final int x0_;
    private final int y0_;
    private final int width_;
    private final int height_;

    public PixelDrawing(Rectangle bounds) {
        this(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public PixelDrawing(int x0, int y0, int width, int height) {
        this.x0_ = x0;
        this.y0_ = y0;
        this.width_ = width;
        this.height_ = height;
        this.pixelMask_ = new BitSet(this.width_ * this.height_);
    }

    public void addPixel(int x, int y) {
        if (this.contains(x, y)) {
            this.addPixelUnchecked(x, y);
        }
    }

    public void addPixelUnchecked(int x, int y) {
        assert (this.contains(x, y)) : "(" + x + "," + y + ") not in " + new Rectangle(this.x0_, this.y0_, this.width_, this.height_);
        int xoff = x - this.x0_;
        int yoff = y - this.y0_;
        int packed = xoff + this.width_ * yoff;
        assert (packed >= 0 && packed < this.width_ * this.height_);
        this.pixelMask_.set(packed);
    }

    public void drawLine(int x0, int y0, int x1, int y1) {
        block12: {
            block13: {
                block11: {
                    if (x0 != x1) break block11;
                    int x = x0;
                    if (x < this.x0_ || x >= this.x0_ + this.width_) break block12;
                    if (y0 > y1) {
                        int y2 = y1;
                        y1 = y0;
                        y0 = y2;
                    }
                    int ya = Math.max(y0, this.y0_);
                    int yb = Math.min(y1, this.y0_ + this.height_ - 1);
                    for (int y = ya; y <= yb; ++y) {
                        this.addPixelUnchecked(x, y);
                    }
                    break block12;
                }
                if (y0 != y1) break block13;
                int y = y0;
                if (y < this.y0_ || y >= this.y0_ + this.height_) break block12;
                if (x0 > x1) {
                    int x2 = x1;
                    x1 = x0;
                    x0 = x2;
                }
                int xa = Math.max(x0, this.x0_);
                int xb = Math.min(x1, this.x0_ + this.width_ - 1);
                for (int x = xa; x <= xb; ++x) {
                    this.addPixelUnchecked(x, y);
                }
                break block12;
            }
            if (Math.abs(x1 - x0) > Math.abs(y1 - y0)) {
                if (x0 > x1) {
                    int x2 = x1;
                    int y2 = y1;
                    x1 = x0;
                    y1 = y0;
                    x0 = x2;
                    y0 = y2;
                }
                double slope = (double)(y1 - y0) / (double)(x1 - x0);
                int xa = Math.max(x0, this.x0_);
                int xb = Math.min(x1, this.x0_ + this.width_);
                for (int x = xa; x <= xb; ++x) {
                    this.addPixel(x, y0 + (int)Math.round((double)(x - x0) * slope));
                }
            } else {
                assert (Math.abs(x1 - x0) <= Math.abs(y1 - y0));
                if (y0 > y1) {
                    int x2 = x1;
                    int y2 = y1;
                    x1 = x0;
                    y1 = y0;
                    x0 = x2;
                    y0 = y2;
                }
                double slope = (double)(x1 - x0) / (double)(y1 - y0);
                int ya = Math.max(y0, this.y0_);
                int yb = Math.min(y1, this.y0_ + this.height_);
                for (int y = ya; y <= yb; ++y) {
                    this.addPixel(x0 + (int)Math.round((double)(y - y0) * slope), y);
                }
            }
        }
    }

    public void fillRect(int x, int y, int width, int height) {
        int xlo = Math.max(this.x0_, x);
        int xhi = Math.min(this.x0_ + this.width_, x + width);
        int ylo = Math.max(this.y0_, y);
        int yhi = Math.min(this.y0_ + this.height_, y + height);
        if (xlo < xhi && ylo < yhi) {
            for (int ix = xlo; ix < xhi; ++ix) {
                for (int iy = ylo; iy < yhi; ++iy) {
                    this.addPixelUnchecked(ix, iy);
                }
            }
        }
    }

    public void drawOval(int x, int y, int width, int height) {
        int ymax;
        int ymin;
        int xmax;
        int xmin;
        int a = width / 2;
        int b = height / 2;
        double a2r = 1.0 / ((double)a * (double)a);
        double b2r = 1.0 / ((double)b * (double)b);
        int x0 = x + a;
        int y0 = y + b;
        int xp = x0 - this.x0_;
        int xq = this.x0_ + this.width_ - x0;
        if (xp < 0) {
            xmin = -xp;
            xmax = xq;
        } else if (xq < 0) {
            xmin = -xq;
            xmax = xp;
        } else {
            xmin = 0;
            xmax = Math.min(a, Math.max(xp, xq));
        }
        int lasty = 0;
        for (int ix = xmin; ix < xmax; ++ix) {
            int iy = (int)Math.round((double)b * Math.sqrt(1.0 - a2r * (double)ix * (double)ix));
            this.addPixel(x0 + ix, y0 + iy);
            this.addPixel(x0 + ix, y0 - iy);
            this.addPixel(x0 - ix, y0 + iy);
            this.addPixel(x0 - ix, y0 - iy);
            if (lasty - iy > 1) break;
            lasty = iy;
        }
        int yp = y0 - this.y0_;
        int yq = this.y0_ + this.height_ - y0;
        if (yp < 0) {
            ymin = -yp;
            ymax = yq;
        } else if (yq < 0) {
            ymin = -yq;
            ymax = yp;
        } else {
            ymin = 0;
            ymax = Math.min(b, Math.max(yp, yq));
        }
        int lastx = 0;
        for (int iy = ymin; iy < ymax; ++iy) {
            int ix = (int)Math.round((double)a * Math.sqrt(1.0 - b2r * (double)iy * (double)iy));
            this.addPixel(x0 + ix, y0 + iy);
            this.addPixel(x0 + ix, y0 - iy);
            this.addPixel(x0 - ix, y0 + iy);
            this.addPixel(x0 - ix, y0 - iy);
            if (lastx - ix > 1) break;
            lastx = ix;
        }
    }

    public void fillOval(int x, int y, int width, int height) {
        int a = width / 2;
        int b = height / 2;
        int x0 = x + a;
        int y0 = y + b;
        int xlo = Math.max(this.x0_, x);
        int xhi = Math.min(this.x0_ + this.width_ - 1, x + width - 1);
        int ylo = Math.max(this.y0_, y);
        int yhi = Math.min(this.y0_ + this.height_ - 1, y + height - 1);
        double a2 = (double)a * (double)a;
        double b2 = (double)b * (double)b;
        double a2b2 = a2 * b2;
        for (int ix = xlo; ix <= xhi; ++ix) {
            int jx = ix - x0;
            double jxb2 = b2 * (double)jx * (double)jx;
            for (int iy = ylo; iy <= yhi; ++iy) {
                int jy = iy - y0;
                double jya2 = a2 * (double)jy * (double)jy;
                if (!(jxb2 + jya2 <= a2b2)) continue;
                this.addPixelUnchecked(ix, iy);
            }
        }
    }

    public void drawEllipse(int x0, int y0, int ax, int ay, int bx, int by) {
        double a2r;
        double cC;
        double cB;
        double cA;
        int xmax = Math.abs(ax) + Math.abs(bx);
        int ymax = Math.abs(ay) + Math.abs(by);
        int xlo = Math.max(x0 - xmax, this.x0_);
        int xhi = Math.min(x0 + xmax, this.x0_ + this.width_);
        int ylo = Math.max(y0 - ymax, this.y0_);
        int yhi = Math.min(y0 + ymax, this.y0_ + this.height_);
        double kxx = (double)ay * (double)ay + (double)by * (double)by;
        double kxy = -2.0 * ((double)ax * (double)ay + (double)bx * (double)by);
        double kyy = (double)ax * (double)ax + (double)bx * (double)bx;
        double r1 = (double)ax * (double)by - (double)bx * (double)ay;
        double r2 = r1 * r1;
        for (int x = xlo; x <= xhi; ++x) {
            double x1 = x - x0;
            double x2 = x1 * x1;
            cA = kyy;
            cB = kxy * x1;
            cC = kxx * x2 - r2;
            a2r = 0.5 / cA;
            double yz = (double)y0 - cB * a2r;
            double yd = Math.sqrt(cB * cB - 4.0 * cA * cC) * a2r;
            if (Double.isNaN(yd)) continue;
            this.addPixel(x, (int)Math.round(yz - yd));
            this.addPixel(x, (int)Math.round(yz + yd));
        }
        for (int y = ylo; y <= yhi; ++y) {
            double y1 = y - y0;
            double y2 = y1 * y1;
            cA = kxx;
            cB = kxy * y1;
            cC = kyy * y2 - r2;
            a2r = 0.5 / cA;
            double xz = (double)x0 - cB * a2r;
            double xd = Math.sqrt(cB * cB - 4.0 * cA * cC) * a2r;
            if (Double.isNaN(xd)) continue;
            this.addPixel((int)Math.round(xz - xd), y);
            this.addPixel((int)Math.round(xz + xd), y);
        }
    }

    public void fillEllipse(int x0, int y0, int ax, int ay, int bx, int by) {
        int xmax = Math.abs(ax) + Math.abs(bx);
        int ymax = Math.abs(ay) + Math.abs(by);
        int xlo = Math.max(x0 - xmax, this.x0_);
        int xhi = Math.min(x0 + xmax, this.x0_ + this.width_ - 1);
        int ylo = Math.max(y0 - ymax, this.y0_);
        int yhi = Math.min(y0 + ymax, this.y0_ + this.height_ - 1);
        double kxx = (double)ay * (double)ay + (double)by * (double)by;
        double kxy = -2.0 * ((double)ax * (double)ay + (double)bx * (double)by);
        double kyy = (double)ax * (double)ax + (double)bx * (double)bx;
        double r = (double)ax * (double)by - (double)bx * (double)ay;
        double r2 = r * r;
        if (xhi - xlo > 0 && yhi - ylo > 0) {
            for (int x = xlo; x <= xhi; ++x) {
                double x1 = x - x0;
                double x2 = x1 * x1;
                for (int y = ylo; y <= yhi; ++y) {
                    double y1 = y - y0;
                    double y2 = y1 * y1;
                    if (!(kxx * x2 + kxy * x1 * y1 + kyy * y2 <= r2)) continue;
                    this.addPixelUnchecked(x, y);
                }
            }
        }
    }

    public void fillPolygon(int[] xs, int[] ys, int np) {
        if (np > 0) {
            int xlo = xs[0];
            int xhi = xs[0];
            int ylo = ys[0];
            int yhi = ys[0];
            for (int ip = 1; ip < np; ++ip) {
                int x = xs[ip];
                int y = ys[ip];
                xlo = Math.min(xlo, x);
                xhi = Math.max(xhi, x);
                ylo = Math.min(ylo, y);
                yhi = Math.max(yhi, y);
            }
            if (xhi >= this.x0_ && xlo <= this.x0_ + this.width_ && yhi >= this.y0_ && ylo <= this.y0_ + this.height_) {
                Rectangle bounds = new Rectangle(this.x0_, this.y0_, this.width_, this.height_);
                FillPixer pixer = new FillPixer(xs, ys, np, bounds);
                while (pixer.next()) {
                    this.addPixelUnchecked(pixer.getX(), pixer.getY());
                }
            }
        }
    }

    @Deprecated
    public void fill(Shape shape) {
        Rectangle box = shape.getBounds();
        int xlo = Math.max(this.x0_, box.x);
        int xhi = Math.min(this.x0_ + this.width_ - 1, box.x + box.width - 1);
        int ylo = Math.max(this.y0_, box.y);
        int yhi = Math.min(this.y0_ + this.height_ - 1, box.y + box.height - 1);
        if (xhi >= xlo && yhi >= ylo) {
            for (int x = xlo; x <= xhi; ++x) {
                double px = x;
                for (int y = ylo; y <= yhi; ++y) {
                    double py = y;
                    if (!shape.contains(px, py)) continue;
                    this.addPixelUnchecked(x, y);
                }
            }
        }
    }

    public boolean contains(int x, int y) {
        return x >= this.x0_ && x < this.x0_ + this.width_ && y >= this.y0_ && y < this.y0_ + this.height_;
    }

    public BitSet getPixels() {
        return this.pixelMask_;
    }

    @Override
    public int getMinX() {
        return this.x0_;
    }

    @Override
    public int getMaxX() {
        return this.x0_ + this.width_ - 1;
    }

    @Override
    public int getMinY() {
        return this.y0_;
    }

    @Override
    public int getMaxY() {
        return this.y0_ + this.height_ - 1;
    }

    @Override
    public int getPixelCount() {
        return this.pixelMask_.cardinality();
    }

    @Override
    public Pixer createPixer() {
        return new Pixer(){
            int ipNext_ = -1;
            int ix_ = Integer.MIN_VALUE;
            int iy_ = Integer.MIN_VALUE;

            @Override
            public boolean next() {
                this.ipNext_ = PixelDrawing.this.pixelMask_.nextSetBit(this.ipNext_ + 1);
                if (this.ipNext_ >= 0) {
                    this.ix_ = this.ipNext_ % PixelDrawing.this.width_ + PixelDrawing.this.x0_;
                    this.iy_ = this.ipNext_ / PixelDrawing.this.width_ + PixelDrawing.this.y0_;
                    return true;
                }
                this.ipNext_ = 0x7FFFFFFE;
                this.ix_ = Integer.MIN_VALUE;
                this.iy_ = Integer.MIN_VALUE;
                return false;
            }

            @Override
            public int getX() {
                return this.ix_;
            }

            @Override
            public int getY() {
                return this.iy_;
            }
        };
    }
}

