/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.config.BooleanConfigKey;
import uk.ac.starlink.ttools.plot2.config.ComboBoxSpecifier;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.OptionConfigKey;
import uk.ac.starlink.ttools.plot2.config.Specifier;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.FloatingArrayCoord;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.layer.MarkerShape;
import uk.ac.starlink.ttools.plot2.layer.Outliner;
import uk.ac.starlink.ttools.plot2.layer.PolygonOutliner;
import uk.ac.starlink.ttools.plot2.layer.PolygonShape;
import uk.ac.starlink.ttools.plot2.layer.ShapeForm;
import uk.ac.starlink.ttools.plot2.layer.ShapeStyle;

public class PolygonForms {
    public static final ShapeForm QUAD = new FixedPolygonForm(4);
    public static final ShapeForm ARRAY = new ArrayPolygonForm();
    public static final ConfigKey<PolygonShape> POLYSHAPE_KEY = PolygonForms.createPolygonShapeKey();
    public static final ConfigKey<Integer> POLYTHICK_KEY = PolygonForms.createPolygonThicknessKey();
    public static final ConfigKey<Boolean> INCLUDEPOS_KEY = new BooleanConfigKey(new ConfigMeta("usepos", "Use Position").setShortDescription("Include reference position in vertices?").setXmlDescription(new String[]{"<p>Determines whether the basic positional coordinates", "are included as one of the polygon vertices or not.", "The polygon has N+1 vertices if true,", "or N vertices if false,", "where N is the number of vertices supplied by the", "array coordinate.", "If false, the basic position is ignored for the purposes", "of drawing the polygon.", "</p>"}), true);
    public static final FloatingArrayCoord ARRAY_COORD = PolygonForms.createArrayCoord();

    private PolygonForms() {
    }

    private static FloatingArrayCoord createArrayCoord() {
        InputMeta meta = new InputMeta("otherpoints", "Other Points");
        meta.setShortDescription("array of positions");
        meta.setValueUsage("array");
        meta.setXmlDescription(new String[]{"<p>Array of coordinates giving the points of the vertices", "defining the polygon to be drawn.", "These coordinates are given as an interleaved array", "by this parameter, e.g. (x1,y1, x2,y2, y3,y3).", "The basic position for the row being plotted", "either is or is not included as the first vertex,", "according to the setting of the", "<code>" + INCLUDEPOS_KEY.getMeta().getShortName() + "</code>", "parameter.", "</p>", "<p>Some expression language functions that can be useful", "when specifying this parameter are", "<code>array()</code> and <code>parseDoubles()</code>.", "</p>"});
        return FloatingArrayCoord.createCoord(meta, true);
    }

    private static ConfigKey<PolygonShape> createPolygonShapeKey() {
        ConfigMeta meta = new ConfigMeta("polymode", "Polygon Mode");
        meta.setXmlDescription(new String[]{"<p>Polygon drawing mode.", "Different options are available, including drawing an outline", "round the edge and filling the interior with colour.", "</p>"});
        final PolygonShape[] shapes = PolygonShape.POLYSHAPES;
        OptionConfigKey<PolygonShape> key = new OptionConfigKey<PolygonShape>(meta, PolygonShape.class, shapes){

            @Override
            public String getXmlDescription(PolygonShape polyShape) {
                return polyShape.getDescription();
            }

            @Override
            public Specifier<PolygonShape> createSpecifier() {
                JComboBox<PolygonShape> comboBox = new JComboBox<PolygonShape>(shapes);
                comboBox.setRenderer(new PolygonShapeRenderer());
                return new ComboBoxSpecifier<PolygonShape>(PolygonShape.class, comboBox);
            }
        };
        key.setOptionUsage();
        key.addOptionsXml();
        return key;
    }

    private static final ConfigKey<Integer> createPolygonThicknessKey() {
        ConfigMeta meta = new ConfigMeta("thick", "Thickness");
        meta.setShortDescription("Line thickness for open shapes");
        meta.setXmlDescription(new String[]{"<p>Controls the line thickness used when drawing polygons.", "Zero, the default value, means a 1-pixel-wide line is used.", "Larger values make drawn lines thicker,", "but note changing this value will not affect all shapes,", "for instance filled polygons contain no line drawings.", "</p>"});
        return StyleKeys.createPaintThicknessKey(meta, 4);
    }

    private static class ArrayPolygonForm
    implements ShapeForm {
        private ArrayPolygonForm() {
        }

        @Override
        public String getFormName() {
            return "Polygon";
        }

        @Override
        public Icon getFormIcon() {
            return ResourceIcon.FORM_POLYLINE;
        }

        @Override
        public String getFormDescription() {
            String arrayCoordName = ARRAY_COORD.getInputs()[0].getMeta().getShortName();
            return PlotUtil.concatLines(new String[]{"<p>Draws a closed polygon given an array of coordinates", "that define its vertices.", "In fact this plot requires the position of the first vertex", "supplied as a positional value in the usual way", "(e.g. <code>X</code> and <code>Y</code> coordinates)", "and the second, third etc vertices supplied as an array", "using the <code>" + arrayCoordName + "</code> parameter.", "</p>", "<p>Invocation might therefore look like", "\"<code>xN=x1 yN=y1 " + arrayCoordName + "N=array(x2,y2, x3,y3, x4,y4)</code>\".", "</p>"});
        }

        @Override
        public int getBasicPositionCount() {
            return 1;
        }

        @Override
        public Coord[] getExtraCoords() {
            return new Coord[]{ARRAY_COORD};
        }

        @Override
        public int getExtraPositionCount() {
            return 0;
        }

        @Override
        public DataGeom adjustGeom(DataGeom geom, DataSpec dataSpec, ShapeStyle style) {
            return geom;
        }

        @Override
        public ConfigKey<?>[] getConfigKeys() {
            return new ConfigKey[]{INCLUDEPOS_KEY, POLYSHAPE_KEY, POLYTHICK_KEY};
        }

        @Override
        public Outliner createOutliner(ConfigMap config) {
            boolean includePos = config.get(INCLUDEPOS_KEY);
            PolygonShape basicShape = config.get(POLYSHAPE_KEY);
            int nthick = config.get(POLYTHICK_KEY);
            PolygonShape polyShape = nthick == 0 ? basicShape : basicShape.toThicker(nthick);
            return PolygonOutliner.createArrayOutliner(ARRAY_COORD, includePos, polyShape);
        }
    }

    private static class FixedPolygonForm
    implements ShapeForm {
        private final int np_;

        public FixedPolygonForm(int np) {
            this.np_ = np;
        }

        @Override
        public String getFormName() {
            return "Poly" + this.np_;
        }

        @Override
        public Icon getFormIcon() {
            return ResourceIcon.FORM_POLYLINE;
        }

        @Override
        public String getFormDescription() {
            String figname = this.np_ == 3 ? "triangle" : (this.np_ == 4 ? "quadrilateral" : Integer.toString(this.np_) + "-sided polygon");
            return PlotUtil.concatLines(new String[]{"<p>Draws a closed " + figname, "given the coordinates of its vertices", "supplied as " + this.np_ + " separate positions.", "The way that the polygon is drawn (outline, fill etc)", "is determined using the", "<code>" + POLYSHAPE_KEY.getMeta().getShortName() + "</code>", "option.", "</p>", "<p>Polygons smaller than a configurable threshold size", "in pixels are by default represented by a replacement marker,", "so the position of even a very small polygon", "is still visible on the screen.", "</p>"});
        }

        @Override
        public int getBasicPositionCount() {
            return this.np_;
        }

        @Override
        public Coord[] getExtraCoords() {
            return new Coord[0];
        }

        @Override
        public int getExtraPositionCount() {
            return 0;
        }

        @Override
        public DataGeom adjustGeom(DataGeom geom, DataSpec dataSpec, ShapeStyle style) {
            return geom;
        }

        @Override
        public ConfigKey<?>[] getConfigKeys() {
            return new ConfigKey[]{POLYSHAPE_KEY, POLYTHICK_KEY, PolygonOutliner.MINSIZE_KEY, PolygonOutliner.MINSHAPE_KEY};
        }

        @Override
        public Outliner createOutliner(ConfigMap config) {
            PolygonShape basicShape = config.get(POLYSHAPE_KEY);
            int nthick = config.get(POLYTHICK_KEY);
            PolygonShape polyShape = nthick == 0 ? basicShape : basicShape.toThicker(nthick);
            int minSize = config.get(PolygonOutliner.MINSIZE_KEY);
            MarkerShape minShape = config.get(PolygonOutliner.MINSHAPE_KEY);
            return PolygonOutliner.createFixedOutliner(this.np_, polyShape, minSize, minShape);
        }
    }

    private static class PolygonShapeRenderer
    extends DefaultListCellRenderer {
        private int iconHeight_ = 0;
        private PolygonShape polyShape_;
        private final Icon icon_ = new Icon(){

            @Override
            public int getIconWidth() {
                return iconHeight_ * 2;
            }

            @Override
            public int getIconHeight() {
                return iconHeight_;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                if (polyShape_ != null) {
                    int w = this.getIconWidth();
                    int h = this.getIconHeight();
                    int[] xs = new int[]{x + 0, x + w, x + w, x + 0};
                    int[] ys = new int[]{y + 0, y + 0, y + h, y + h};
                    int x0 = x + w / 2;
                    int y0 = y + h / 2;
                    Color color0 = g.getColor();
                    g.setColor(c.getForeground());
                    polyShape_.createPolygonGlyph(x0, y0, xs, ys, 4).paintGlyph(g);
                    g.setColor(color0);
                }
            }
        };

        PolygonShapeRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSel, boolean hasFocus) {
            Component c = super.getListCellRendererComponent(list, value, index, isSel, hasFocus);
            if (this.iconHeight_ <= 0) {
                this.iconHeight_ = c.getFontMetrics(c.getFont()).getAscent();
            }
            if (c instanceof JLabel && value instanceof PolygonShape) {
                JLabel label = (JLabel)c;
                this.polyShape_ = (PolygonShape)value;
                label.setText(this.polyShape_.toString());
                label.setIcon(this.icon_);
            }
            return c;
        }
    }
}

