/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import cds.healpix.Healpix;
import cds.healpix.VerticesAndPathComputer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import uk.ac.starlink.ttools.Area;
import uk.ac.starlink.ttools.cone.CdsHealpixUtil;
import uk.ac.starlink.ttools.plot2.AuxReader;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.AreaCoord;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.FloatingArrayCoord;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.geom.CubeDataGeom;
import uk.ac.starlink.ttools.plot2.geom.CubeSurface;
import uk.ac.starlink.ttools.plot2.geom.GPoint3D;
import uk.ac.starlink.ttools.plot2.geom.PlaneDataGeom;
import uk.ac.starlink.ttools.plot2.geom.Rotation;
import uk.ac.starlink.ttools.plot2.geom.SkyDataGeom;
import uk.ac.starlink.ttools.plot2.geom.SkySys;
import uk.ac.starlink.ttools.plot2.geom.SphereDataGeom;
import uk.ac.starlink.ttools.plot2.layer.MarkForm;
import uk.ac.starlink.ttools.plot2.layer.MarkerShape;
import uk.ac.starlink.ttools.plot2.layer.MultiPosIcon;
import uk.ac.starlink.ttools.plot2.layer.PixOutliner;
import uk.ac.starlink.ttools.plot2.layer.PolygonShape;
import uk.ac.starlink.ttools.plot2.layer.ShapePainter;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType2D;
import uk.ac.starlink.ttools.plot2.paper.PaperType3D;
import uk.ac.starlink.util.DoubleList;

public class PolygonOutliner
extends PixOutliner {
    private final PolygonShape polyShape_;
    private final VertexReaderFactory vrfact_;
    private final int minSize_;
    private final MarkerShape minShape_;
    private final Glyph pointGlyph_;
    private final Icon icon_;
    public static final ConfigKey<Integer> MINSIZE_KEY = StyleKeys.createMarkSizeKey(new ConfigMeta("minsize", "Minimal Size").setStringUsage("<pixels>").setShortDescription("Size of small polygon representation in pixels").setXmlDescription(new String[]{"<p>Defines a threshold size in pixels below which,", "instead of the polygon defined by the other parameters,", "a replacement marker will be painted instead.", "If this is set to zero, then only the shape itself", "will be plotted, but if it is small it may appear as", "only a single pixel.", "By setting a larger value, you can ensure that", "the position of even small polygons is easily visible,", "at the expense of giving them an artificial shape and size.", "This value also defines the size of the replacement markers.", "</p>"}), 1);
    public static final ConfigKey<MarkerShape> MINSHAPE_KEY = StyleKeys.createMarkerShapeKey(new ConfigMeta("minshape", "Minimal Shape").setShortDescription("Marker shape for very small shapes").setXmlDescription(new String[]{"<p>Defines the shape of markers plotted instead of", "the actual polygon shape,", "for polygons that are smaller than the size threshold", "defined by", "<code>" + MINSIZE_KEY.getMeta().getShortName() + "</code>.", "</p>"}), MarkerShape.CROXX);
    private static final int NVERTEX_CIRCLE = 36;
    private static final double[] COSS = new double[36];
    private static final double[] SINS = new double[36];
    private static final VertexData NO_VERTEX_DATA;
    private static final int HPX_INTERPOLATE_LEVEL = 5;

    private PolygonOutliner(PolygonShape polyShape, VertexReaderFactory vrfact, int minSize, MarkerShape minShape) {
        this.polyShape_ = polyShape;
        this.vrfact_ = vrfact;
        this.minSize_ = minSize;
        this.minShape_ = minShape;
        this.pointGlyph_ = MarkForm.createMarkGlyph(minShape, minSize, true);
        this.icon_ = new MultiPosIcon(4){

            @Override
            protected void paintPositions(Graphics g, Point[] positions) {
                int np = positions.length;
                int[] xs = new int[np];
                int[] ys = new int[np];
                int tx = 0;
                int ty = 0;
                for (int i = 0; i < np; ++i) {
                    Point p = positions[i];
                    int x = p.x;
                    int y = p.y;
                    xs[i] = x;
                    ys[i] = y;
                    tx += x;
                    ty += y;
                }
                PolygonOutliner.this.polyShape_.createPolygonGlyph(tx / np, ty / np, xs, ys, np).paintGlyph(g);
            }
        };
    }

    @Override
    public Icon getLegendIcon() {
        return this.icon_;
    }

    @Override
    public Map<AuxScale, AuxReader> getAuxRangers(DataGeom geom) {
        return new HashMap<AuxScale, AuxReader>();
    }

    @Override
    public boolean canPaint(DataSpec dataSpec) {
        return true;
    }

    @Override
    public ShapePainter create2DPainter(final Surface surf, final DataGeom geom, DataSpec dataSpec, Map<AuxScale, Span> auxSpans, final PaperType2D paperType) {
        final VertexReader vertReader = this.vrfact_.createVertexReader(geom);
        Rectangle bounds = surf.getPlotBounds();
        final int bxMin = bounds.x;
        final int bxMax = bounds.x + bounds.width;
        final int byMin = bounds.y;
        final int byMax = bounds.y + bounds.height;
        int ndim = surf.getDataDimCount();
        final double[] dpos0 = new double[ndim];
        final double[] dpos = new double[ndim];
        final double[] dposC = new double[ndim];
        final Point2D.Double gpos = new Point2D.Double();
        final Point2D.Double gposC = new Point2D.Double();
        final Point igpos = new Point();
        final Point igposC = new Point();
        final int icPos = vertReader.getPosCoordIndex();
        return new ShapePainter(){

            @Override
            public void paintPoint(Tuple tuple, Color color, Paper paper) {
                VertexData vdata = vertReader.readVertexData(tuple);
                int np = vdata.getVertexCount();
                int ip0 = this.advanceToPoly(vdata, surf, 0, dpos0, gpos);
                if (ip0 < np) {
                    if (geom.readDataPos(tuple, icPos, dposC) && surf.dataToGraphics(dposC, false, gposC) && PlotUtil.isPointFinite(gposC)) {
                        PlotUtil.quantisePoint(gposC, igposC);
                    } else {
                        PlotUtil.quantisePoint(gpos, igposC);
                        System.arraycopy(dpos0, 0, dposC, 0, dpos.length);
                    }
                    int gxC = igposC.x;
                    int gyC = igposC.y;
                    int jp = 0;
                    int[] gxs = new int[np];
                    int[] gys = new int[np];
                    PlotUtil.quantisePoint(gpos, igpos);
                    gxs[jp] = igpos.x;
                    gys[jp] = igpos.y;
                    ++jp;
                    for (int ip = ip0 + 1; ip < np; ++ip) {
                        if (vdata.isBreak(ip)) {
                            this.paintPoly(gxC, gyC, gxs, gys, jp, color, paper);
                            ip = this.advanceToPoly(vdata, surf, ip + 1, dpos0, gpos);
                            if (ip < np) {
                                jp = 0;
                                PlotUtil.quantisePoint(gpos, igpos);
                                gxs[jp] = igpos.x;
                                gys[jp] = igpos.y;
                                ++jp;
                                continue;
                            }
                            return;
                        }
                        if (!vdata.readDataPos(ip, dpos) || !surf.dataToGraphics(dpos, false, gpos) || !surf.isContinuousLine(dpos0, dpos) || !PlotUtil.isPointFinite(gpos)) continue;
                        PlotUtil.quantisePoint(gpos, igpos);
                        gxs[jp] = igpos.x;
                        gys[jp] = igpos.y;
                        ++jp;
                    }
                    if (jp > 0) {
                        this.paintPoly(gxC, gyC, gxs, gys, jp, color, paper);
                    }
                }
            }

            private int advanceToPoly(VertexData vdata, Surface surf2, int ip, double[] dpos2, Point2D.Double gpos2) {
                int np = vdata.getVertexCount();
                while (ip < np) {
                    if (vdata.readDataPos(ip, dpos2) && surf2.dataToGraphics(dpos2, false, gpos2) && PlotUtil.isPointFinite(gpos2)) {
                        return ip;
                    }
                    while (ip < np && !vdata.isBreak(ip++)) {
                    }
                }
                return ip;
            }

            private void paintPoly(int gx0, int gy0, int[] gxs, int[] gys, int np, Color color, Paper paper) {
                int gxMin = bxMax;
                int gxMax = bxMin;
                int gyMin = byMax;
                int gyMax = byMin;
                for (int ip = 0; ip < np; ++ip) {
                    int gx = gxs[ip];
                    int gy = gys[ip];
                    gxMin = Math.min(gxMin, gx);
                    gxMax = Math.max(gxMax, gx);
                    gyMin = Math.min(gyMin, gy);
                    gyMax = Math.max(gyMax, gy);
                }
                if (gxMax >= bxMin && gxMin <= bxMax && gyMax >= byMin && gyMin <= byMax) {
                    if (gxMax - gxMin <= PolygonOutliner.this.minSize_ && gyMax - gyMin <= PolygonOutliner.this.minSize_) {
                        int gx = (gxMax + gxMin) / 2;
                        int gy = (gyMax + gyMin) / 2;
                        paperType.placeGlyph(paper, gx, gy, PolygonOutliner.this.pointGlyph_, color);
                    } else {
                        Glyph glyph = PolygonOutliner.this.polyShape_.createPolygonGlyph(gx0, gy0, gxs, gys, np);
                        paperType.placeGlyph(paper, 0.0, 0.0, glyph, color);
                    }
                }
            }
        };
    }

    @Override
    public ShapePainter create3DPainter(final CubeSurface surf, final DataGeom geom, DataSpec dataSpec, Map<AuxScale, Span> auxSpans, final PaperType3D paperType) {
        final VertexReader vertReader = this.vrfact_.createVertexReader(geom);
        Rectangle bounds = surf.getPlotBounds();
        final int bxMin = bounds.x;
        final int bxMax = bounds.x + bounds.width;
        final int byMin = bounds.y;
        final int byMax = bounds.y + bounds.height;
        int ndim = surf.getDataDimCount();
        final double[] dpos = new double[ndim];
        final GPoint3D gpos = new GPoint3D();
        final Point igpos = new Point();
        final double[] dposC = new double[ndim];
        final GPoint3D gposC = new GPoint3D();
        final Point igposC = new Point();
        final int icPos = vertReader.getPosCoordIndex();
        return new ShapePainter(){

            @Override
            public void paintPoint(Tuple tuple, Color color, Paper paper) {
                VertexData vdata = vertReader.readVertexData(tuple);
                int np = vdata.getVertexCount();
                if (np > 0 && geom.readDataPos(tuple, icPos, dposC) && surf.dataToGraphicZ(dposC, true, gposC) && PlotUtil.isPointFinite(gposC)) {
                    PlotUtil.quantisePoint(gposC, igposC);
                    int gxC = igposC.x;
                    int gyC = igposC.y;
                    int[] gxs = new int[np];
                    int[] gys = new int[np];
                    int jp = 0;
                    double sz = 0.0;
                    for (int ip = 0; ip < np; ++ip) {
                        if (vdata.isBreak(ip)) {
                            double gz = sz / (double)np;
                            this.paintPoly(gxC, gyC, gxs, gys, jp, gz, color, paper);
                            jp = 0;
                            sz = 0.0;
                            continue;
                        }
                        if (vdata.readDataPos(ip, dpos) && surf.dataToGraphicZ(dpos, true, gpos) && PlotUtil.isPointFinite(gpos)) {
                            PlotUtil.quantisePoint(gpos, igpos);
                            gxs[jp] = igpos.x;
                            gys[jp] = igpos.y;
                            ++jp;
                            sz += gpos.z;
                            continue;
                        }
                        return;
                    }
                    if (jp > 0) {
                        double gz = sz / (double)jp;
                        this.paintPoly(gxC, gyC, gxs, gys, jp, gz, color, paper);
                    }
                }
            }

            private void paintPoly(int gx0, int gy0, int[] gxs, int[] gys, int np, double gz, Color color, Paper paper) {
                int gxMin = bxMax;
                int gxMax = bxMin;
                int gyMin = byMax;
                int gyMax = byMin;
                for (int ip = 0; ip < np; ++ip) {
                    int gx = gxs[ip];
                    int gy = gys[ip];
                    gxMin = Math.min(gxMin, gx);
                    gxMax = Math.max(gxMax, gx);
                    gyMin = Math.min(gyMin, gy);
                    gyMax = Math.max(gyMax, gy);
                }
                if (gxMax >= bxMin && gxMin <= bxMax && gyMax >= byMin && gyMin <= byMax) {
                    if (gxMax - gxMin <= PolygonOutliner.this.minSize_ && gyMax - gyMin <= PolygonOutliner.this.minSize_) {
                        int gx = (gxMax + gxMin) / 2;
                        int gy = (gyMax + gyMin) / 2;
                        paperType.placeGlyph(paper, gx, gy, gz, PolygonOutliner.this.pointGlyph_, color);
                    } else {
                        Glyph glyph = PolygonOutliner.this.polyShape_.createPolygonGlyph(gx0, gy0, gxs, gys, np);
                        paperType.placeGlyph(paper, 0.0, 0.0, gz, glyph, color);
                    }
                }
            }
        };
    }

    public int hashCode() {
        int code = 434482;
        code = 23 * code + this.polyShape_.hashCode();
        code = 23 * code + this.vrfact_.hashCode();
        code = 23 * code + this.minSize_;
        code = 23 * code + this.minShape_.hashCode();
        return code;
    }

    public boolean equals(Object o) {
        if (o instanceof PolygonOutliner) {
            PolygonOutliner other = (PolygonOutliner)o;
            return this.polyShape_.equals(other.polyShape_) && this.vrfact_.equals(other.vrfact_) && this.minSize_ == other.minSize_ && this.minShape_.equals(other.minShape_);
        }
        return false;
    }

    public static PolygonOutliner createFixedOutliner(int np, PolygonShape polyShape, int minSize, MarkerShape minShape) {
        return new PolygonOutliner(polyShape, new FixedVertexReaderFactory(np), minSize, minShape);
    }

    public static PolygonOutliner createPlaneAreaOutliner(AreaCoord<PlaneDataGeom> coord, int icArea, PolygonShape polyShape, int minSize, MarkerShape minShape) {
        return new PolygonOutliner(polyShape, new PlaneAreaVertexReaderFactory(coord, icArea), minSize, minShape);
    }

    public static PolygonOutliner createSkyAreaOutliner(AreaCoord<SkyDataGeom> coord, int icArea, PolygonShape polyShape, int minSize, MarkerShape minShape) {
        return new PolygonOutliner(polyShape, new SkyAreaVertexReaderFactory(coord, icArea), minSize, minShape);
    }

    public static PolygonOutliner createSphereAreaOutliner(AreaCoord<SphereDataGeom> areaCoord, int icArea, FloatingCoord radialCoord, int icRadial, PolygonShape polyShape, int minSize, MarkerShape minShape) {
        return new PolygonOutliner(polyShape, new SphereAreaVertexReaderFactory(areaCoord, icArea, radialCoord, icRadial), minSize, minShape);
    }

    public static PolygonOutliner createArrayOutliner(FloatingArrayCoord arrayCoord, boolean includePos, PolygonShape polyShape) {
        return new PolygonOutliner(polyShape, new ArrayVertexReaderFactory(arrayCoord, includePos), 0, MarkerShape.POINT);
    }

    private static boolean toSky(double lonDeg, double latDeg, SkyDataGeom geom, double[] dpos) {
        if (Math.abs(latDeg) <= 90.0 && PlotUtil.isFinite(lonDeg)) {
            double theta = Math.toRadians(90.0 - latDeg);
            double phi = Math.toRadians(lonDeg % 360.0);
            double sd = Math.sin(theta);
            dpos[0] = Math.cos(phi) * sd;
            dpos[1] = Math.sin(phi) * sd;
            dpos[2] = Math.cos(theta);
            geom.rotate(dpos);
            return true;
        }
        return false;
    }

    private static double[][] toSkyVertices(double[] lonLatVertices, SkyDataGeom skyGeom) {
        double MAX_LINEAR_DIST = 0.17453292519943295;
        int nv = lonLatVertices.length / 2;
        ArrayList<double[]> dps = new ArrayList<double[]>(nv);
        boolean isStart = true;
        for (int iv = 0; iv < nv; ++iv) {
            double dist;
            double[] prevDpos;
            int iv2 = iv * 2;
            double lon = lonLatVertices[iv2 + 0];
            double lat = lonLatVertices[iv2 + 1];
            if (Double.isNaN(lon)) {
                assert (Double.isNaN(lat));
                dps.add(null);
                isStart = true;
                continue;
            }
            double[] dpos = new double[3];
            if (!PolygonOutliner.toSky(lon, lat, skyGeom, dpos)) continue;
            if (isStart) {
                int kv = -1;
                for (int j = iv; kv < 0 && j < nv; ++j) {
                    if (j != nv - 1 && !Double.isNaN(lonLatVertices[j * 2])) continue;
                    kv = j;
                }
                double prevLon = lonLatVertices[kv * 2 + 0];
                double prevLat = lonLatVertices[kv * 2 + 1];
                double[] ldp = new double[3];
                prevDpos = (double[])(PolygonOutliner.toSky(prevLon, prevLat, skyGeom, ldp) ? ldp : null);
            } else {
                prevDpos = (double[])dps.get(dps.size() - 1);
            }
            double d = dist = prevDpos == null ? 0.0 : Math.acos(dpos[0] * prevDpos[0] + dpos[1] * prevDpos[1] + dpos[2] * prevDpos[2]);
            if (dist < 0.17453292519943295) {
                dps.add(dpos);
            } else {
                int nstep = (int)Math.ceil(dist / 0.17453292519943295);
                double fstep = 1.0 / (double)nstep;
                double x = prevDpos[0];
                double y = prevDpos[1];
                double z = prevDpos[2];
                double dx = fstep * (dpos[0] - prevDpos[0]);
                double dy = fstep * (dpos[1] - prevDpos[1]);
                double dz = fstep * (dpos[2] - prevDpos[2]);
                for (int is = 0; is < nstep; ++is) {
                    double r1 = 1.0 / Math.sqrt((x += dx) * x + (y += dy) * y + (z += dz) * z);
                    dps.add(new double[]{r1 * x, r1 * y, r1 * z});
                }
            }
            isStart = false;
        }
        return (double[][])dps.toArray((T[])new double[0][]);
    }

    private static boolean toSphere(double lonDeg, double latDeg, double radius, double[] dpos) {
        if (radius >= 0.0 && Math.abs(latDeg) <= 90.0 && PlotUtil.isFinite(lonDeg)) {
            double theta = Math.toRadians(90.0 - latDeg);
            double phi = Math.toRadians(lonDeg % 360.0);
            double sd = Math.sin(theta);
            dpos[0] = radius * Math.cos(phi) * sd;
            dpos[1] = radius * Math.sin(phi) * sd;
            dpos[2] = radius * Math.cos(theta);
            return true;
        }
        return false;
    }

    private static VertexData createSphereAreaVertexData(Area area, final double radius) {
        switch (area.getType()) {
            case POLYGON: {
                final double[] vertices = area.getDataArray();
                return new VertexData(){

                    @Override
                    public int getVertexCount() {
                        return vertices.length / 2;
                    }

                    @Override
                    public boolean readDataPos(int ivert, double[] dpos) {
                        int iv2 = ivert * 2;
                        return PolygonOutliner.toSphere(vertices[iv2], vertices[iv2 + 1], radius, dpos);
                    }

                    @Override
                    public boolean isBreak(int ivert) {
                        int iv2 = ivert * 2;
                        if (Double.isNaN(vertices[iv2])) {
                            assert (Double.isNaN(vertices[iv2 + 1]));
                            return true;
                        }
                        return false;
                    }
                };
            }
            case CIRCLE: {
                double[] circle = area.getDataArray();
                double lonDeg = circle[0];
                double latDeg = circle[1];
                double rDeg = circle[2];
                final VertexData unitVertexData = PolygonOutliner.createSkyCircleVertexData(lonDeg, latDeg, rDeg, SkyDataGeom.GENERIC);
                if (NO_VERTEX_DATA.equals(unitVertexData)) {
                    return NO_VERTEX_DATA;
                }
                return new VertexData(){

                    @Override
                    public int getVertexCount() {
                        return unitVertexData.getVertexCount();
                    }

                    @Override
                    public boolean readDataPos(int ivert, double[] dpos) {
                        if (unitVertexData.readDataPos(ivert, dpos)) {
                            dpos[0] = dpos[0] * radius;
                            dpos[1] = dpos[1] * radius;
                            dpos[2] = dpos[2] * radius;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public boolean isBreak(int ivert) {
                        return unitVertexData.isBreak(ivert);
                    }
                };
            }
            case POINT: {
                double[] point = area.getDataArray();
                double[] dpos = new double[3];
                return PolygonOutliner.toSphere(point[0], point[1], radius, dpos) ? PolygonOutliner.createPointVertexData(dpos) : NO_VERTEX_DATA;
            }
            case MOC: {
                double[] duniqs = area.getDataArray();
                return new MocVertexData(duniqs, 5){

                    @Override
                    void copyLonlat(double lonRad, double latRad, double[] dpos) {
                        CdsHealpixUtil.lonlatToVector(lonRad, latRad, dpos);
                    }
                };
            }
            case MULTISHAPE: {
                VertexData[] vds = (VertexData[])Arrays.stream(Area.deserializeMultishape(area.getDataArray())).map(s -> PolygonOutliner.createSphereAreaVertexData(s, radius)).toArray(VertexData[]::new);
                return new MultiVertexData(vds);
            }
        }
        assert (false);
        return NO_VERTEX_DATA;
    }

    private static VertexData createPointVertexData(final double[] dpos0) {
        return new VertexData(){

            @Override
            public int getVertexCount() {
                return 1;
            }

            @Override
            public boolean readDataPos(int ivert, double[] dpos) {
                if (ivert == 0) {
                    System.arraycopy(dpos0, 0, dpos, 0, dpos0.length);
                    return true;
                }
                return false;
            }

            @Override
            public boolean isBreak(int ivert) {
                return false;
            }
        };
    }

    private static VertexData createSkyCircleVertexData(double lonDeg0, double latDeg0, double rDeg, SkyDataGeom skyGeom) {
        double latDeg1;
        double[] vec = new double[3];
        if (!PolygonOutliner.toSky(lonDeg0, latDeg0, skyGeom, vec)) {
            return NO_VERTEX_DATA;
        }
        final double x0 = vec[0];
        final double y0 = vec[1];
        final double z0 = vec[2];
        double d = latDeg1 = latDeg0 > 0.0 ? latDeg0 - rDeg : latDeg0 + rDeg;
        if (!PolygonOutliner.toSky(lonDeg0, latDeg1, skyGeom, vec)) {
            return NO_VERTEX_DATA;
        }
        final double x1 = vec[0];
        final double y1 = vec[1];
        final double z1 = vec[2];
        return new VertexData(){

            @Override
            public int getVertexCount() {
                return 36;
            }

            @Override
            public boolean readDataPos(int iv, double[] dpos) {
                double s = SINS[iv];
                double c = COSS[iv];
                double w = 1.0 - c;
                double r0 = x0 * x0 * w + c;
                double r1 = x0 * y0 * w + z0 * s;
                double r2 = x0 * z0 * w - y0 * s;
                double r3 = x0 * y0 * w - z0 * s;
                double r4 = y0 * y0 * w + c;
                double r5 = y0 * z0 * w + x0 * s;
                double r6 = x0 * z0 * w + y0 * s;
                double r7 = y0 * z0 * w - x0 * s;
                double r8 = z0 * z0 * w + c;
                dpos[0] = r0 * x1 + r1 * y1 + r2 * z1;
                dpos[1] = r3 * x1 + r4 * y1 + r5 * z1;
                dpos[2] = r6 * x1 + r7 * y1 + r8 * z1;
                return true;
            }

            @Override
            public boolean isBreak(int iv) {
                return false;
            }
        };
    }

    static {
        double thetaFact = 0.17453292519943295;
        for (int iv = 0; iv < 36; ++iv) {
            double theta = (double)iv * thetaFact;
            PolygonOutliner.COSS[iv] = Math.cos(theta);
            PolygonOutliner.SINS[iv] = Math.sin(theta);
        }
        NO_VERTEX_DATA = new VertexData(){

            @Override
            public int getVertexCount() {
                return 0;
            }

            @Override
            public boolean readDataPos(int ivert, double[] dpos) {
                return false;
            }

            @Override
            public boolean isBreak(int ivert) {
                return false;
            }
        };
    }

    private static abstract class AreaVertexReader
    implements VertexReader {
        private final AreaCoord<?> coord_;
        private final int icArea_;

        AreaVertexReader(AreaCoord<?> coord, int icArea) {
            this.coord_ = coord;
            this.icArea_ = icArea;
        }

        @Override
        public int getPosCoordIndex() {
            return this.icArea_;
        }

        @Override
        public VertexData readVertexData(Tuple tuple) {
            Area area = this.coord_.readAreaCoord(tuple, this.icArea_);
            if (area == null) {
                return NO_VERTEX_DATA;
            }
            Area.Type type = area.getType();
            if (type == null) {
                assert (false);
                return NO_VERTEX_DATA;
            }
            return this.createVertexData(area);
        }

        public abstract VertexData createVertexData(Area var1);
    }

    private static class MultiVertexData
    implements VertexData {
        private final VertexData[] vds_;

        MultiVertexData(VertexData[] vds) {
            this.vds_ = vds;
        }

        @Override
        public int getVertexCount() {
            return Arrays.stream(this.vds_).mapToInt(VertexData::getVertexCount).sum() + this.vds_.length - 1;
        }

        @Override
        public boolean isBreak(int ivert) {
            int jv = 0;
            for (VertexData vd : this.vds_) {
                if ((jv += vd.getVertexCount()) > ivert) {
                    return false;
                }
                if (jv == ivert) {
                    return true;
                }
                ++jv;
            }
            return false;
        }

        @Override
        public boolean readDataPos(int ivert, double[] dpos) {
            for (VertexData vd : this.vds_) {
                int nv = vd.getVertexCount();
                if (ivert < nv) {
                    return vd.readDataPos(ivert, dpos);
                }
                ivert -= nv + 1;
            }
            return false;
        }
    }

    private static abstract class MocVertexData
    implements VertexData {
        private final DoubleList lonList_;
        private final DoubleList latList_;
        private final int nvert_;

        MocVertexData(double[] duniqs, int minLevel) {
            this(duniqs, minLevel, new DoubleList(duniqs.length * 5), new DoubleList(duniqs.length * 5));
        }

        MocVertexData(double[] duniqs, int minLevel, DoubleList work1, DoubleList work2) {
            this.lonList_ = work1;
            this.latList_ = work2;
            this.lonList_.clear();
            this.latList_.clear();
            int nuniq = duniqs.length;
            double[][] vertworks = new double[4 << minLevel][2];
            int nvert = 0;
            for (int iu = 0; iu < nuniq; ++iu) {
                long uniq = Double.doubleToRawLongBits(duniqs[iu]);
                int order = 61 - Long.numberOfLeadingZeros(uniq) >> 1;
                long ipix = uniq - (4L << 2 * order);
                int nv = CdsHealpixUtil.lonlatVertices((VerticesAndPathComputer)Healpix.getNestedFast((int)order), ipix, minLevel, vertworks);
                if (nvert > 0) {
                    this.lonList_.add(Double.NaN);
                    this.latList_.add(Double.NaN);
                    ++nvert;
                }
                for (int iv = 0; iv < nv; ++iv) {
                    double[] lonlat = vertworks[iv];
                    this.lonList_.add(lonlat[0]);
                    this.latList_.add(lonlat[1]);
                }
                nvert += nv;
            }
            assert (this.lonList_.size() == this.latList_.size());
            assert (nvert == this.lonList_.size());
            this.nvert_ = nvert;
        }

        @Override
        public int getVertexCount() {
            return this.nvert_;
        }

        @Override
        public boolean isBreak(int ivert) {
            return Double.isNaN(this.lonList_.get(ivert));
        }

        @Override
        public boolean readDataPos(int ivert, double[] dpos) {
            double lonRad = this.lonList_.get(ivert);
            if (Double.isNaN(lonRad)) {
                assert (Double.isNaN(this.latList_.get(ivert)));
                return false;
            }
            double latRad = this.latList_.get(ivert);
            this.copyLonlat(lonRad, latRad, dpos);
            return true;
        }

        abstract void copyLonlat(double var1, double var3, double[] var5);
    }

    private static class SphereAreaVertexReaderFactory
    implements VertexReaderFactory {
        private final AreaCoord<SphereDataGeom> areaCoord_;
        private final int icArea_;
        private final FloatingCoord radialCoord_;
        private final int icRadial_;

        SphereAreaVertexReaderFactory(AreaCoord<SphereDataGeom> areaCoord, int icArea, FloatingCoord radialCoord, int icRadial) {
            this.areaCoord_ = areaCoord;
            this.icArea_ = icArea;
            this.radialCoord_ = radialCoord;
            this.icRadial_ = icRadial;
        }

        @Override
        public VertexReader createVertexReader(DataGeom geom) {
            return new VertexReader(){

                @Override
                public VertexData readVertexData(Tuple tuple) {
                    Area.Type type;
                    Area area;
                    double radius = radialCoord_.readDoubleCoord(tuple, icRadial_);
                    double d = radius = Double.isNaN(radius) ? 1.0 : radius;
                    if (radius > 0.0 && (area = areaCoord_.readAreaCoord(tuple, icArea_)) != null && (type = area.getType()) != null) {
                        return PolygonOutliner.createSphereAreaVertexData(area, radius);
                    }
                    return NO_VERTEX_DATA;
                }

                @Override
                public int getPosCoordIndex() {
                    return icArea_;
                }
            };
        }

        public int hashCode() {
            int code = 322987;
            code = 23 * code + this.areaCoord_.hashCode();
            code = 23 * code + this.icArea_;
            code = 23 * code + this.radialCoord_.hashCode();
            code = 23 * code + this.icRadial_;
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof SphereAreaVertexReaderFactory) {
                SphereAreaVertexReaderFactory other = (SphereAreaVertexReaderFactory)o;
                return this.areaCoord_.equals(other.areaCoord_) && this.icArea_ == other.icArea_ && this.radialCoord_.equals(other.radialCoord_) && this.icRadial_ == other.icRadial_;
            }
            return false;
        }
    }

    private static class SkyAreaVertexReaderFactory
    implements VertexReaderFactory {
        private final AreaCoord<SkyDataGeom> coord_;
        private final int icArea_;

        SkyAreaVertexReaderFactory(AreaCoord<SkyDataGeom> coord, int icArea) {
            this.coord_ = coord;
            this.icArea_ = icArea;
        }

        @Override
        public VertexReader createVertexReader(DataGeom geom0) {
            final SkyDataGeom skyGeom = this.coord_.getAreaDataGeom((SkyDataGeom)geom0);
            return new AreaVertexReader(this.coord_, this.icArea_){

                @Override
                public VertexData createVertexData(Area area) {
                    switch (area.getType()) {
                        case POLYGON: {
                            final double[][] dps = PolygonOutliner.toSkyVertices(area.getDataArray(), skyGeom);
                            return new VertexData(){

                                @Override
                                public int getVertexCount() {
                                    return dps.length;
                                }

                                @Override
                                public boolean readDataPos(int ivert, double[] dpos) {
                                    double[] dp = dps[ivert];
                                    if (dp != null) {
                                        System.arraycopy(dp, 0, dpos, 0, 3);
                                        return true;
                                    }
                                    return false;
                                }

                                @Override
                                public boolean isBreak(int ivert) {
                                    return dps[ivert] == null;
                                }
                            };
                        }
                        case CIRCLE: {
                            double[] circle = area.getDataArray();
                            double lonDeg = circle[0];
                            double latDeg = circle[1];
                            double rDeg = circle[2];
                            return PolygonOutliner.createSkyCircleVertexData(lonDeg, latDeg, rDeg, skyGeom);
                        }
                        case POINT: {
                            double[] point = area.getDataArray();
                            double[] dpos = new double[3];
                            return PolygonOutliner.toSky(point[0], point[1], skyGeom, dpos) ? PolygonOutliner.createPointVertexData(dpos) : NO_VERTEX_DATA;
                        }
                        case MOC: {
                            double[] duniqs = area.getDataArray();
                            final Rotation rotation = Rotation.createRotation(SkySys.EQUATORIAL, skyGeom.getViewSystem());
                            return new MocVertexData(duniqs, 5){

                                @Override
                                void copyLonlat(double lonRad, double latRad, double[] dpos) {
                                    CdsHealpixUtil.lonlatToVector(lonRad, latRad, dpos);
                                    rotation.rotate(dpos);
                                }
                            };
                        }
                        case MULTISHAPE: {
                            double[] data = area.getDataArray();
                            VertexData[] vds = (VertexData[])Arrays.stream(Area.deserializeMultishape(data)).map(s -> this.createVertexData((Area)s)).toArray(VertexData[]::new);
                            return new MultiVertexData(vds);
                        }
                    }
                    assert (false);
                    return NO_VERTEX_DATA;
                }
            };
        }

        public int hashCode() {
            int code = 3188803;
            code = 23 * code + this.coord_.hashCode();
            code = 23 * code + this.icArea_;
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof SkyAreaVertexReaderFactory) {
                SkyAreaVertexReaderFactory other = (SkyAreaVertexReaderFactory)o;
                return this.coord_.equals(other.coord_) && this.icArea_ == other.icArea_;
            }
            return false;
        }
    }

    private static class PlaneAreaVertexReaderFactory
    implements VertexReaderFactory {
        private final AreaCoord<PlaneDataGeom> coord_;
        private final int icArea_;

        PlaneAreaVertexReaderFactory(AreaCoord<PlaneDataGeom> coord, int icArea) {
            this.coord_ = coord;
            this.icArea_ = icArea;
        }

        @Override
        public VertexReader createVertexReader(DataGeom geom0) {
            PlaneDataGeom planeGeom = this.coord_.getAreaDataGeom((PlaneDataGeom)geom0);
            return new AreaVertexReader(this.coord_, this.icArea_){

                @Override
                public VertexData createVertexData(Area area) {
                    switch (area.getType()) {
                        case POLYGON: {
                            final double[] vertices = area.getDataArray();
                            return new VertexData(){

                                @Override
                                public int getVertexCount() {
                                    return vertices.length / 2;
                                }

                                @Override
                                public boolean readDataPos(int ivert, double[] dpos) {
                                    dpos[0] = vertices[ivert * 2 + 0];
                                    dpos[1] = vertices[ivert * 2 + 1];
                                    return true;
                                }

                                @Override
                                public boolean isBreak(int ivert) {
                                    int iv2 = ivert * 2;
                                    if (Double.isNaN(vertices[iv2])) {
                                        assert (Double.isNaN(vertices[iv2 + 1]));
                                        return true;
                                    }
                                    return false;
                                }
                            };
                        }
                        case CIRCLE: {
                            double[] circle = area.getDataArray();
                            final double cx = circle[0];
                            final double cy = circle[1];
                            final double r = circle[2];
                            return new VertexData(){

                                @Override
                                public int getVertexCount() {
                                    return 36;
                                }

                                @Override
                                public boolean readDataPos(int ivert, double[] dpos) {
                                    dpos[0] = cx + r * COSS[ivert];
                                    dpos[1] = cy - r * SINS[ivert];
                                    return true;
                                }

                                @Override
                                public boolean isBreak(int ivert) {
                                    return false;
                                }
                            };
                        }
                        case POINT: {
                            double[] point = area.getDataArray();
                            double[] dpos = new double[]{point[0], point[1]};
                            return PolygonOutliner.createPointVertexData(dpos);
                        }
                        case MOC: {
                            double[] duniqs = area.getDataArray();
                            return new MocVertexData(duniqs, 0){

                                @Override
                                void copyLonlat(double lonRad, double latRad, double[] dpos) {
                                    double lonDeg = Math.toDegrees(lonRad);
                                    double latDeg = Math.toDegrees(latRad);
                                    dpos[0] = lonDeg;
                                    dpos[1] = latDeg;
                                }
                            };
                        }
                        case MULTISHAPE: {
                            double[] data = area.getDataArray();
                            VertexData[] vds = (VertexData[])Arrays.stream(Area.deserializeMultishape(data)).map(s -> this.createVertexData((Area)s)).toArray(VertexData[]::new);
                            return new MultiVertexData(vds);
                        }
                    }
                    assert (false);
                    return NO_VERTEX_DATA;
                }
            };
        }

        public int hashCode() {
            int code = 812312;
            code = 23 * code + this.coord_.hashCode();
            code = 23 * code + this.icArea_;
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof PlaneAreaVertexReaderFactory) {
                PlaneAreaVertexReaderFactory other = (PlaneAreaVertexReaderFactory)o;
                return this.coord_.equals(other.coord_) && this.icArea_ == other.icArea_;
            }
            return false;
        }
    }

    private static abstract class ArrayVertexReader
    implements VertexReader {
        private final FloatingArrayCoord arrayCoord_;
        private final DataGeom geom_;
        private final boolean includePos_;
        private final int nuc_;
        private final int icPos0_;
        private final int icArray_;

        ArrayVertexReader(FloatingArrayCoord arrayCoord, DataGeom geom, boolean includePos) {
            this.arrayCoord_ = arrayCoord;
            this.geom_ = geom;
            this.includePos_ = includePos;
            int nuc = 0;
            for (Coord c : geom.getPosCoords()) {
                nuc += c.getInputs().length;
            }
            this.nuc_ = nuc;
            this.icPos0_ = 0;
            this.icArray_ = geom.getPosCoords().length;
        }

        @Override
        public VertexData readVertexData(final Tuple tuple) {
            int nv;
            final double[] array = this.arrayCoord_.readArrayCoord(tuple, this.icArray_);
            int nc = array.length;
            int n = nc % this.nuc_ == 0 ? nc / this.nuc_ + (this.includePos_ ? 1 : 0) : (nv = 0);
            if (this.includePos_) {
                return new VertexData(){

                    @Override
                    public int getVertexCount() {
                        return nv;
                    }

                    @Override
                    public boolean readDataPos(int ipos, double[] dpos) {
                        return ipos == 0 ? geom_.readDataPos(tuple, icPos0_, dpos) : this.readArrayPos(array, (ipos - 1) * nuc_, dpos);
                    }

                    @Override
                    public boolean isBreak(int ipos) {
                        return false;
                    }
                };
            }
            return new VertexData(){

                @Override
                public int getVertexCount() {
                    return nv;
                }

                @Override
                public boolean readDataPos(int ipos, double[] dpos) {
                    return this.readArrayPos(array, ipos * nuc_, dpos);
                }

                @Override
                public boolean isBreak(int ipos) {
                    return false;
                }
            };
        }

        @Override
        public int getPosCoordIndex() {
            return this.icPos0_;
        }

        abstract boolean readArrayPos(double[] var1, int var2, double[] var3);
    }

    private static class ArrayVertexReaderFactory
    implements VertexReaderFactory {
        private final FloatingArrayCoord arrayCoord_;
        private final boolean includePos_;

        ArrayVertexReaderFactory(FloatingArrayCoord arrayCoord, boolean includePos) {
            this.arrayCoord_ = arrayCoord;
            this.includePos_ = includePos;
        }

        @Override
        public VertexReader createVertexReader(DataGeom geom) {
            if (geom instanceof PlaneDataGeom) {
                return new ArrayVertexReader(this.arrayCoord_, geom, this.includePos_){

                    @Override
                    boolean readArrayPos(double[] array, int icPos, double[] dpos) {
                        double y;
                        double x = array[icPos];
                        if (!Double.isNaN(x) && !Double.isNaN(y = array[icPos + 1])) {
                            dpos[0] = x;
                            dpos[1] = y;
                            return true;
                        }
                        return false;
                    }
                };
            }
            if (geom instanceof CubeDataGeom) {
                return new ArrayVertexReader(this.arrayCoord_, geom, this.includePos_){

                    @Override
                    boolean readArrayPos(double[] array, int icPos, double[] dpos) {
                        double z;
                        double y;
                        double x = array[icPos];
                        if (!(Double.isNaN(x) || Double.isNaN(y = array[icPos + 1]) || Double.isNaN(z = array[icPos + 2]))) {
                            dpos[0] = x;
                            dpos[1] = y;
                            dpos[2] = z;
                            return true;
                        }
                        return false;
                    }
                };
            }
            if (geom instanceof SphereDataGeom) {
                return new ArrayVertexReader(this.arrayCoord_, geom, this.includePos_){

                    @Override
                    boolean readArrayPos(double[] array, int icPos, double[] dpos) {
                        double lonDeg = array[icPos + 0];
                        double latDeg = array[icPos + 1];
                        double radius = array[icPos + 2];
                        return PolygonOutliner.toSphere(lonDeg, latDeg, radius, dpos);
                    }
                };
            }
            if (geom instanceof SkyDataGeom) {
                final SkyDataGeom skyGeom = (SkyDataGeom)geom;
                return new ArrayVertexReader(this.arrayCoord_, geom, this.includePos_){

                    @Override
                    boolean readArrayPos(double[] array, int icPos, double[] dpos) {
                        return PolygonOutliner.toSky(array[icPos], array[icPos + 1], skyGeom, dpos);
                    }
                };
            }
            assert (false);
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            int code = 222389;
            code = 23 * code + this.arrayCoord_.hashCode();
            code = 23 * code + (this.includePos_ ? 17 : 29);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof ArrayVertexReaderFactory) {
                ArrayVertexReaderFactory other = (ArrayVertexReaderFactory)o;
                return this.arrayCoord_.equals(other.arrayCoord_) && this.includePos_ == other.includePos_;
            }
            return false;
        }
    }

    private static class FixedVertexReaderFactory
    implements VertexReaderFactory {
        private final int np_;

        FixedVertexReaderFactory(int np) {
            this.np_ = np;
        }

        @Override
        public VertexReader createVertexReader(final DataGeom geom) {
            final int[] icPos = new int[this.np_];
            for (int ip = 0; ip < this.np_; ++ip) {
                icPos[ip] = this.getPosCoordIndex(ip, geom);
            }
            return new VertexReader(){

                @Override
                public VertexData readVertexData(final Tuple tuple) {
                    return new VertexData(){

                        @Override
                        public int getVertexCount() {
                            return np_;
                        }

                        @Override
                        public boolean readDataPos(int ipos, double[] dpos) {
                            return geom.readDataPos(tuple, icPos[ipos], dpos);
                        }

                        @Override
                        public boolean isBreak(int ipos) {
                            return false;
                        }
                    };
                }

                @Override
                public int getPosCoordIndex() {
                    return icPos[0];
                }
            };
        }

        public int hashCode() {
            int code = 288901;
            code = 23 * code + this.np_;
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof FixedVertexReaderFactory) {
                FixedVertexReaderFactory other = (FixedVertexReaderFactory)o;
                return this.np_ == other.np_;
            }
            return false;
        }

        private int getPosCoordIndex(int ivert, DataGeom geom) {
            return geom.getPosCoords().length * ivert;
        }
    }

    private static interface VertexData {
        public int getVertexCount();

        public boolean readDataPos(int var1, double[] var2);

        public boolean isBreak(int var1);
    }

    private static interface VertexReader {
        public VertexData readVertexData(Tuple var1);

        public int getPosCoordIndex();
    }

    @Equality
    private static interface VertexReaderFactory {
        public VertexReader createVertexReader(DataGeom var1);
    }
}

