/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.swing.Icon;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Plotter;
import uk.ac.starlink.ttools.plot2.ReportKey;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.ReportMeta;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.BooleanConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.geom.PlanarSurface;
import uk.ac.starlink.ttools.plot2.geom.SliceDataGeom;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotLayer;
import uk.ac.starlink.ttools.plot2.layer.BinSizer;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.ttools.plot2.layer.HistogramPlotter;
import uk.ac.starlink.ttools.plot2.layer.LineStyle;
import uk.ac.starlink.ttools.plot2.layer.LineTracer;
import uk.ac.starlink.ttools.plot2.layer.Normalisation;
import uk.ac.starlink.ttools.plot2.layer.Unit;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;
import uk.ac.starlink.util.SplitCollector;

public class Stats1Plotter
implements Plotter<StatsStyle> {
    private final FloatingCoord xCoord_;
    private final FloatingCoord weightCoord_;
    private final ConfigKey<Unit> unitKey_;
    private final CoordGroup fitCoordGrp_;
    private final int icX_;
    private final int icWeight_;
    public static final ReportKey<Double> CONST_KEY = ReportKey.createDoubleKey(new ReportMeta("c", "Factor"), true);
    public static final ReportKey<Double> MEAN_KEY = ReportKey.createDoubleKey(new ReportMeta("mu", "Mean"), true);
    public static final ReportKey<Double> STDEV_KEY = ReportKey.createDoubleKey(new ReportMeta("sigma", "Standard Deviation"), true);
    public static final ReportKey<String> FUNCTION_KEY = ReportKey.createStringKey(new ReportMeta("function", "Function"), true);
    public static final ConfigKey<BinSizer> BINSIZER_KEY = HistogramPlotter.BINSIZER_KEY;
    public static final ConfigKey<Normalisation> NORMALISE_KEY = StyleKeys.NORMALISE;
    public static final ConfigKey<Boolean> SHOWMEAN_KEY = new BooleanConfigKey(new ConfigMeta("showmean", "Show Mean").setShortDescription("Display a line at the mean").setXmlDescription(new String[]{"<p>If true, a line is drawn at the position of", "the calculated mean.", "</p>"}), true);

    public Stats1Plotter(FloatingCoord xCoord, boolean hasWeight, ConfigKey<Unit> unitKey) {
        this.xCoord_ = xCoord;
        this.unitKey_ = unitKey;
        if (hasWeight) {
            this.weightCoord_ = FloatingCoord.WEIGHT_COORD;
            this.fitCoordGrp_ = CoordGroup.createPartialCoordGroup(new Coord[]{xCoord, this.weightCoord_}, new boolean[]{false, false});
        } else {
            this.weightCoord_ = null;
            this.fitCoordGrp_ = CoordGroup.createPartialCoordGroup(new Coord[]{xCoord}, new boolean[]{false});
        }
        this.icX_ = this.fitCoordGrp_.getExtraCoordIndex(0, null);
        this.icWeight_ = hasWeight ? this.fitCoordGrp_.getExtraCoordIndex(1, null) : -1;
    }

    @Override
    public String getPlotterName() {
        return "Gaussian";
    }

    @Override
    public Icon getPlotterIcon() {
        return ResourceIcon.FORM_GAUSSIAN;
    }

    @Override
    public boolean hasReports() {
        return true;
    }

    @Override
    public String getPlotterDescription() {
        return PlotUtil.concatLines(new String[]{"<p>Plots a best fit Gaussian to the histogram of", "a sample of data.", "In fact, all this plotter does is to calculate the mean", "and standard deviation of the sample,", "and plot the corresponding Gaussian curve.", "The mean and standard deviation values are reported by the plot.", "</p>", "<p>The <code>" + NORMALISE_KEY + "</code> config option,", "perhaps in conjunction with <code>" + BINSIZER_KEY + "</code>,", "can be used to scale the height of the plotted curve", "in data units.", "In this case, <code>" + BINSIZER_KEY + "</code>", "just describes the bar width of a notional histogram", "whose outline the plotted Gaussian should try to fit,", "and is only relevant for some of the normalisation options.", "</p>"});
    }

    @Override
    public CoordGroup getCoordGroup() {
        return this.fitCoordGrp_;
    }

    @Override
    public ConfigKey<?>[] getStyleKeys() {
        ArrayList list = new ArrayList();
        list.add(StyleKeys.COLOR);
        list.add(SHOWMEAN_KEY);
        list.add(StyleKeys.SIDEWAYS);
        list.addAll(Arrays.asList(StyleKeys.getStrokeKeys()));
        list.add(StyleKeys.ANTIALIAS);
        if (this.unitKey_ != null) {
            list.add(this.unitKey_);
        }
        list.add(NORMALISE_KEY);
        list.add(BINSIZER_KEY);
        return list.toArray(new ConfigKey[0]);
    }

    @Override
    public StatsStyle createStyle(ConfigMap config) {
        Color color = config.get(StyleKeys.COLOR);
        boolean showmean = Boolean.TRUE.equals(config.get(SHOWMEAN_KEY));
        boolean isY = config.get(StyleKeys.SIDEWAYS);
        Stroke stroke = StyleKeys.createStroke(config, 1, 1);
        boolean antialias = config.get(StyleKeys.ANTIALIAS);
        Normalisation norm = config.get(NORMALISE_KEY);
        Unit unit = this.unitKey_ == null ? Unit.UNIT : config.get(this.unitKey_);
        BinSizer sizer = config.get(BINSIZER_KEY);
        return new StatsStyle(color, stroke, antialias, showmean, norm, unit, sizer, isY);
    }

    @Override
    public Object getRangeStyleKey(StatsStyle style) {
        return style.norm_;
    }

    @Override
    public PlotLayer createLayer(final DataGeom geom, final DataSpec dataSpec, final StatsStyle style) {
        LayerOpt layerOpt = new LayerOpt(style.getColor(), true);
        final boolean isY = style.isY_;
        SliceDataGeom fitDataGeom = isY ? new SliceDataGeom(new FloatingCoord[]{null, this.xCoord_}, "Y") : new SliceDataGeom(new FloatingCoord[]{this.xCoord_, null}, "X");
        return new AbstractPlotLayer(this, fitDataGeom, dataSpec, style, layerOpt){

            @Override
            public Drawing createDrawing(Surface surface, Map<AuxScale, Span> auxSpans, PaperType paperType) {
                return new StatsDrawing((PlanarSurface)surface, geom, dataSpec, style, paperType);
            }

            @Override
            public void extendCoordinateRanges(Range[] ranges, Scale[] scales, DataStore dataStore) {
                Scale scale = scales[isY ? 1 : 0];
                WStats stats = Stats1Plotter.this.collectStats(scale, dataSpec, dataStore);
                StatsPlan plan = new StatsPlan(scale, stats, dataSpec);
                double mean = stats.getMean();
                double sd = stats.getSigma();
                Range xRange = ranges[isY ? 1 : 0];
                xRange.submit(mean - sd * 2.0);
                xRange.submit(mean + sd * 2.0);
                if (xRange.isFinite()) {
                    double[] xlims = xRange.getFiniteBounds(scale.isPositiveDefinite());
                    double yhi = plan.getFactor(xlims[0], xlims[1], style);
                    Range yRange = ranges[isY ? 0 : 1];
                    yRange.submit(0.0);
                    yRange.submit(yhi);
                }
            }
        };
    }

    private WStats collectStats(final Scale scale, DataSpec dataSpec, DataStore dataStore) {
        final boolean isUnweighted = this.weightCoord_ == null || dataSpec.isCoordBlank(this.icWeight_);
        SplitCollector<TupleSequence, WStats> collector = new SplitCollector<TupleSequence, WStats>(){

            public WStats createAccumulator() {
                return new WStats();
            }

            public void accumulate(TupleSequence tseq, WStats stats) {
                if (isUnweighted) {
                    while (tseq.next()) {
                        double x = Stats1Plotter.this.xCoord_.readDoubleCoord(tseq, Stats1Plotter.this.icX_);
                        double s = scale.dataToScale(x);
                        if (!PlotUtil.isFinite(s)) continue;
                        stats.addPoint(s);
                    }
                } else {
                    while (tseq.next()) {
                        double x = Stats1Plotter.this.xCoord_.readDoubleCoord(tseq, Stats1Plotter.this.icX_);
                        double s = scale.dataToScale(x);
                        if (!PlotUtil.isFinite(s)) continue;
                        double w = Stats1Plotter.this.weightCoord_.readDoubleCoord(tseq, Stats1Plotter.this.icWeight_);
                        stats.addPoint(s, w);
                    }
                }
            }

            public WStats combine(WStats stats1, WStats stats2) {
                stats1.add(stats2);
                return stats1;
            }
        };
        return PlotUtil.tupleCollect(collector, dataSpec, dataStore);
    }

    private static class WStats {
        private double sw_;
        private double swX_;
        private double swXX_;

        private WStats() {
        }

        public void addPoint(double x, double w) {
            if (w > 0.0 && !Double.isInfinite(w)) {
                this.sw_ += w;
                this.swX_ += w * x;
                this.swXX_ += w * x * x;
            }
        }

        public void addPoint(double x) {
            this.sw_ += 1.0;
            this.swX_ += x;
            this.swXX_ += x * x;
        }

        public void add(WStats other) {
            this.sw_ += other.sw_;
            this.swX_ += other.swX_;
            this.swXX_ += other.swXX_;
        }

        public double getMean() {
            return this.swX_ / this.sw_;
        }

        public double getSigma() {
            return Math.sqrt((this.swXX_ - this.swX_ * this.swX_ / this.sw_) / this.sw_);
        }

        public double getSum() {
            return this.sw_;
        }
    }

    private static class StatsPlan {
        final Scale scale_;
        final double mean_;
        final double sigma_;
        final double sum_;
        final DataSpec dataSpec_;

        StatsPlan(Scale scale, WStats stats, DataSpec dataSpec) {
            this.scale_ = scale;
            this.mean_ = stats.getMean();
            this.sigma_ = stats.getSigma();
            this.sum_ = stats.getSum();
            this.dataSpec_ = dataSpec;
        }

        boolean matches(Scale scale, DataSpec dataSpec) {
            return scale.equals(this.scale_) && dataSpec.equals(this.dataSpec_);
        }

        void paintLine(Graphics g, PlanarSurface surface, StatsStyle style, boolean isBitmap) {
            double factor = this.getFactor(surface, style);
            boolean isY = style.isY_;
            Axis xAxis = surface.getAxes()[isY ? 1 : 0];
            Axis yAxis = surface.getAxes()[isY ? 0 : 1];
            Graphics2D g2 = (Graphics2D)g;
            Rectangle box = surface.getPlotBounds();
            int gxlo = xAxis.getGraphicsLimits()[0] - 2;
            int gxhi = xAxis.getGraphicsLimits()[1] + 2;
            int np = gxhi - gxlo;
            LineTracer tracer = style.createLineTracer(g2, box, np, isBitmap);
            Color color = style.getColor();
            for (int ip = 0; ip < np; ++ip) {
                double dy;
                double gy;
                double gx = gxlo + ip;
                double dx = xAxis.graphicsToData(gx);
                if (Double.isNaN(dx) || Double.isNaN(gy = yAxis.dataToGraphics(dy = factor * this.gaussian(dx)))) continue;
                tracer.addVertex(isY ? gy : gx, isY ? gx : gy, color);
            }
            tracer.flush();
            if (style.showmean_) {
                double dx = this.mean_;
                double gx = xAxis.dataToGraphics(dx);
                double gylo = yAxis.dataToGraphics(0.0);
                double gyhi = yAxis.dataToGraphics(factor);
                LineTracer meanTracer = style.createLineTracer(g2, box, 3, isBitmap);
                if (isY) {
                    meanTracer.addVertex(gylo, gx, color);
                    meanTracer.addVertex(gyhi, gx, color);
                } else {
                    meanTracer.addVertex(gx, gylo, color);
                    meanTracer.addVertex(gx, gyhi, color);
                }
                meanTracer.flush();
            }
        }

        private double getFactor(PlanarSurface surface, StatsStyle style) {
            boolean isY = style.isY_;
            double[] xlims = surface.getDataLimits()[isY ? 1 : 0];
            return this.getFactor(xlims[0], xlims[1], style);
        }

        private double getFactor(double xlo, double xhi, StatsStyle style) {
            BinSizer sizer = style.sizer_;
            double binWidth = sizer.getScaleWidth(this.scale_, xlo, xhi, true) / style.unit_.getExtent();
            double c = 1.0 / (this.sigma_ * Math.sqrt(Math.PI * 2));
            double sum = this.sum_;
            double max = c * sum * binWidth;
            boolean isCumulative = false;
            Combiner.Type ctype = Combiner.Type.EXTENSIVE;
            double normFactor = style.norm_.getScaleFactor(sum, max, binWidth, ctype, isCumulative);
            return normFactor * c * this.sum_ * binWidth;
        }

        double gaussian(double x) {
            double s = this.scale_.dataToScale(x);
            double p = (s - this.mean_) / this.sigma_;
            return Math.exp(-0.5 * p * p);
        }

        public ReportMap getReport(PlanarSurface surface, StatsStyle style) {
            ReportMap report = new ReportMap();
            double factor = this.getFactor(surface, style);
            report.put(MEAN_KEY, this.mean_);
            report.put(STDEV_KEY, this.sigma_);
            report.put(CONST_KEY, factor);
            String function = new StringBuffer().append(CONST_KEY.toText(factor)).append(" * ").append("exp(-0.5 * square((").append(this.scale_.dataToScaleExpression("x")).append("-").append(MEAN_KEY.toText(this.mean_)).append(")/").append(STDEV_KEY.toText(this.sigma_)).append("))").toString();
            report.put(FUNCTION_KEY, function);
            return report;
        }
    }

    private class StatsDrawing
    implements Drawing {
        private final PlanarSurface surface_;
        private final DataGeom geom_;
        private final DataSpec dataSpec_;
        private final StatsStyle style_;
        private final PaperType paperType_;

        StatsDrawing(PlanarSurface surface, DataGeom geom, DataSpec dataSpec, StatsStyle style, PaperType paperType) {
            this.surface_ = surface;
            this.geom_ = geom;
            this.dataSpec_ = dataSpec;
            this.style_ = style;
            this.paperType_ = paperType;
        }

        @Override
        public Object calculatePlan(Object[] knownPlans, DataStore dataStore) {
            Scale scale = this.surface_.getAxes()[this.style_.isY_ ? 1 : 0].getScale();
            for (Object plan : knownPlans) {
                if (!(plan instanceof StatsPlan) || !((StatsPlan)plan).matches(scale, this.dataSpec_)) continue;
                return plan;
            }
            WStats stats = Stats1Plotter.this.collectStats(scale, this.dataSpec_, dataStore);
            return new StatsPlan(scale, stats, this.dataSpec_);
        }

        @Override
        public void paintData(Object plan, Paper paper, DataStore dataStore) {
            final StatsPlan splan = (StatsPlan)plan;
            this.paperType_.placeDecal(paper, new Decal(){

                @Override
                public void paintDecal(Graphics g) {
                    splan.paintLine(g, StatsDrawing.this.surface_, StatsDrawing.this.style_, StatsDrawing.this.paperType_.isBitmap());
                }

                @Override
                public boolean isOpaque() {
                    return !StatsDrawing.this.style_.getAntialias();
                }
            });
        }

        @Override
        public ReportMap getReport(Object plan) {
            return ((StatsPlan)plan).getReport(this.surface_, this.style_);
        }
    }

    public static class StatsStyle
    extends LineStyle {
        final boolean showmean_;
        final Normalisation norm_;
        final Unit unit_;
        final BinSizer sizer_;
        final boolean isY_;

        public StatsStyle(Color color, Stroke stroke, boolean antialias, boolean showmean, Normalisation norm, Unit unit, BinSizer sizer, boolean isY) {
            super(color, stroke, antialias);
            this.showmean_ = showmean;
            this.norm_ = norm;
            this.unit_ = unit;
            this.sizer_ = sizer;
            this.isY_ = isY;
        }

        @Override
        public int hashCode() {
            int code = super.hashCode();
            code = 23 * code + (this.showmean_ ? 11 : 17);
            code = 23 * code + PlotUtil.hashCode(this.norm_);
            code = 23 * code + this.unit_.hashCode();
            code = 23 * code + PlotUtil.hashCode(this.sizer_);
            code = 23 * code + (this.isY_ ? 71 : 41);
            return code;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof StatsStyle) {
                StatsStyle other = (StatsStyle)o;
                return super.equals(other) && this.showmean_ == other.showmean_ && PlotUtil.equals(this.norm_, other.norm_) && this.unit_.equals(other.unit_) && PlotUtil.equals(this.sizer_, other.sizer_) && this.isY_ == other.isY_;
            }
            return false;
        }
    }
}

