/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.task;

import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.plot2.config.ConfigException;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;

public class ConfigParameter<T>
extends Parameter<T> {
    private final ConfigKey<T> key_;

    private ConfigParameter(ConfigKey<T> key, String baseName, String suffix, String suffixType, boolean hasSuffixDetail, String exampleSuffix) {
        super(baseName + suffix, key.getValueClass(), true);
        boolean nullPermitted;
        this.key_ = key;
        this.setStringDefault(key.valueToString(key.getDefaultValue()));
        try {
            key.stringToValue(null);
            nullPermitted = true;
        }
        catch (Exception e) {
            nullPermitted = false;
        }
        this.setNullPermitted(nullPermitted);
        ConfigMeta meta = key.getMeta();
        String usage = meta.getStringUsage();
        String prompt = meta.getShortDescription();
        String descrip = meta.getXmlDescription();
        if (hasSuffixDetail) {
            if (suffix != null && suffix.length() > 0 && prompt != null && prompt.length() > 0) {
                prompt = prompt + " for " + suffixType + " " + suffix;
            }
            String extraDescrip = suffix != null && suffix.length() > 0 ? new StringBuffer().append("<p>This parameter affects ").append(suffixType).append(" <code>").append(suffix).append("</code>; if the <code>").append(suffix).append("</code> suffix is ommitted, it affects all ").append(suffixType).append("s.</p>\n").toString() : new StringBuffer().append("<p>If a ").append(suffixType).append(" suffix is appended to the parameter name,\n").append("only that ").append(suffixType).append(" is affected,\n").append("e.g. <code>").append(baseName).append(exampleSuffix).append("</code> affects only ").append(suffixType).append(" <code>").append(exampleSuffix).append("</code>.</p>\n").toString();
            if (descrip != null && descrip.length() > 0) {
                descrip = new StringBuffer().append(descrip).append(extraDescrip).toString();
            }
        }
        if (usage != null) {
            this.setUsage(usage);
        }
        this.setPrompt(prompt);
        this.setDescription(descrip);
    }

    public ConfigParameter(ConfigKey<T> key) {
        this(key, key.getMeta().getShortName(), "", null, false, "???");
    }

    public T stringToObject(Environment env, String stringval) throws TaskException {
        try {
            return this.key_.stringToValue(stringval);
        }
        catch (ConfigException e) {
            throw new ParameterValueException((Parameter)this, (Throwable)e);
        }
    }

    public String objectToString(Environment env, T objval) {
        return this.key_.valueToString(objval);
    }

    public void setDefaultOption(T dflt) {
        this.setStringDefault(dflt == null ? null : this.key_.valueToString(dflt));
    }

    public static <T> ConfigParameter<T> createConfigParameter(ConfigKey<T> key) {
        return new ConfigParameter<T>(key);
    }

    public static <T> ConfigParameter<T> createLayerSuffixedParameter(ConfigKey<T> key, String layerSuffix, boolean hasSuffixDetail) {
        return new ConfigParameter<T>(key, key.getMeta().getShortName(), layerSuffix == null ? "" : layerSuffix, "layer", hasSuffixDetail, "N");
    }

    public static <T> ConfigParameter<T> createZoneSuffixedParameter(ConfigKey<T> key, String zoneSuffix, boolean hasSuffixDetail) {
        return new ConfigParameter<T>(key, key.getMeta().getShortName(), zoneSuffix == null ? "" : zoneSuffix, "zone", hasSuffixDetail, "Z");
    }
}

