/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import org.xml.sax.Locator;
import uk.ac.starlink.ttools.taplint.AdhocCode;
import uk.ac.starlink.ttools.taplint.ReportType;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.ttools.votlint.SaxMessager;
import uk.ac.starlink.ttools.votlint.VotLintCode;

public class ReporterSaxMessager
implements SaxMessager {
    private final Reporter reporter_;
    static final char VOTLINT_PREFIX_CHAR = 'Y';

    public ReporterSaxMessager(Reporter reporter) {
        this.reporter_ = reporter;
    }

    @Override
    public void reportMessage(SaxMessager.Level level, VotLintCode vcode, String msg, Locator locator) {
        ReportType type = this.getReportType(level);
        String label = 'Y' + vcode.getCode();
        AdhocCode code = new AdhocCode(type, label);
        int il = -1;
        int ic = -1;
        if (locator != null) {
            ic = locator.getColumnNumber();
            il = locator.getLineNumber();
        }
        StringBuffer sbuf = new StringBuffer();
        if (il > 0) {
            sbuf.append(" (l.").append(il);
            if (ic > 0) {
                sbuf.append(", c.").append(ic);
            }
            sbuf.append(")");
        }
        sbuf.append(": ").append(msg);
        this.reporter_.report(code, sbuf.toString());
    }

    private ReportType getReportType(SaxMessager.Level level) {
        switch (level) {
            case INFO: {
                return ReportType.INFO;
            }
            case WARNING: {
                return ReportType.WARNING;
            }
            case ERROR: {
                return ReportType.ERROR;
            }
        }
        assert (false);
        return ReportType.FAILURE;
    }
}

