/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.io.IOException;
import java.text.DecimalFormat;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.vo.TapQuery;

public abstract class TapRunner {
    private final String description_;
    private int nQuery_;
    private int nResult_;
    private long queryTime_;

    protected TapRunner(String description) {
        this.description_ = description;
    }

    public String getDescription() {
        return this.description_;
    }

    public StarTable getResultTable(Reporter reporter, TapQuery tq) {
        try {
            return this.attemptGetResultTable(reporter, tq);
        }
        catch (IOException e) {
            reporter.report(FixedCode.E_QERR, "TAP query failed", e);
            return null;
        }
        catch (SAXException e) {
            reporter.report(FixedCode.E_QERX, "TAP query result parse failed", e);
            return null;
        }
    }

    public StarTable attemptGetResultTable(Reporter reporter, TapQuery tq) throws IOException, SAXException {
        reporter.report(FixedCode.I_QSUB, "Submitting query: " + tq.getAdql().trim().replaceAll("\\s+", " "));
        ++this.nQuery_;
        long start = System.currentTimeMillis();
        StarTable table = this.executeQuery(reporter, tq);
        this.queryTime_ += System.currentTimeMillis() - start;
        ++this.nResult_;
        return table;
    }

    protected abstract StarTable executeQuery(Reporter var1, TapQuery var2) throws IOException, SAXException;

    public void reportSummary(Reporter reporter) {
        String cmsg = "Successful/submitted TAP queries: " + this.nResult_ + "/" + this.nQuery_;
        reporter.report(FixedCode.S_QNUM, cmsg);
        if (this.nResult_ > 0) {
            double qtime = 0.001 * (double)this.queryTime_ / (double)this.nResult_;
            String fmt = "0.0";
            if (qtime < 0.2) {
                fmt = "0.00";
            }
            if (qtime < 0.02) {
                fmt = "0.000";
            }
            String tmsg = "Average successful query time: " + new DecimalFormat(fmt).format(qtime) + "s";
            reporter.report(FixedCode.S_QTIM, tmsg);
        }
    }
}

