/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.task.FilterParameter;
import uk.ac.starlink.ttools.task.InputTableSpec;
import uk.ac.starlink.ttools.task.InputTablesParameter;
import uk.ac.starlink.ttools.task.TableProducer;
import uk.ac.starlink.ttools.task.TablesInput;

public class HomogeneousTablesInput
implements TablesInput {
    private final InputTablesParameter inTablesParam_;
    private final FilterParameter inFilterParam_;
    private final Parameter<?>[] params_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.task");

    public HomogeneousTablesInput(boolean useInFilter) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        this.inTablesParam_ = new InputTablesParameter("in");
        this.inTablesParam_.setUsage("<table> [<table> ...]");
        this.inTablesParam_.setPrompt("Location of input table(s)");
        paramList.add((Object)this.inTablesParam_);
        paramList.add(this.inTablesParam_.getFormatParameter());
        paramList.add(this.inTablesParam_.getMultiParameter());
        paramList.add(this.inTablesParam_.getStreamParameter());
        if (useInFilter) {
            this.inFilterParam_ = new FilterParameter("icmd");
            this.inFilterParam_.setTableDescription("each input table", this.inTablesParam_, Boolean.TRUE);
            paramList.add(this.inFilterParam_);
        } else {
            this.inFilterParam_ = null;
        }
        this.params_ = paramList.toArray(new Parameter[0]);
    }

    @Override
    public Parameter<?>[] getParameters() {
        return this.params_;
    }

    @Override
    public InputTableSpec[] getInputSpecs(Environment env) throws TaskException {
        ProcessingStep[] steps = this.inFilterParam_ == null ? null : this.inFilterParam_.stepsValue(env);
        TableProducer[] tprods = (TableProducer[])this.inTablesParam_.objectValue(env);
        final int nIn = tprods.length;
        InputTableSpec[] specs = new InputTableSpec[nIn];
        for (int i = 0; i < nIn; ++i) {
            final int index = i;
            final TableProducer tprod = tprods[i];
            specs[i] = new InputTableSpec(tprod.toString(), steps){

                @Override
                public StarTable getInputTable() throws TaskException {
                    try {
                        logger_.config("Input table " + (index + 1) + "/" + nIn);
                        return tprod.getTable();
                    }
                    catch (IOException e) {
                        throw new TaskException(e.getMessage(), (Throwable)e);
                    }
                }
            };
        }
        return specs;
    }

    public InputTablesParameter getInputTableParameter(int i) {
        return this.inTablesParam_;
    }

    @Override
    public FilterParameter getFilterParameter(int i) {
        return this.inFilterParam_;
    }
}

