/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.util.ArrayList;
import java.util.logging.Logger;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.MultiParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.task.AbstractInputTableParameter;
import uk.ac.starlink.ttools.task.TableProducer;

public class InputTablesParameter
extends AbstractInputTableParameter<TableProducer[]>
implements MultiParameter {
    private final BooleanParameter multiParam_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.task");

    public InputTablesParameter(String name) {
        super(name, TableProducer[].class);
        this.setUsage("<table> ...");
        String indir = String.valueOf('@');
        this.setDescription(new String[]{"<p>Locations of the input tables.", "Either specify the parameter multiple times, or supply the", "input tables as a space-separated list within a single use.", "</p>", "<p>The following table location forms are allowed:", InputTablesParameter.getLocationFormList(this.getFormatParameter()), "Compression in any of the supported compression formats", "(Unix compress, gzip or bzip2)", "is expanded automatically.", "</p>", "<p>A list of input table locations may be given in an external", "file by using the indirction character '" + indir + "'.", "Thus \"<code>" + this.getName() + "=" + indir + "filename</code>\"", "causes the file <code>filename</code> to be read for a list", "of input table locations.  The locations in the file should", "each be on a separate line.", "</p>"});
        this.getStreamParameter().setDescription(new String[]{this.getStreamParameter().getDescription(), "<p>The same streaming flag applies to all the tables specified by", "<code>" + this.getName() + "</code>.", "</p>"});
        this.getFormatParameter().setDescription(new String[]{this.getFormatParameter().getDescription(), "<p>The same format parameter applies to all the tables", "specified by <code>" + this.getName() + "</code>.", "</p>"});
        this.multiParam_ = new BooleanParameter("multi");
        this.multiParam_.setPrompt("Load all tables from each input file");
        this.multiParam_.setDescription(new String[]{"<p>Determines whether all tables, or just the first one,", "from input table files will be used.", "If set <code>false</code>, then just the first table from each", "file named by <code>" + this.getName() + "</code>", "will be used.", "If <code>true</code>, then all tables present in those", "input files will be used.", "This only has an effect for file formats which are capable", "of containing more than one table, which effectively means", "FITS and VOTable and their variants.", "</p>"});
        this.multiParam_.setBooleanDefault(false);
    }

    public BooleanParameter getMultiParameter() {
        return this.multiParam_;
    }

    public char getValueSeparator() {
        return '\u00a0';
    }

    public TableProducer[] stringToObject(final Environment env, String sval) throws TaskException {
        String[] locs = this.stringToStrings(sval);
        int nloc = locs.length;
        this.getFormatParameter().stringValue(env);
        this.getStreamParameter().stringValue(env);
        if (this.multiParam_.booleanValue(env)) {
            ArrayList<1> tprodList = new ArrayList<1>();
            for (int il = 0; il < nloc; ++il) {
                String loc = locs[il];
                StarTable[] tables = this.makeTables(env, loc);
                int ntab = tables.length;
                for (int itab = 0; itab < ntab; ++itab) {
                    final StarTable table = tables[itab];
                    final String loci = ntab == 1 ? loc : loc + "#" + (itab + 1);
                    tprodList.add(new TableProducer(){

                        @Override
                        public StarTable getTable() {
                            return table;
                        }

                        public String toString() {
                            return loci;
                        }
                    });
                }
            }
            return tprodList.toArray(new TableProducer[0]);
        }
        TableProducer[] tprods = new TableProducer[nloc];
        for (int i = 0; i < nloc; ++i) {
            final String loc = locs[i];
            tprods[i] = new TableProducer(){

                @Override
                public StarTable getTable() throws TaskException {
                    return InputTablesParameter.this.makeTable(env, loc);
                }

                public String toString() {
                    return loc;
                }
            };
        }
        return tprods;
    }

    private String[] stringToStrings(String sval) throws TaskException {
        return sval.indexOf(this.getValueSeparator()) >= 0 ? sval.split("\\" + this.getValueSeparator()) : sval.trim().split(" +");
    }

    public String objectToString(Environment env, TableProducer[] tables) {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < tables.length; ++i) {
            if (i > 0) {
                sbuf.append(' ');
            }
            sbuf.append(tables[i].toString());
        }
        return sbuf.toString();
    }
}

