/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.util.ArrayList;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.ObjectFactoryParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.Formatter;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.mode.ProcessingMode;
import uk.ac.starlink.ttools.task.ExtraParameter;
import uk.ac.starlink.ttools.task.OutputFormatParameter;
import uk.ac.starlink.ttools.task.TableConsumerParameter;
import uk.ac.starlink.ttools.task.TableEnvironment;
import uk.ac.starlink.util.LoadException;

public class OutputModeParameter
extends ObjectFactoryParameter<ProcessingMode>
implements TableConsumerParameter,
ExtraParameter {
    public OutputModeParameter(String name) {
        super(name, Stilts.getModeFactory());
        this.setPrompt("Output mode");
        this.setStringDefault("out");
        this.setUsage("<out-mode> <mode-args>");
        StringBuffer sbuf = new StringBuffer();
        String[] modeNames = this.getObjectFactory().getNickNames();
        sbuf.append("<ul>\n");
        for (int i = 0; i < modeNames.length; ++i) {
            sbuf.append("<li><code>").append(modeNames[i]).append("</code></li>").append('\n');
        }
        sbuf.append("</ul>\n");
        String modeList = sbuf.toString();
        this.setDescription(new String[]{"<p>The mode in which the result table will be output.", "The default mode is <code>out</code>, which means that", "the result will be written as a new table to disk or elsewhere,", "as determined by the <code>out</code> and <code>ofmt</code>", "parameters.", "However, there are other possibilities, which correspond", "to uses to which a table can be put other than outputting it,", "such as displaying metadata, calculating statistics,", "or populating a table in an SQL database.", "For some values of this parameter, additional parameters", "(<code>&lt;mode-args&gt;</code>)", "are required to determine the exact behaviour.", "</p>", "<p>Possible values are", modeList, "Use the <code>help=" + this.getName() + "</code> flag", "or see <ref id=\"outModes\"/> for more information.", "</p>"});
    }

    @Override
    public String getExtraUsage(TableEnvironment env) {
        String[] names = this.getObjectFactory().getNickNames();
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("   Available modes, with associated arguments:\n");
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            try {
                sbuf.append(this.getModeUsage(names[i], 6));
                continue;
            }
            catch (LoadException e) {
                if (!env.isDebug()) continue;
                sbuf.append("    ( ").append(this.getName()).append('=').append(name).append(" - not available: ").append((Object)e).append(" )").append('\n');
            }
        }
        sbuf.append('\n').append(new OutputFormatParameter("ofmt").getExtraUsage(env));
        return sbuf.toString();
    }

    public String getModeUsage(String modeName, int indent) throws LoadException {
        ProcessingMode mode = (ProcessingMode)this.getObjectFactory().createObject(modeName);
        ArrayList<String> wordList = new ArrayList<String>();
        wordList.add(this.getName() + "=" + modeName);
        Parameter<?>[] params = mode.getAssociatedParameters();
        for (int i = 0; i < params.length; ++i) {
            Parameter<?> param = params[i];
            wordList.add(param.getName() + "=" + param.getUsage());
        }
        return Formatter.formatWords(wordList, indent);
    }

    @Override
    public TableConsumer consumerValue(Environment env) throws TaskException {
        ProcessingMode mode = (ProcessingMode)this.objectValue(env);
        return mode == null ? null : mode.createConsumer(env);
    }

    @Override
    public void setValueFromConsumer(Environment env, final TableConsumer consumer) throws TaskException {
        this.setValueFromObject(env, new ProcessingMode(){

            @Override
            public TableConsumer createConsumer(Environment env) {
                return consumer;
            }

            @Override
            public Parameter<?>[] getAssociatedParameters() {
                return new Parameter[0];
            }

            @Override
            public String getDescription() {
                return "";
            }

            public String toString() {
                return consumer.toString();
            }
        });
    }
}

