/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import uk.ac.starlink.ttools.cone.ServiceFindMode;

public class UserFindMode {
    private final String name_;
    private final String summary_;
    private final ServiceFindMode serviceMode_;
    private final boolean oneToOne_;
    public static final UserFindMode ALL = new UserFindMode("all", "All matches", ServiceFindMode.ALL, false);
    public static final UserFindMode BEST = new UserFindMode("best", "Matched rows, best remote row for each input row", ServiceFindMode.BEST, false);
    public static final UserFindMode BEST_REMOTE = new UserFindMode("best-remote", "Matched rows, best input row for each remote row", ServiceFindMode.BEST_REMOTE, false);
    public static final UserFindMode EACH = new UserFindMode("each", "One row per input row, contains best remote match or blank", ServiceFindMode.BEST, true);
    public static final UserFindMode EACH_SCORE = new UserFindMode("each-dist", "One row per input row, column giving distance only for best match", ServiceFindMode.BEST_SCORE, true);
    private static final UserFindMode[] INSTANCES = new UserFindMode[]{ALL, BEST, BEST_REMOTE, EACH, EACH_SCORE};

    private UserFindMode(String name, String summary, ServiceFindMode serviceMode, boolean oneToOne) {
        this.name_ = name;
        this.summary_ = summary;
        this.serviceMode_ = serviceMode;
        this.oneToOne_ = oneToOne;
        if (oneToOne && !serviceMode.supportsOneToOne()) {
            throw new IllegalArgumentException();
        }
    }

    public String getName() {
        return this.name_;
    }

    public String getSummary() {
        return this.summary_;
    }

    public ServiceFindMode getServiceMode() {
        return this.serviceMode_;
    }

    public boolean isOneToOne() {
        return this.oneToOne_;
    }

    public String toString() {
        return this.name_;
    }

    public static UserFindMode[] getInstances() {
        return (UserFindMode[])INSTANCES.clone();
    }
}

