/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.cdf;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.bristol.star.cdf.AttributeEntry;
import uk.ac.bristol.star.cdf.CdfContent;
import uk.ac.bristol.star.cdf.DataType;
import uk.ac.bristol.star.cdf.GlobalAttribute;
import uk.ac.bristol.star.cdf.Shaper;
import uk.ac.bristol.star.cdf.Variable;
import uk.ac.bristol.star.cdf.VariableAttribute;
import uk.ac.starlink.cdf.CdfDomains;
import uk.ac.starlink.cdf.CdfTableProfile;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;

public class CdfStarTable
extends AbstractStarTable {
    private final Variable[] vars_;
    private final VariableReader[] randomVarReaders_;
    private final int ncol_;
    private final long nrow_;
    private final ColumnInfo[] colInfos_;
    private final VariableAttribute blankvalAtt_;
    private static final Logger logger_ = Logger.getLogger(CdfStarTable.class.getName());
    private static final boolean STIL_ROW_MAJOR = false;

    /*
     * WARNING - void declaration
     */
    public CdfStarTable(CdfContent content, CdfTableProfile profile, Variable dependVar) throws IOException {
        void var20_38;
        void var20_36;
        void var20_34;
        ArrayList<Variable> varList;
        VariableAttribute[] vatts = content.getVariableAttributes();
        String[] attNames = (String[])Arrays.stream(vatts).map(VariableAttribute::getName).toArray(String[]::new);
        String descAttName = profile.getDescriptionAttribute(attNames);
        String unitAttName = profile.getUnitAttribute(attNames);
        String blankvalAttName = profile.getBlankValueAttribute(attNames);
        String dependAttName = profile.getDepend0Attribute(attNames);
        VariableAttribute descAtt = null;
        VariableAttribute unitAtt = null;
        VariableAttribute blankvalAtt = null;
        VariableAttribute dependAtt = null;
        for (VariableAttribute variableAttribute : vatts) {
            String vattName = variableAttribute.getName();
            if (vattName == null) continue;
            if (vattName.equals(descAttName)) {
                descAtt = variableAttribute;
                continue;
            }
            if (vattName.equals(unitAttName)) {
                unitAtt = variableAttribute;
                continue;
            }
            if (vattName.equals(blankvalAttName)) {
                blankvalAtt = variableAttribute;
                continue;
            }
            if (!vattName.equals(dependAttName)) continue;
            dependAtt = variableAttribute;
        }
        this.blankvalAtt_ = blankvalAtt;
        ArrayList<VariableAttribute> miscAttList = new ArrayList<VariableAttribute>(Arrays.asList(vatts));
        miscAttList.remove(descAtt);
        miscAttList.remove(unitAtt);
        if (dependVar != null) {
            miscAttList.remove(dependAtt);
        }
        if (dependVar == null || dependAtt == null) {
            varList = new ArrayList<Variable>(Arrays.asList(content.getVariables()));
        } else {
            String dependVarName = dependVar.getName();
            varList = new ArrayList();
            varList.add(dependVar);
            for (Variable variable : content.getVariables()) {
                if (!dependVarName.equals(CdfStarTable.getStringEntry(dependAtt, variable)) && variable.getRecordVariance()) continue;
                varList.add(variable);
            }
        }
        ArrayList<Variable> paramVarList = new ArrayList<Variable>();
        if (profile.invariantVariablesToParameters()) {
            Iterator iterator = varList.iterator();
            while (iterator.hasNext()) {
                Variable var = (Variable)iterator.next();
                if (var.getRecordVariance()) continue;
                iterator.remove();
                paramVarList.add(var);
            }
        }
        Variable[] variableArray = paramVarList.toArray(new Variable[0]);
        this.vars_ = varList.toArray(new Variable[0]);
        this.ncol_ = this.vars_.length;
        long nrow = -1L;
        for (Variable var : this.vars_) {
            if (!var.getRecordVariance()) continue;
            long nr = var.getRecordCount();
            if (nrow < 0L) {
                nrow = nr;
                continue;
            }
            if (nr == nrow) continue;
            logger_.warning("Inconsistent row counts; probably trouble: " + nr + " != " + nrow + " at column " + var.getName());
        }
        this.nrow_ = nrow;
        this.randomVarReaders_ = new VariableReader[this.ncol_];
        boolean bl = false;
        while (var20_34 < this.ncol_) {
            this.randomVarReaders_[var20_34] = CdfStarTable.createVariableReader(this.vars_[var20_34], this.blankvalAtt_);
            ++var20_34;
        }
        this.colInfos_ = new ColumnInfo[this.ncol_];
        boolean bl2 = false;
        while (var20_36 < this.ncol_) {
            Variable var = this.vars_[var20_36];
            LinkedHashMap<String, Object> miscAttMap = new LinkedHashMap<String, Object>();
            for (VariableAttribute vatt : miscAttList) {
                AttributeEntry entry;
                if (vatt == this.blankvalAtt_ && this.randomVarReaders_[var20_36].usesBlankValue() || (entry = vatt.getEntry(var)) == null) continue;
                miscAttMap.put(vatt.getName(), entry.getShapedValue());
            }
            this.colInfos_[var20_36] = CdfStarTable.createColumnInfo(var, CdfStarTable.getStringEntry(descAtt, var), CdfStarTable.getStringEntry(unitAtt, var), miscAttMap);
            ++var20_36;
        }
        boolean bl3 = false;
        while (var20_38 < variableArray.length) {
            Variable pvar = variableArray[var20_38];
            ValueInfo info = CdfStarTable.createValueInfo(pvar, CdfStarTable.getStringEntry(descAtt, pvar), CdfStarTable.getStringEntry(unitAtt, pvar));
            VariableReader rdr = CdfStarTable.createVariableReader(pvar, this.blankvalAtt_);
            Object value = rdr.readShapedRecord(0, rdr.createWorkspace());
            this.setParameter(new DescribedValue(info, value));
            ++var20_38;
        }
        GlobalAttribute[] globalAttributeArray = content.getGlobalAttributes();
        for (int iga = 0; iga < globalAttributeArray.length; ++iga) {
            DescribedValue dval = CdfStarTable.createParameter(globalAttributeArray[iga]);
            if (dval == null) continue;
            this.setParameter(dval);
        }
    }

    public int getColumnCount() {
        return this.ncol_;
    }

    public long getRowCount() {
        return this.nrow_;
    }

    public ColumnInfo getColumnInfo(int icol) {
        return this.colInfos_[icol];
    }

    public boolean isRandom() {
        return true;
    }

    public Object getCell(long irow, int icol) throws IOException {
        VariableReader rdr = this.randomVarReaders_[icol];
        return rdr.readShapedRecord(CdfStarTable.toRecordIndex(irow), rdr.createWorkspace());
    }

    public RowSequence getRowSequence() throws IOException {
        final VariableReader[] vrdrs = new VariableReader[this.ncol_];
        final Object[] vworks = new Object[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            vrdrs[icol] = CdfStarTable.createVariableReader(this.vars_[icol], this.blankvalAtt_);
            vworks[icol] = vrdrs[icol].createWorkspace();
        }
        return new RowSequence(){
            private long irow = -1L;

            public boolean next() {
                return ++this.irow < CdfStarTable.this.nrow_;
            }

            public Object getCell(int icol) throws IOException {
                return vrdrs[icol].readShapedRecord(CdfStarTable.toRecordIndex(this.irow), vworks[icol]);
            }

            public Object[] getRow() throws IOException {
                Object[] row = new Object[CdfStarTable.this.ncol_];
                for (int icol = 0; icol < CdfStarTable.this.ncol_; ++icol) {
                    row[icol] = this.getCell(icol);
                }
                return row;
            }

            public void close() {
            }
        };
    }

    public RowAccess getRowAccess() throws IOException {
        final VariableReader[] vrdrs = new VariableReader[this.ncol_];
        final Object[] vworks = new Object[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            vrdrs[icol] = CdfStarTable.createVariableReader(this.vars_[icol], this.blankvalAtt_);
            vworks[icol] = vrdrs[icol].createWorkspace();
        }
        final Object[] row = new Object[this.ncol_];
        return new RowAccess(){
            private long irow = -1L;

            public void setRowIndex(long ir) {
                this.irow = ir;
            }

            public Object getCell(int icol) throws IOException {
                return vrdrs[icol].readShapedRecord(CdfStarTable.toRecordIndex(this.irow), vworks[icol]);
            }

            public Object[] getRow() throws IOException {
                for (int icol = 0; icol < CdfStarTable.this.ncol_; ++icol) {
                    row[icol] = this.getCell(icol);
                }
                return row;
            }

            public void close() {
            }
        };
    }

    private static DescribedValue createParameter(GlobalAttribute gatt) {
        Object array;
        DefaultValueInfo info;
        String name = gatt.getName();
        ArrayList<AttributeEntry> entryList = new ArrayList<AttributeEntry>();
        for (AttributeEntry ent : gatt.getEntries()) {
            if (ent == null) continue;
            entryList.add(ent);
        }
        AttributeEntry[] entries = entryList.toArray(new AttributeEntry[0]);
        int nent = entries.length;
        if (nent == 0) {
            return null;
        }
        if (nent == 1) {
            Object value = entries[0].getShapedValue();
            if (value == null) {
                return null;
            }
            info = new DefaultValueInfo(name, value.getClass(), null);
            return new DescribedValue((ValueInfo)info, value);
        }
        try {
            array = CdfStarTable.getValueArray(entries);
        }
        catch (RuntimeException e) {
            logger_.log(Level.WARNING, "Omitting complicated global attribute " + gatt.getName(), e);
            return null;
        }
        info = new DefaultValueInfo(name, array.getClass(), null);
        info.setShape(new int[]{Array.getLength(array)});
        return new DescribedValue((ValueInfo)info, array);
    }

    private static Object getValueArray(AttributeEntry[] entries) {
        int nent = entries.length;
        assert (nent > 1);
        DataType dtype = entries[0].getDataType();
        boolean allScalar = true;
        for (int i = 1; i < nent; ++i) {
            AttributeEntry entry = entries[i];
            if (entry.getDataType() != dtype) {
                dtype = null;
            }
            allScalar = allScalar && entry.getItemCount() == 1;
        }
        if (dtype == null || !allScalar) {
            Object[] array = new Object[nent];
            for (int i = 0; i < nent; ++i) {
                array[i] = entries[i].getShapedValue();
            }
            return array;
        }
        Class<?> elClass = dtype.getArrayElementClass();
        Object array = Array.newInstance(elClass, nent);
        for (int i = 0; i < nent; ++i) {
            Array.set(array, i, entries[i].getShapedValue());
        }
        return array;
    }

    private static ValueInfo createValueInfo(Variable var, String descrip, String units) {
        DomainMapper[] domainMapperArray;
        int[] shape;
        String name = var.getName();
        Class<?> clazz = var.getShaper().getShapeClass();
        DataType dtype = var.getDataType();
        int grpSize = dtype.getGroupSize();
        if (grpSize == 1) {
            shape = clazz.getComponentType() == null ? null : var.getShaper().getDimSizes();
        } else {
            assert (clazz.getComponentType() != null);
            int[] shDims = var.getShaper().getDimSizes();
            shape = new int[shDims.length + 1];
            shape[0] = grpSize;
            System.arraycopy(shDims, 0, shape, 1, shDims.length);
        }
        DefaultValueInfo info = new DefaultValueInfo(name, clazz, descrip);
        info.setUnitString(units);
        info.setShape(shape);
        DomainMapper mapper = CdfDomains.getMapper(dtype);
        if (mapper == null) {
            domainMapperArray = new DomainMapper[]{};
        } else {
            DomainMapper[] domainMapperArray2 = new DomainMapper[1];
            domainMapperArray = domainMapperArray2;
            domainMapperArray2[0] = mapper;
        }
        info.setDomainMappers(domainMapperArray);
        return info;
    }

    private static ColumnInfo createColumnInfo(Variable var, String descrip, String units, Map<String, Object> attMap) {
        ColumnInfo info = new ColumnInfo(CdfStarTable.createValueInfo(var, descrip, units));
        ArrayList<DescribedValue> auxData = new ArrayList<DescribedValue>();
        for (Map.Entry<String, Object> attEntry : attMap.entrySet()) {
            String auxName = attEntry.getKey();
            Object auxValue = attEntry.getValue();
            if (auxValue == null) continue;
            DefaultValueInfo auxInfo = new DefaultValueInfo(auxName, auxValue.getClass());
            auxData.add(new DescribedValue((ValueInfo)auxInfo, auxValue));
        }
        DataType dtype = var.getDataType();
        if (dtype == DataType.UINT1) {
            assert (dtype.getByteCount() == 1);
            assert (dtype.getScalarClass() == Short.class);
            auxData.add(new DescribedValue(Tables.UBYTE_FLAG_INFO, (Object)Boolean.TRUE));
        }
        info.setAuxData(auxData);
        return info;
    }

    public static String getStringEntry(VariableAttribute att, Variable var) {
        AttributeEntry entry = att == null ? null : att.getEntry(var);
        Object item = entry == null ? null : entry.getShapedValue();
        return item instanceof String ? (String)item : null;
    }

    private static int toRecordIndex(long irow) {
        int irec = (int)irow;
        if ((long)irec != irow) {
            throw new IllegalArgumentException("Out of range: " + irow);
        }
        if (irec < 0) {
            throw new IllegalStateException("No row");
        }
        return irec;
    }

    private static VariableReader createVariableReader(Variable var, VariableAttribute blankvalAtt) {
        AttributeEntry blankvalEntry = blankvalAtt == null ? null : blankvalAtt.getEntry(var);
        final Object blankval = blankvalEntry == null ? null : blankvalEntry.getShapedValue();
        Shaper shaper = var.getShaper();
        if (blankval == null) {
            return new VariableReader(var, false);
        }
        if (shaper.getRawItemCount() == 1) {
            return new VariableReader(var, true){

                @Override
                public Object readShapedRecord(int irec, Object work) throws IOException {
                    Object obj = super.readShapedRecord(irec, work);
                    return blankval.equals(obj) ? null : obj;
                }
            };
        }
        if (double[].class.equals(shaper.getShapeClass()) && blankval instanceof Number && !Double.isNaN(((Number)blankval).doubleValue())) {
            final double dBlank = ((Number)blankval).doubleValue();
            return new VariableReader(var, true){

                @Override
                public Object readShapedRecord(int irec, Object work) throws IOException {
                    Object obj = super.readShapedRecord(irec, work);
                    if (obj instanceof double[]) {
                        double[] darr = (double[])obj;
                        for (int i = 0; i < darr.length; ++i) {
                            if (darr[i] != dBlank) continue;
                            darr[i] = Double.NaN;
                        }
                    } else assert (false);
                    return obj;
                }
            };
        }
        if (float[].class.equals(shaper.getShapeClass()) && blankval instanceof Number && !Float.isNaN(((Number)blankval).floatValue())) {
            final float fBlank = ((Number)blankval).floatValue();
            return new VariableReader(var, true){

                @Override
                public Object readShapedRecord(int irec, Object work) throws IOException {
                    Object obj = super.readShapedRecord(irec, work);
                    if (obj instanceof float[]) {
                        float[] farr = (float[])obj;
                        for (int i = 0; i < farr.length; ++i) {
                            if (farr[i] != fBlank) continue;
                            farr[i] = Float.NaN;
                        }
                    } else assert (false);
                    return obj;
                }
            };
        }
        logger_.info("Magic value " + blankvalAtt.getName() + "=" + String.valueOf(blankval) + " ignored for non-float array CDF variable " + var.getName());
        return new VariableReader(var, false);
    }

    private static class VariableReader {
        private final Variable var_;
        private final boolean usesBlankValue_;

        VariableReader(Variable var, boolean usesBlankValue) {
            this.var_ = var;
            this.usesBlankValue_ = usesBlankValue;
        }

        Object createWorkspace() {
            return this.var_.createRawValueArray();
        }

        Object readShapedRecord(int irec, Object work) throws IOException {
            return this.var_.readShapedRecord(irec, false, work);
        }

        boolean usesBlankValue() {
            return this.usesBlankValue_;
        }
    }
}

