/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import uk.ac.starlink.auth.AuthManager;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.vo.DaliExample;
import uk.ac.starlink.vo.Tree;

public class DaliExampleReader {
    private final XPath xpath_ = XPathFactory.newInstance().newXPath();
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public List<Tree<DaliExample>> readExamples(URL url) throws IOException {
        Document doc;
        InputStream in = AuthManager.getInstance().openStream(url);
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            db.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    logger_.config("Ignoring external entity \"" + publicId + "\", \"" + systemId + "\" - treat as empty");
                    return new InputSource(new StringReader(""));
                }
            });
            doc = db.parse(in);
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException("Parser config").initCause(e);
        }
        catch (SAXException e) {
            throw (IOException)new IOException("XML error in examples document at " + url + ": " + e).initCause(e);
        }
        String exPath = "//*[@typeof='example']|//*[@property='continuation']";
        ArrayList<Tree<DaliExample>> list = new ArrayList<Tree<DaliExample>>();
        int nLeaf = 0;
        int nBranch = 0;
        for (Element el : this.findElements(doc.getDocumentElement(), exPath)) {
            List contList;
            if ("example".equals(el.getAttribute("typeof"))) {
                DaliExample daliEx = this.createExample(el, url);
                list.add(new Tree.Leaf<DaliExample>(daliEx));
                ++nLeaf;
                continue;
            }
            if (!"continuation".equals(el.getAttribute("property"))) continue;
            String href = el.getAttribute("href");
            if (href == null || href.trim().length() == 0) {
                contList = null;
                logger_.warning("No href attribute for examples continuation in " + url);
            } else {
                try {
                    contList = this.readExamples(url.toURI().resolve(href).toURL());
                }
                catch (IOException | URISyntaxException e) {
                    contList = null;
                    logger_.log(Level.WARNING, "Failed to read examples continuation at " + href, e);
                }
            }
            if (contList == null || contList.size() <= 0) continue;
            String label = this.getElementText(el);
            if (label == null || label.trim().length() == 0) {
                label = "Continuation";
            }
            if (label != null && label.length() > 50) {
                label = label.substring(0, 40) + "...";
            }
            list.add(new Tree.Branch(contList, label));
            ++nBranch;
        }
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("Read examples document from ").append(url).append(": ").append(nLeaf).append(" examples");
        if (nBranch > 0) {
            sbuf.append(", ").append(nBranch).append(" continuations");
        }
        logger_.info(sbuf.toString());
        return list;
    }

    public DaliExample createExample(final Element exEl, URL docUrl) throws IOException {
        URL exUrl;
        final String idAtt = exEl.getAttribute("id");
        String resourceAtt = exEl.getAttribute("resource");
        try {
            exUrl = docUrl.toURI().resolve("#" + idAtt).toURL();
        }
        catch (URISyntaxException e) {
            throw (MalformedURLException)new MalformedURLException().initCause(e);
        }
        String name0 = this.getPropertyText(exEl, "name");
        final String name = name0 == null ? null : name0.trim().replaceAll("\\s+", " ");
        final String capability = this.getPropertyText(exEl, "capability");
        String paramPath = ".//*[@property='generic-parameter' and @typeof='keyval']";
        final LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        for (Element paramEl : this.findElements(exEl, paramPath)) {
            String key = this.getPropertyText(paramEl, "key");
            String value = this.getPropertyText(paramEl, "value");
            paramMap.put(key, value);
        }
        final LinkedHashMap<String, String> propMap = new LinkedHashMap<String, String>();
        String propPath = ".//*[@property and not(@property='generic-parameter') and not(../@property='generic-parameter')]";
        for (Element propEl : this.findElements(exEl, propPath)) {
            String key = propEl.getAttribute("property");
            String value = this.getElementText(propEl);
            propMap.put(key, value);
        }
        return new DaliExample(){

            @Override
            public URL getUrl() {
                return exUrl;
            }

            @Override
            public Element getElement() {
                return exEl;
            }

            @Override
            public String getId() {
                return idAtt;
            }

            @Override
            public String getCapability() {
                return capability;
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Map<String, String> getGenericParameters() {
                return Collections.unmodifiableMap(paramMap);
            }

            @Override
            public Map<String, String> getProperties() {
                return Collections.unmodifiableMap(propMap);
            }
        };
    }

    private Element[] findElements(Element contextEl, String findPath) throws IOException {
        NodeList nl;
        try {
            nl = (NodeList)this.xpath_.evaluate(findPath, contextEl, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            logger_.log(Level.WARNING, "Bad XPath expression: " + findPath, e);
            return new Element[0];
        }
        int nn = nl.getLength();
        ArrayList<Element> elList = new ArrayList<Element>(nn);
        for (int i = 0; i < nn; ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            elList.add((Element)node);
        }
        return elList.toArray(new Element[0]);
    }

    private String getPropertyText(Element contextEl, String propName) throws IOException {
        Element propEl;
        String propPath = ".//*[@property='" + propName + "']";
        try {
            propEl = (Element)this.xpath_.evaluate(propPath, contextEl, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            logger_.log(Level.WARNING, "Bad XPath expression: " + propPath, e);
            return null;
        }
        return this.getElementText(propEl);
    }

    private String getElementText(Element el) {
        NodeList nl;
        if (el == null) {
            return null;
        }
        if (el.hasAttribute("content")) {
            return el.getAttribute("content");
        }
        String txtPath = ".//text()";
        try {
            nl = (NodeList)this.xpath_.evaluate(".//text()", el, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            logger_.log(Level.WARNING, "Bad XPath expression: .//text()", e);
            return DOMUtils.getTextContent((Element)el);
        }
        StringBuffer sbuf = new StringBuffer();
        int nn = nl.getLength();
        for (int i = 0; i < nn; ++i) {
            sbuf.append(nl.item(i).getTextContent());
        }
        return sbuf.toString();
    }

    public static void main(String[] args) throws IOException {
        for (Tree<DaliExample> tree : new DaliExampleReader().readExamples(URLUtils.newURL((String)args[0]))) {
            DaliExampleReader.writeTree(0, tree);
        }
    }

    private static void writeTree(int level, Tree<DaliExample> tree) {
        if (tree.isLeaf()) {
            DaliExample ex = tree.asLeaf().getItem();
            DaliExampleReader.output(level, ex.getId() + ": " + ex.getName());
            DaliExampleReader.output(level + 1, "generic-parameters:");
            for (Map.Entry<String, String> entry : ex.getGenericParameters().entrySet()) {
                DaliExampleReader.output(level + 2, entry.getKey() + " -> " + entry.getValue());
            }
            DaliExampleReader.output(level + 1, "properties:");
            for (Map.Entry<String, String> entry : ex.getProperties().entrySet()) {
                DaliExampleReader.output(level + 2, entry.getKey() + " -> " + entry.getValue());
            }
            DaliExampleReader.output(0, "");
        } else {
            Tree.Branch<DaliExample> branch = tree.asBranch();
            String label = branch.getLabel();
            if (label != null && label.trim().length() > 0) {
                DaliExampleReader.output(level + 1, label + ":");
                DaliExampleReader.output(level + 1, Stream.generate(() -> "-").limit(label.length() + 1).collect(Collectors.joining()));
            }
            for (Tree<DaliExample> child : branch.getChildren()) {
                DaliExampleReader.writeTree(level + 1, child);
            }
        }
    }

    private static void output(int level, String txt) {
        String prefix = Stream.generate(() -> "  ").limit(level).collect(Collectors.joining());
        System.out.println(prefix + txt.replaceAll("\n", "\n" + prefix + "  "));
    }
}

