/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uk.ac.starlink.auth.AuthManager;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.vo.UwsJobInfo;

class JobSaxHandler
extends DefaultHandler {
    private final StringBuffer txtbuf_ = new StringBuffer();
    private List<UwsJobInfo> jobList_;
    private List<UwsJobInfo.Parameter> parameterList_;
    private List<UwsJobInfo.Result> resultList_;
    private JobImpl job_;
    private ParameterImpl parameter_;
    private ResultImpl result_;
    private ErrorImpl error_;
    private UwsJobInfo[] jobs_;

    @Override
    public void startDocument() {
        this.jobList_ = new ArrayList<UwsJobInfo>();
    }

    @Override
    public void endDocument() {
        this.jobs_ = this.jobList_.toArray(new JobImpl[0]);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) {
        this.txtbuf_.setLength(0);
        String tname = this.getTagName(uri, localName, qName);
        if ("job".equals(tname)) {
            String version = atts.getValue("version");
            this.job_ = new JobImpl();
            this.job_.version_ = version;
        } else if (this.job_ != null) {
            if ("parameters".equals(tname)) {
                this.parameterList_ = new ArrayList<UwsJobInfo.Parameter>();
            } else if ("results".equals(tname)) {
                this.resultList_ = new ArrayList<UwsJobInfo.Result>();
            } else if ("errorSummary".equals(tname)) {
                this.error_ = new ErrorImpl();
                this.error_.hasDetail_ = JobSaxHandler.booleanValue(atts.getValue("hasDetail"));
                this.error_.isFatal_ = !"transient".equals(atts.getValue("type"));
            } else if ("parameter".equals(tname) && this.parameterList_ != null) {
                this.parameter_ = new ParameterImpl();
                this.parameter_.id_ = atts.getValue("id");
                this.parameter_.isByReference_ = JobSaxHandler.booleanValue(atts.getValue("byReference"));
                this.parameter_.isPost_ = JobSaxHandler.booleanValue(atts.getValue("isPost"));
            } else if ("result".equals(tname) && this.resultList_ != null) {
                this.result_ = new ResultImpl();
                this.result_.id_ = atts.getValue("id");
                this.result_.href_ = atts.getValue("xlink:href");
                this.result_.type_ = atts.getValue("xlink:type");
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        String txt = this.txtbuf_.toString();
        this.txtbuf_.setLength(0);
        String tname = this.getTagName(uri, localName, qName);
        if ("job".equals(tname)) {
            this.jobList_.add(this.job_);
            this.job_ = null;
        } else if (this.job_ != null) {
            if ("jobId".equals(tname)) {
                this.job_.jobId_ = txt;
            } else if ("runId".equals(tname)) {
                this.job_.runId_ = txt;
            } else if ("ownerId".equals(tname)) {
                this.job_.ownerId_ = txt;
            } else if ("phase".equals(tname)) {
                this.job_.phase_ = txt;
            } else if ("quote".equals(tname)) {
                this.job_.quote_ = txt;
            } else if ("startTime".equals(tname)) {
                this.job_.startTime_ = txt;
            } else if ("endTime".equals(tname)) {
                this.job_.endTime_ = txt;
            } else if ("executionDuration".equals(tname)) {
                this.job_.executionDuration_ = txt;
            } else if ("destruction".equals(tname)) {
                this.job_.destruction_ = txt;
            } else if ("parameters".equals(tname)) {
                this.job_.parameters_ = this.parameterList_.toArray(new UwsJobInfo.Parameter[0]);
            } else if ("results".equals(tname)) {
                this.job_.results_ = this.resultList_.toArray(new UwsJobInfo.Result[0]);
            } else if ("errorSummary".equals(tname)) {
                this.job_.error_ = this.error_;
                this.error_ = null;
            } else if ("parameter".equals(tname) && this.parameterList_ != null) {
                this.parameter_.value_ = txt;
                this.parameterList_.add(this.parameter_);
                this.parameter_ = null;
            } else if ("result".equals(tname) && this.resultList_ != null) {
                this.result_.value_ = txt;
                this.resultList_.add(this.result_);
                this.result_ = null;
            } else if ("message".equals(tname) && this.error_ != null) {
                this.error_.message_ = txt;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.txtbuf_.append(ch, start, length);
    }

    private String getTagName(String uri, String localName, String qName) {
        return localName != null && localName.length() > 0 ? localName : qName.replaceFirst(".*:", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UwsJobInfo[] readJobInfos(URL url) throws IOException, SAXException {
        HttpURLConnection hconn;
        int code;
        SAXParser parser;
        SAXParserFactory spfact = SAXParserFactory.newInstance();
        try {
            spfact.setNamespaceAware(false);
            spfact.setValidating(false);
            parser = spfact.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException("SAX trouble").initCause(e);
        }
        JobSaxHandler jHandler = new JobSaxHandler();
        URLConnection conn = AuthManager.getInstance().connect(url);
        if (conn instanceof HttpURLConnection && (code = (hconn = (HttpURLConnection)conn).getResponseCode()) != 200) {
            throw new IOException("Job info access failure (" + code + " " + hconn.getResponseMessage() + ")");
        }
        try (BufferedInputStream in = new BufferedInputStream(conn.getInputStream());){
            parser.parse((InputStream)in, (DefaultHandler)jHandler);
            UwsJobInfo[] uwsJobInfoArray = jHandler.jobs_;
            return uwsJobInfoArray;
        }
    }

    private static boolean booleanValue(String txt) {
        return "1".equals(txt) || "true".equals(txt);
    }

    public static void main(String[] args) throws IOException, SAXException {
        UwsJobInfo[] infos = JobSaxHandler.readJobInfos(URLUtils.newURL((String)args[0]));
        UwsJobInfo info = infos[0];
        System.out.println("job id: " + info.getJobId());
        System.out.println("start time: " + info.getStartTime());
    }

    private static class ErrorImpl
    implements UwsJobInfo.Error {
        boolean isFatal_;
        boolean hasDetail_;
        String message_;

        private ErrorImpl() {
        }

        @Override
        public boolean isFatal() {
            return this.isFatal_;
        }

        @Override
        public boolean hasDetail() {
            return this.hasDetail_;
        }

        @Override
        public String getMessage() {
            return this.message_;
        }
    }

    private static class ResultImpl
    implements UwsJobInfo.Result {
        String id_;
        String value_;
        String href_;
        String type_;

        private ResultImpl() {
        }

        @Override
        public String getId() {
            return this.id_;
        }

        @Override
        public String getValue() {
            return this.value_;
        }

        @Override
        public String getHref() {
            return this.href_;
        }

        @Override
        public String getType() {
            return this.type_;
        }
    }

    private static class ParameterImpl
    implements UwsJobInfo.Parameter {
        String id_;
        String value_;
        boolean isByReference_;
        boolean isPost_;

        private ParameterImpl() {
        }

        @Override
        public String getId() {
            return this.id_;
        }

        @Override
        public String getValue() {
            return this.value_;
        }

        @Override
        public boolean isByReference() {
            return this.isByReference_;
        }

        @Override
        public boolean isPost() {
            return this.isPost_;
        }
    }

    private static class JobImpl
    implements UwsJobInfo {
        String version_;
        String jobId_;
        String runId_;
        String ownerId_;
        String phase_;
        String quote_;
        String startTime_;
        String endTime_;
        String executionDuration_;
        String destruction_;
        UwsJobInfo.Parameter[] parameters_;
        UwsJobInfo.Result[] results_;
        UwsJobInfo.Error error_;

        private JobImpl() {
        }

        @Override
        public String getUwsVersion() {
            return this.version_;
        }

        @Override
        public String getJobId() {
            return this.jobId_;
        }

        @Override
        public String getRunId() {
            return this.runId_;
        }

        @Override
        public String getOwnerId() {
            return this.ownerId_;
        }

        @Override
        public String getPhase() {
            return this.phase_;
        }

        @Override
        public String getQuote() {
            return this.quote_;
        }

        @Override
        public String getStartTime() {
            return this.startTime_;
        }

        @Override
        public String getEndTime() {
            return this.endTime_;
        }

        @Override
        public String getExecutionDuration() {
            return this.executionDuration_;
        }

        @Override
        public String getDestruction() {
            return this.destruction_;
        }

        @Override
        public UwsJobInfo.Parameter[] getParameters() {
            return this.parameters_;
        }

        @Override
        public UwsJobInfo.Result[] getResults() {
            return this.results_;
        }

        @Override
        public UwsJobInfo.Error getError() {
            return this.error_;
        }
    }
}

