/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.util.ArrayList;
import net.ivoa.registry.search.Metadata;
import net.ivoa.registry.search.VOResource;
import uk.ac.starlink.vo.RegCapabilityInterface;
import uk.ac.starlink.vo.RegResource;

public class VORegResource
implements RegResource {
    private final String shortName_;
    private final String title_;
    private final String identifier_;
    private final String publisher_;
    private final String contact_;
    private final String[] subjects_;
    private final String referenceUrl_;
    private final RegCapabilityInterface[] capabilities_;

    public VORegResource(VOResource resource) {
        this.shortName_ = resource.getParameter("shortName");
        this.title_ = resource.getParameter("title");
        this.identifier_ = resource.getParameter("identifier");
        this.publisher_ = resource.getParameter("curation/publisher");
        String contactName = resource.getParameter("curation/contact/name");
        String contactEmail = resource.getParameter("curation/contact/email");
        this.contact_ = contactEmail != null && contactEmail.trim().length() > 0 && contactName != null && contactName.trim().length() > 0 ? contactName + " <" + contactEmail + ">" : (contactEmail != null && contactEmail.trim().length() > 0 ? contactEmail : (contactName != null && contactName.trim().length() > 0 ? contactName : null));
        this.subjects_ = resource.getParameters("content/subject");
        this.referenceUrl_ = resource.getParameter("content/referenceURL");
        Metadata[] capBlocks = resource.getBlocks("capability");
        ArrayList<1> capList = new ArrayList<1>();
        for (int ic = 0; ic < capBlocks.length; ++ic) {
            Metadata capBlock = capBlocks[ic];
            final String standardId = capBlock.getParameter("@standardID");
            final String xsiType = capBlock.getParameter("@xsi:type");
            final String description = capBlock.getParameter("description");
            Metadata[] intfs = capBlock.getBlocks("interface");
            for (int ii = 0; ii < intfs.length; ++ii) {
                Metadata intf = intfs[ii];
                final String accessUrl = intf.getParameter("accessURL");
                final String version = intf.getParameter("@version");
                String role = intf.getParameter("@role");
                RegCapabilityInterface rci = new RegCapabilityInterface(){

                    @Override
                    public String getAccessUrl() {
                        return accessUrl;
                    }

                    @Override
                    public String getStandardId() {
                        return standardId;
                    }

                    @Override
                    public String getXsiType() {
                        return xsiType;
                    }

                    @Override
                    public String getDescription() {
                        return description;
                    }

                    @Override
                    public String getVersion() {
                        return version;
                    }
                };
                capList.add("std".equals(role) ? 0 : capList.size(), rci);
            }
        }
        this.capabilities_ = capList.toArray(new RegCapabilityInterface[0]);
    }

    @Override
    public String getShortName() {
        return this.shortName_;
    }

    @Override
    public String getTitle() {
        return this.title_;
    }

    @Override
    public String getIdentifier() {
        return this.identifier_;
    }

    @Override
    public String getPublisher() {
        return this.publisher_;
    }

    @Override
    public String getContact() {
        return this.contact_;
    }

    @Override
    public String[] getSubjects() {
        return this.subjects_;
    }

    @Override
    public String getReferenceUrl() {
        return this.referenceUrl_;
    }

    @Override
    public RegCapabilityInterface[] getCapabilities() {
        return this.capabilities_;
    }
}

