/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.CharConversionException;
import java.io.IOException;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.util.StarEntityResolver;
import uk.ac.starlink.votable.Namespacing;
import uk.ac.starlink.votable.TableContentHandler;
import uk.ac.starlink.votable.TableHandler;
import uk.ac.starlink.votable.VOElementFactory;

class TableStreamer
extends TableContentHandler
implements TableHandler {
    private int skipTables_;
    private final TableSink sink_;
    private final Namespacing namespacing_;
    private boolean isVotable_;
    private static Logger logger_ = Logger.getLogger("uk.ac.starlink.votable");

    public TableStreamer(TableSink sink, int itable, boolean strict) {
        super(strict);
        this.setTableHandler(null);
        this.setReadHrefTables(false);
        this.sink_ = sink;
        this.skipTables_ = itable;
        this.namespacing_ = Namespacing.getInstance();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        super.startElement(namespaceURI, localName, qName, atts);
        String tagName = this.namespacing_.getVOTagName(namespaceURI, localName, qName);
        if ("VOTABLE".equals(tagName)) {
            this.isVotable_ = true;
        }
        if ("TABLE".equals(tagName) && this.skipTables_-- == 0) {
            this.setReadHrefTables(true);
            this.setTableHandler(this);
        }
    }

    @Override
    public void startTable(StarTable meta) throws SAXException {
        try {
            this.sink_.acceptMetadata(meta);
        }
        catch (IOException e) {
            throw (SAXException)new SAXParseException(e.getMessage(), this.getLocator(), e).initCause(e);
        }
    }

    @Override
    public void rowData(Object[] row) throws SAXException {
        try {
            this.sink_.acceptRow(row);
        }
        catch (IOException e) {
            throw (SAXException)new SAXParseException(e.getMessage(), this.getLocator(), e).initCause(e);
        }
    }

    @Override
    public void endTable() throws SAXException {
        try {
            this.sink_.endRows();
        }
        catch (IOException e) {
            throw (SAXException)new SAXParseException(e.getMessage(), this.getLocator(), e).initCause(e);
        }
        throw new SuccessfulCompletionException();
    }

    public static void streamStarTable(InputSource saxsrc, TableSink sink, int itable, boolean strict) throws IOException, SAXException {
        XMLReader parser;
        TableStreamer streamer = new TableStreamer(sink, itable, strict);
        try {
            SAXParserFactory spfact = SAXParserFactory.newInstance();
            spfact.setValidating(false);
            streamer.namespacing_.configureSAXParserFactory(spfact);
            parser = spfact.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException e) {
            throw (SAXException)new SAXException(e.getMessage(), e).initCause(e);
        }
        parser.setContentHandler(streamer);
        parser.setEntityResolver(StarEntityResolver.getInstance());
        parser.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException e) {
                logger_.warning(e.toString());
            }

            @Override
            public void warning(SAXParseException e) {
                logger_.warning(e.toString());
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                throw e;
            }
        });
        try {
            parser.parse(saxsrc);
        }
        catch (SuccessfulCompletionException e) {
            return;
        }
        catch (CharConversionException e) {
            if (streamer.isVotable_) {
                throw e;
            }
            throw new TableFormatException("Bad XML characters", e);
        }
        catch (SAXException e) {
            e = VOElementFactory.fixStackTrace(e);
            if (streamer.isVotable_) {
                throw e;
            }
            throw new TableFormatException(e);
        }
        throw streamer.isVotable_ ? new IOException("No TABLE element found") : new TableFormatException("No VOTABLE element");
    }

    private static class SuccessfulCompletionException
    extends SAXException {
        SuccessfulCompletionException() {
            super("Table extraction complete");
        }
    }
}

