/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.parquet;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import uk.ac.starlink.parquet.ParquetIO;
import uk.ac.starlink.parquet.ParquetStarTable;
import uk.ac.starlink.parquet.ParquetTableBuilder;
import uk.ac.starlink.parquet.ParquetUtil;
import uk.ac.starlink.table.BeanStarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.LogUtils;

public class ParquetDump {
    private final ParquetStarTable starTable_;
    private final ParquetFileReader pfr_;
    private final FileMetaData fileMeta_;
    private final ParquetMetadata footer_;
    private final MessageType schema_;

    public ParquetDump(ParquetStarTable starTable) throws IOException {
        this.starTable_ = starTable;
        this.pfr_ = starTable.getParquetFileReader();
        this.fileMeta_ = this.pfr_.getFileMetaData();
        this.footer_ = this.pfr_.getFooter();
        this.schema_ = this.fileMeta_.getSchema();
    }

    public ParquetStarTable getTable() {
        return this.starTable_;
    }

    public String formatSchema() {
        StringBuilder sb = new StringBuilder();
        String schemaIndent = "   ";
        this.schema_.writeToStringBuilder(sb, schemaIndent);
        return sb.toString();
    }

    public String formatKeyValuesCompact(int maxChar) {
        StringBuffer sbuf = new StringBuffer();
        for (Map.Entry<String, String> entry : this.starTable_.getExtraMetadataMap().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            sbuf.append(key).append(": ");
            if (value.length() + key.length() < maxChar && value.indexOf(10) < 0) {
                sbuf.append(value);
            } else {
                sbuf.append("<" + value.length() + " chars>");
            }
            sbuf.append('\n');
        }
        return sbuf.toString();
    }

    public String formatKeyValuesFull() {
        StringBuffer sbuf = new StringBuffer();
        String pre = "\n    ";
        for (Map.Entry<String, String> entry : this.starTable_.getExtraMetadataMap().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            sbuf.append(key).append(":").append(pre).append(value.replaceAll("\n", pre)).append("\n");
        }
        return sbuf.toString();
    }

    public String formatBlocks() {
        BeanStarTable blockTable;
        StringBuffer sbuf = new StringBuffer();
        try {
            blockTable = new BeanStarTable(BlockMetaData.class);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        blockTable.setColumnProperties(new String[]{"ordinal", "rowIndexOffset", "rowCount", "compressedSize", "totalByteSize"});
        blockTable.setData(this.footer_.getBlocks().toArray(new BlockMetaData[0]));
        return Tables.tableToString(blockTable, "ascii");
    }

    public String formatColumnChunks() {
        StringBuffer sbuf = new StringBuffer();
        int ib = 0;
        for (BlockMetaData block : this.footer_.getBlocks()) {
            BeanStarTable chunkTable;
            if (ib > 0) {
                sbuf.append("\n");
            }
            sbuf.append("Block ").append(block.getOrdinal()).append(" (").append(block.getRowCount()).append(" rows)").append(":\n").append("------------------------\n");
            try {
                chunkTable = new BeanStarTable(ChunkMeta.class);
            }
            catch (IntrospectionException e) {
                throw new RuntimeException(e);
            }
            chunkTable.setData(block.getColumns().stream().map(ChunkMeta::new).toArray(ChunkMeta[]::new));
            chunkTable.setColumnProperties(new String[]{"path", "type", "count", "nullCount", "uncompressedSize", "compressedSize", "codec", "encodings", "minMax"});
            sbuf.append(Tables.tableToString(chunkTable, "ascii"));
        }
        return sbuf.toString();
    }

    public static String formatLines(String heading, String lines) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(heading).append(":\n");
        if (lines != null) {
            for (String line : lines.split("[\n\r]+")) {
                sbuf.append("   ").append(line).append('\n');
            }
        }
        return sbuf.toString();
    }

    public static Map<String, Function<ParquetDump, String>> createDumpFunctionMap() {
        LinkedHashMap<String, Function<ParquetDump, String>> map = new LinkedHashMap<String, Function<ParquetDump, String>>();
        map.put("schema", dump -> ParquetDump.formatLines("Schema", dump.formatSchema()));
        map.put("kv", dump -> ParquetDump.formatLines("Key-Values", dump.formatKeyValuesCompact(75)));
        map.put("block", dump -> ParquetDump.formatLines("Blocks", dump.formatBlocks()));
        map.put("chunk", dump -> ParquetDump.formatLines("Column Chunks", dump.formatColumnChunks()));
        map.put("vot", dump -> ParquetDump.formatLines("VOTable", dump.starTable_.getVOTableMetadataText()));
        return map;
    }

    public static ParquetStarTable readParquetTable(String location) throws IOException {
        ParquetIO io = ParquetUtil.getIO();
        DataSource datsrc = DataSource.makeDataSource((String)location);
        ParquetTableBuilder builder = new ParquetTableBuilder();
        boolean useCache = false;
        boolean tryUrl = false;
        ParquetStarTable.Config config = new ParquetStarTable.Config(){

            @Override
            public boolean includeUnsupportedColumns() {
                return true;
            }
        };
        return io.readParquet(datsrc, builder, config, useCache, tryUrl);
    }

    public static void main(String[] args) throws IOException {
        LogUtils.getLogger((String)"uk.ac.starlink").setLevel(Level.WARNING);
        ParquetIO io = ParquetUtil.getIO();
        Map<String, Function<ParquetDump, String>> funcMap = ParquetDump.createDumpFunctionMap();
        String usage = "\n   Usage: " + ParquetDump.class.getName() + funcMap.keySet().stream().map(k -> " -" + k).collect(Collectors.joining()) + " <parquet-file>\n";
        ArrayList<String> items = new ArrayList<String>();
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.startsWith("-h")) {
                it.remove();
                System.out.println(usage);
                return;
            }
            if (!arg.startsWith("-")) continue;
            String itemName = null;
            for (String name : funcMap.keySet()) {
                if (!arg.startsWith("-" + name)) continue;
                itemName = name;
                it.remove();
            }
            if (itemName == null) {
                System.err.println(usage);
                System.exit(1);
                continue;
            }
            items.add(itemName);
        }
        if (argList.size() != 1) {
            System.err.println(usage);
            System.exit(1);
        }
        String loc = (String)argList.remove(0);
        if (items.isEmpty()) {
            items.addAll(funcMap.keySet());
        }
        ParquetStarTable table = ParquetDump.readParquetTable(loc);
        ParquetDump dump = new ParquetDump(table);
        for (String name : items) {
            System.out.println(funcMap.get(name).apply(dump));
        }
    }

    public static class ChunkMeta {
        final ColumnChunkMetaData base_;

        ChunkMeta(ColumnChunkMetaData base) {
            this.base_ = base;
        }

        public String getPath() {
            return this.base_.getPath().toDotString();
        }

        public String getType() {
            return this.base_.getPrimitiveType().getPrimitiveTypeName().toString();
        }

        public String getCodec() {
            return this.base_.getCodec().toString();
        }

        public boolean isDict() {
            return this.base_.hasDictionaryPage();
        }

        public long getCompressedSize() {
            return this.base_.getTotalSize();
        }

        public long getUncompressedSize() {
            return this.base_.getTotalUncompressedSize();
        }

        public long getCount() {
            return this.base_.getValueCount();
        }

        public long getNullCount() {
            return this.base_.getStatistics().getNumNulls();
        }

        public String getMinMax() {
            Statistics stats = this.base_.getStatistics();
            if (stats != null) {
                String min = stats.minAsString();
                String max = stats.maxAsString();
                if (min != null || max != null) {
                    return String.valueOf(min) + "/" + String.valueOf(max);
                }
                return null;
            }
            return null;
        }

        public String getEncodings() {
            return this.base_.getEncodings().stream().map(Object::toString).collect(Collectors.joining(","));
        }
    }
}

