/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ecsv;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.starlink.ecsv.EcsvEncoder;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.formats.DocumentedStreamStarTableWriter;
import uk.ac.starlink.util.ByteList;
import uk.ac.starlink.util.ConfigMethod;

public class EcsvTableWriter
extends DocumentedStreamStarTableWriter {
    private final String formatName_;
    private final byte badChar_;
    private final String nl_;
    private final String indent_;
    private final ByteList bbuf_;
    private char delimiter_;
    private String nullRep_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ecsv");
    public static final String TABLENAME_METAKEY = "name";
    public static final String UCD_METAKEY = "ucd";
    public static final String UTYPE_METAKEY = "utype";
    public static final String XTYPE_METAKEY = "xtype";
    public static final EcsvTableWriter SPACE_WRITER = new EcsvTableWriter(' ', "-space");
    public static final EcsvTableWriter COMMA_WRITER = new EcsvTableWriter(',', "-comma");
    private static final Collection<String> EXCLUDE_AUXMETAS = new HashSet<String>(Arrays.asList(Tables.NULL_VALUE_INFO.getName(), Tables.UBYTE_FLAG_INFO.getName(), "Datatype", "VOTable ID", "VOTable ref", "Type"));

    public EcsvTableWriter() {
        this(' ', null);
    }

    public EcsvTableWriter(char delimiter, String nameSuffix) {
        super(new String[]{"ecsv"});
        this.setDelimiter(Character.toString(delimiter));
        this.formatName_ = "ECSV" + (nameSuffix == null ? "" : nameSuffix);
        this.badChar_ = (byte)63;
        this.nl_ = "\n";
        this.indent_ = "  ";
        this.bbuf_ = new ByteList();
    }

    @Override
    public String getFormatName() {
        return this.formatName_;
    }

    @Override
    public String getMimeType() {
        return "text/plain";
    }

    @Override
    public boolean docIncludesExample() {
        return true;
    }

    @Override
    public String getXmlDescription() {
        return this.readText("EcsvTableWriter.xml");
    }

    @ConfigMethod(property="delimiter", doc="<p>Delimiter character, which for ECSV may be either a space or a comma. Permitted values are \"<code>space</code>\" or \"<code>comma</code>\".</p>", usage="comma|space", example="comma")
    public void setDelimiter(String delimiter) {
        if (" ".equals(delimiter) || "space".equals(delimiter)) {
            this.delimiter_ = (char)32;
        } else if (",".equals(delimiter) || "comma".equals(delimiter)) {
            this.delimiter_ = (char)44;
        } else {
            throw new IllegalArgumentException("Illegal delimiter \"" + delimiter + "\"");
        }
        this.nullRep_ = this.delimiter_ == ' ' ? "\"\"" : "";
    }

    public char getDelimiter() {
        return this.delimiter_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeStarTable(StarTable table, OutputStream out) throws IOException {
        int ncol = table.getColumnCount();
        EcsvEncoder[] encoders = new EcsvEncoder[ncol];
        for (int ic = 0; ic < ncol; ++ic) {
            ColumnInfo cinfo = table.getColumnInfo(ic);
            encoders[ic] = EcsvEncoder.createEncoder(cinfo, this.delimiter_);
            if (encoders[ic] != null) continue;
            logger_.warning("Will not write un-ECSV-able column " + cinfo);
        }
        this.writeHeaderLine(out, "%ECSV 1.0");
        this.writeHeaderLine(out, "---");
        if (this.delimiter_ != ' ') {
            this.writeHeaderLine(out, "delimiter: '" + this.delimiter_ + "'");
        }
        this.writeHeaderLine(out, "datatype:");
        StringBuilder nbuf = new StringBuilder();
        boolean isAfter0 = false;
        for (int ic = 0; ic < ncol; ++ic) {
            ColumnInfo colInfo = table.getColumnInfo(ic);
            EcsvEncoder encoder = encoders[ic];
            if (encoder == null) continue;
            if (isAfter0) {
                nbuf.append(this.delimiter_);
            }
            isAfter0 = true;
            nbuf.append(EcsvEncoder.quoteString(colInfo.getName(), this.delimiter_));
            this.writeHeaderLine(out, "-");
            this.writeHeaderPairString(out, 1, TABLENAME_METAKEY, colInfo.getName());
            this.writeHeaderPairString(out, 1, "datatype", encoder.getDatatype());
            this.writeHeaderPairString(out, 1, "subtype", encoder.getSubtype());
            this.writeHeaderPairString(out, 1, "unit", colInfo.getUnitString());
            this.writeHeaderPairString(out, 1, "description", colInfo.getDescription());
            Map<String, Object> colmeta = this.getColumnMeta(colInfo);
            this.writeMetaMap(out, 1, "meta", colmeta);
        }
        LinkedHashMap<String, Object> tmetaMap = new LinkedHashMap<String, Object>();
        String tname = table.getName();
        if (tname != null && tname.trim().length() > 0) {
            tmetaMap.put(TABLENAME_METAKEY, tname);
        }
        tmetaMap.putAll(this.getMetaMap(table.getParameters()));
        this.writeMetaMap(out, 0, "meta", tmetaMap);
        this.writeLine(out, nbuf);
        StringBuilder rbuf = new StringBuilder();
        try (RowSequence rseq = table.getRowSequence();){
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                rbuf.setLength(0);
                boolean isAfter = false;
                for (int ic = 0; ic < ncol; ++ic) {
                    EcsvEncoder encoder = encoders[ic];
                    if (encoder == null) continue;
                    if (isAfter) {
                        rbuf.append(this.delimiter_);
                    }
                    isAfter = true;
                    String ctxt = encoder.encode(row[ic]);
                    rbuf.append(ctxt == null ? this.nullRep_ : ctxt);
                }
                this.writeLine(out, rbuf);
            }
        }
    }

    private Map<String, Object> getMetaMap(List<DescribedValue> dvals) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (DescribedValue dval : dvals) {
            Object value = dval.getValue();
            map.put(dval.getInfo().getName(), value);
        }
        return map;
    }

    private Map<String, Object> getColumnMeta(ColumnInfo colInfo) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        String ucd = colInfo.getUCD();
        String utype = colInfo.getUtype();
        String xtype = colInfo.getXtype();
        if (ucd != null) {
            map.put(UCD_METAKEY, ucd);
        }
        if (utype != null) {
            map.put(UTYPE_METAKEY, utype);
        }
        if (xtype != null) {
            map.put(XTYPE_METAKEY, xtype);
        }
        ArrayList<DescribedValue> auxItems = new ArrayList<DescribedValue>();
        for (DescribedValue dval : colInfo.getAuxData()) {
            if (EXCLUDE_AUXMETAS.contains(dval.getInfo().getName())) continue;
            auxItems.add(dval);
        }
        map.putAll(this.getMetaMap(auxItems));
        return map;
    }

    private void writeMetaMap(OutputStream out, int nIndent, String metaKey, Map<String, ?> metaMap) throws IOException {
        if (metaMap != null && !metaMap.isEmpty()) {
            this.writeHeaderLine(out, this.repeatIndent(nIndent) + metaKey + ":");
            for (Map.Entry<String, ?> entry : metaMap.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof String || value instanceof Number || value instanceof Boolean) {
                    String txtval = Boolean.TRUE.equals(value) ? "True" : (Boolean.FALSE.equals(value) ? "False" : value.toString());
                    this.writeHeaderPairString(out, nIndent + 1, key, txtval);
                    continue;
                }
                if (!(value instanceof boolean[]) && !(value instanceof byte[]) && !(value instanceof short[]) && !(value instanceof int[]) && !(value instanceof long[]) && !(value instanceof float[]) && !(value instanceof double[]) && !(value instanceof String[])) continue;
                this.writeHeaderPairArray(out, nIndent + 1, key, value);
            }
        }
    }

    private void writeHeaderPairString(OutputStream out, int nIndent, String key, String value) throws IOException {
        String indentTxt = this.repeatIndent(nIndent);
        if (value != null && value.trim().length() > 0) {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append(indentTxt).append(EcsvTableWriter.sanitiseYamlScalar(key)).append(": ");
            if (value.indexOf(10) < 0) {
                sbuf.append(EcsvTableWriter.sanitiseYamlScalar(value));
                this.writeHeaderLine(out, sbuf);
            } else {
                this.writeHeaderLine(out, sbuf);
                this.writeHeaderLine(out, indentTxt + '|');
                for (String line : value.split("\n", -1)) {
                    this.writeHeaderLine(out, indentTxt + ' ' + line);
                }
            }
        }
    }

    private void writeHeaderPairArray(OutputStream out, int nIndent, String key, Object array) throws IOException {
        String indentTxt = this.repeatIndent(nIndent);
        Class<?> cclazz = array.getClass().getComponentType();
        assert (array != null && cclazz != null);
        int n = Array.getLength(array);
        StringBuilder sbuf = new StringBuilder();
        sbuf.append(indentTxt).append(EcsvTableWriter.sanitiseYamlScalar(key)).append(": ");
        if (n < 16 && cclazz != String.class) {
            sbuf.append("[");
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    sbuf.append(", ");
                }
                sbuf.append(String.valueOf(Array.get(array, i)));
            }
            sbuf.append("]");
            this.writeHeaderLine(out, sbuf);
        } else {
            this.writeHeaderLine(out, sbuf);
            for (int i = 0; i < n; ++i) {
                String elTxt = String.valueOf(Array.get(array, i));
                sbuf = new StringBuilder();
                sbuf.append(indentTxt).append("- ");
                if (elTxt.indexOf(10) < 0) {
                    sbuf.append(EcsvTableWriter.sanitiseYamlScalar(elTxt));
                    this.writeHeaderLine(out, sbuf);
                    continue;
                }
                this.writeHeaderLine(out, sbuf);
                this.writeHeaderLine(out, indentTxt + '|');
                for (String line : elTxt.split("\n", -1)) {
                    this.writeHeaderLine(out, indentTxt + ' ' + line);
                }
            }
        }
    }

    private String repeatIndent(int n) {
        StringBuilder sbuf = new StringBuilder(n * this.indent_.length());
        for (int i = 0; i < n; ++i) {
            sbuf.append(this.indent_);
        }
        return sbuf.toString();
    }

    private void writeHeaderLine(OutputStream out, CharSequence txt) throws IOException {
        out.write(35);
        out.write(32);
        this.writeLine(out, txt);
    }

    private void writeLine(OutputStream out, CharSequence txt) throws IOException {
        int ic;
        int nc = txt.length();
        this.bbuf_.clear();
        for (ic = 0; ic < nc; ++ic) {
            char c = txt.charAt(ic);
            byte b = (byte)(c & 0x7F);
            this.bbuf_.add(b == c ? b : this.badChar_);
        }
        for (ic = 0; ic < this.nl_.length(); ++ic) {
            this.bbuf_.add((byte)this.nl_.charAt(ic));
        }
        out.write(this.bbuf_.getByteBuffer(), 0, this.bbuf_.size());
    }

    private static String sanitiseYamlScalar(String txt) {
        if (EcsvTableWriter.isPlainScalar(txt)) {
            return txt;
        }
        int leng = txt.length();
        StringBuilder sbuf = new StringBuilder(leng + 2);
        char squote = '\'';
        sbuf.append(squote);
        for (int ic = 0; ic < leng; ++ic) {
            char c = txt.charAt(ic);
            sbuf.append(c);
            if (c != squote) continue;
            sbuf.append(squote);
        }
        sbuf.append(squote);
        return sbuf.toString();
    }

    private static boolean isPlainScalar(String txt) {
        int leng = txt.length();
        if (leng > 0) {
            switch (txt.charAt(0)) {
                case ' ': 
                case '!': 
                case '\"': 
                case '#': 
                case '%': 
                case '&': 
                case '\'': 
                case '*': 
                case ',': 
                case '-': 
                case ':': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '`': 
                case '{': 
                case '|': 
                case '}': {
                    return false;
                }
            }
        }
        for (int i = 0; i < leng; ++i) {
            char c = txt.charAt(i);
            if (c < ' ' || c > '\u007f') {
                return false;
            }
            switch (c) {
                case ',': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    return false;
                }
            }
        }
        return !txt.contains(": ") && !txt.contains(" #");
    }
}

