/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.astrogrid.samp.DataException;
import org.astrogrid.samp.Platform;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.xmlrpc.LockInfo;
import org.astrogrid.samp.xmlrpc.SampXmlRpcClient;
import org.astrogrid.samp.xmlrpc.SampXmlRpcClientFactory;
import org.astrogrid.samp.xmlrpc.SampXmlRpcServerFactory;
import org.astrogrid.samp.xmlrpc.StandardHubConnection;
import org.astrogrid.samp.xmlrpc.XmlRpcKit;

public class StandardClientProfile
implements ClientProfile {
    private final SampXmlRpcClientFactory xClientFactory_;
    private final SampXmlRpcServerFactory xServerFactory_;
    private static StandardClientProfile defaultInstance_;
    private static URL dfltLockUrl_;
    private static URL lockUrl_;
    private static final Logger logger_;
    public static final String LOCKFILE_NAME = ".samp";
    public static final String STDPROFILE_HUB_PREFIX = "std-lockurl:";

    public StandardClientProfile(SampXmlRpcClientFactory xClientFactory, SampXmlRpcServerFactory xServerFactory) {
        this.xClientFactory_ = xClientFactory;
        this.xServerFactory_ = xServerFactory;
    }

    public StandardClientProfile(XmlRpcKit xmlrpc) {
        this(xmlrpc.getClientFactory(), xmlrpc.getServerFactory());
    }

    public boolean isHubRunning() {
        try {
            LockInfo lockInfo = this.getLockInfo();
            if (lockInfo == null) {
                return false;
            }
            URL xurl = lockInfo.getXmlrpcUrl();
            if (xurl == null) {
                return false;
            }
            SampXmlRpcClient xClient = this.xClientFactory_.createClient(xurl);
            xClient.callAndWait("samp.hub.ping", new ArrayList());
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public HubConnection register() throws SampException {
        SampXmlRpcClient xClient;
        LockInfo lockInfo;
        try {
            lockInfo = this.getLockInfo();
        }
        catch (SampException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SampException("Error reading lockfile", e);
        }
        if (lockInfo == null) {
            return null;
        }
        try {
            lockInfo.check();
        }
        catch (DataException e) {
            String msg = "Incomplete/broken lock file";
            try {
                File lockFile = SampUtils.urlToFile(StandardClientProfile.getLockUrl());
                if (lockFile != null) {
                    msg = msg + " - try deleting " + lockFile;
                }
            }
            catch (IOException lockFile) {
                // empty catch block
            }
            throw new SampException(msg, e);
        }
        URL xurl = lockInfo.getXmlrpcUrl();
        try {
            xClient = this.xClientFactory_.createClient(xurl);
        }
        catch (IOException e) {
            throw new SampException("Can't connect to " + xurl, e);
        }
        return new StandardHubConnection(xClient, this.xServerFactory_, lockInfo.getSecret());
    }

    public LockInfo getLockInfo() throws IOException {
        return LockInfo.readLockFile(StandardClientProfile.getLockUrl());
    }

    public static URL getLockUrl() throws IOException {
        if (lockUrl_ == null) {
            URL lockUrl;
            String hublocEnv = "SAMP_HUB";
            String hubloc = Platform.getPlatform().getEnv(hublocEnv);
            if (hubloc != null && hubloc.startsWith(STDPROFILE_HUB_PREFIX)) {
                lockUrl = new URL(hubloc.substring(STDPROFILE_HUB_PREFIX.length()));
                logger_.info("Lockfile as set by env var: " + hublocEnv + "=" + hubloc);
            } else if (hubloc != null && hubloc.trim().length() > 0) {
                logger_.warning("Ignoring non-Standard " + hublocEnv + "=" + hubloc);
                lockUrl = StandardClientProfile.getDefaultLockUrl();
            } else {
                lockUrl = StandardClientProfile.getDefaultLockUrl();
                logger_.info("Using default Standard Profile lockfile: " + SampUtils.urlToFile(lockUrl));
            }
            lockUrl_ = lockUrl;
        }
        return lockUrl_;
    }

    public static URL getDefaultLockUrl() throws IOException {
        if (dfltLockUrl_ == null) {
            dfltLockUrl_ = SampUtils.fileToUrl(new File(Platform.getPlatform().getHomeDirectory(), LOCKFILE_NAME));
        }
        return dfltLockUrl_;
    }

    public static StandardClientProfile getInstance() {
        if (defaultInstance_ == null) {
            XmlRpcKit xmlrpc = XmlRpcKit.getInstance();
            defaultInstance_ = new StandardClientProfile(xmlrpc.getClientFactory(), xmlrpc.getServerFactory());
        }
        return defaultInstance_;
    }

    static {
        logger_ = Logger.getLogger(StandardClientProfile.class.getName());
    }
}

