/*
 * Decompiled with CFR 0.152.
 */
package skyview.data;

import nom.tam.fits.Header;
import skyview.executive.Settings;
import skyview.geometry.DepthSampler;
import skyview.geometry.Sampler;
import skyview.process.Processor;
import skyview.survey.Image;

public class BoxSmoother
implements Processor {
    private int nx = 1;
    private int ny = 1;
    private int width;
    private int height;
    private int depth;
    private double[] data;
    private double[] xdata;

    public String getName() {
        return "Smoother(" + this.nx + "," + this.ny + ")";
    }

    public String getDescription() {
        return "Box car smoother";
    }

    public void process(Image[] inputs, Image output, int[] selector, Sampler samp, DepthSampler dsamp) {
        String[] smoothPar = Settings.getArray((String)"smooth");
        try {
            if (smoothPar.length == 1 && smoothPar[0].length() > 0) {
                this.ny = this.nx = Integer.parseInt(smoothPar[0]);
            } else if (smoothPar.length > 1) {
                this.nx = Integer.parseInt(smoothPar[0].trim());
                this.ny = Integer.parseInt(smoothPar[1].trim());
            } else {
                this.nx = 3;
                this.ny = 3;
            }
        }
        catch (Exception e) {
            System.err.println("Error parsing smooth parameters:" + Settings.get((String)"smooth"));
            return;
        }
        this.data = output.getDataArray();
        this.width = output.getWidth();
        this.height = output.getHeight();
        this.depth = output.getDepth();
        if (this.depth <= 0) {
            this.depth = 1;
        }
        this.smooth();
    }

    public static void smooth(Image img, int boxWidth, int boxHeight) {
        BoxSmoother.smooth(img.getDataArray(), img.getWidth(), img.getHeight(), img.getDepth(), boxWidth, boxHeight);
    }

    public static void smooth(double[] data, int imageWidth, int imageHeight, int imageDepth, int boxWidth, int boxHeight) {
        BoxSmoother bs = new BoxSmoother();
        bs.data = data;
        bs.width = imageWidth;
        bs.height = imageHeight;
        bs.depth = imageDepth;
        bs.nx = boxWidth;
        bs.ny = boxHeight;
        bs.smooth();
    }

    public void smooth() {
        if (this.nx <= 1 && this.ny <= 1) {
            return;
        }
        this.xdata = (double[])this.data.clone();
        int dx = this.nx / 2;
        int dy = this.ny / 2;
        int xlim = this.width - 1;
        int ylim = this.height - 1;
        boolean dtest = this.depth > 1;
        int block = this.width * this.height;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                for (int iy = -dy; iy <= dy; ++iy) {
                    for (int ix = -dx; ix <= dx; ++ix) {
                        if (ix == 0 && iy == 0) continue;
                        int tx = x + ix;
                        int ty = y + iy;
                        if (tx < 0) {
                            tx = 0;
                        } else if (tx >= xlim) {
                            tx = xlim;
                        }
                        if (ty < 0) {
                            ty = 0;
                        } else if (ty > ylim) {
                            ty = ylim;
                        }
                        if (dtest) {
                            for (int z = 0; z < this.depth; ++z) {
                                int n = z * block + y * this.width + x;
                                this.xdata[n] = this.xdata[n] + this.data[z * block + ty * this.width + tx];
                            }
                            continue;
                        }
                        int n = y * this.width + x;
                        this.xdata[n] = this.xdata[n] + this.data[ty * this.width + tx];
                    }
                }
            }
        }
        double div = (2 * dx + 1) * (2 * dy + 1);
        int i = 0;
        while (i < this.xdata.length) {
            int n = i++;
            this.xdata[n] = this.xdata[n] / div;
        }
        System.arraycopy(this.xdata, 0, this.data, 0, this.data.length);
    }

    public void updateHeader(Header h) {
        try {
            h.insertHistory("");
            h.insertHistory("Smoothed with BoxSmoother:" + this.getClass().getName());
            h.insertHistory("    Box:" + this.nx + "," + this.ny);
            h.insertHistory("");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

