/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.projecter;

import skyview.geometry.Deprojecter;
import skyview.geometry.Projecter;
import skyview.geometry.Transformer;

public final class Sin
extends Projecter {
    public String getName() {
        return "Sin";
    }

    public String getDescription() {
        return "Project as if seeing the sphere from a great distance";
    }

    public Deprojecter inverse() {
        return new SinDeproj();
    }

    public boolean isInverse(Transformer t) {
        return t.getName().equals("SinDeproj");
    }

    public final void transform(double[] sphere, double[] plane) {
        if (Double.isNaN(sphere[2]) || sphere[2] <= 0.0) {
            plane[0] = Double.NaN;
            plane[1] = Double.NaN;
        } else {
            plane[0] = sphere[0];
            plane[1] = sphere[1];
        }
    }

    public boolean validPosition(double[] plane) {
        return super.validPosition(plane) && plane[0] * plane[0] + plane[1] * plane[1] <= 1.0;
    }

    public class SinDeproj
    extends Deprojecter {
        public String getName() {
            return "SinDeproj";
        }

        public String getDescription() {
            return "Invert the sine projection";
        }

        public Projecter inverse() {
            return Sin.this;
        }

        public boolean isInverse(Transformer t) {
            return t.getName().equals("Sin");
        }

        public final void transform(double[] plane, double[] sphere) {
            if (!Sin.this.validPosition(plane)) {
                sphere[0] = Double.NaN;
                sphere[1] = Double.NaN;
                sphere[2] = Double.NaN;
            } else {
                sphere[0] = plane[0];
                sphere[1] = plane[1];
                sphere[2] = Math.sqrt(1.0 - plane[0] * plane[0] - plane[1] * plane[1]);
            }
        }
    }
}

