/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import uk.ac.starlink.util.Bi;
import uk.ac.starlink.vo.AdqlVersion;
import uk.ac.starlink.vo.Ivoid;
import uk.ac.starlink.vo.TapCapability;
import uk.ac.starlink.vo.TapLanguage;

public class AdqlFeature {
    private final String name_;
    private final String description_;
    private static final Arg X = new Arg("x", Type.DOUBLE);
    private static final Arg Y = new Arg("y", Type.DOUBLE);
    private static final Arg N = new Arg("n", Type.INTEGER);
    private static final Arg GEOM = new Arg("geom", Type.GEOM);
    private static final Arg POINT = new Arg("point", Type.POINT);
    private static final Arg COOSYS = new Arg("coosys", Type.STRING);
    private static final Arg VARARGS = new Arg("...", null);
    private static final String PI = "\u03c0";
    private static final Ivoid UDF_FTYPE = TapCapability.createTapRegExtIvoid("#features-udf");
    private static final Ivoid[] ADQLGEO_FTYPES = new Ivoid[]{TapCapability.createTapRegExtIvoid("#features-adqlgeo"), TapCapability.createTapRegExtIvoid("#features-adql-geo")};
    private static final Ivoid STRING_FTYPE = TapCapability.createTapRegExtIvoid("#features-adql-string");
    private static final Ivoid CONDITIONAL_FTYPE;
    private static final Ivoid CTA_FTYPE;
    private static final Ivoid SETS_FTYPE;
    private static final Ivoid TYPE_FTYPE;
    private static final Ivoid UNIT_FTYPE;
    private static final Ivoid OFFSET_FTYPE;
    private static final Ivoid[] ADQL21MISC_FTYPES;
    public static final Predicate<Ivoid> UDF_FILTER;
    public static final Predicate<Ivoid> ADQLGEO_FILTER;
    public static final Predicate<Ivoid> ADQL21MISC_FILTER;
    public static final Predicate<Ivoid> NONSTD_FILTER;
    private static final Function[] MATHS_FUNCS;
    private static final Function[] TRIG_FUNCS;
    private static final Function[] GEOM_FUNCS_20;
    private static final Function[] GEOM_FUNCS_21;
    private static final Map<FeatKey, Function> OPT_FUNCS_21;
    private static final Map<FeatKey, AdqlFeature> OPT_FEATS_21;

    protected AdqlFeature(String name, String description) {
        this.name_ = name;
        this.description_ = description;
    }

    public String getName() {
        return this.name_;
    }

    public String getDescription() {
        return this.description_;
    }

    public static Function[] getMathsFunctions() {
        return (Function[])MATHS_FUNCS.clone();
    }

    public static Function[] getTrigFunctions() {
        return (Function[])TRIG_FUNCS.clone();
    }

    public static Function[] getGeomFunctions(AdqlVersion version, TapCapability tcap) {
        HashSet<Ivoid> ftypeSet = new HashSet<Ivoid>(Arrays.asList(ADQLGEO_FTYPES));
        Set geomFuncNames = Arrays.stream(tcap == null ? new TapLanguage[]{} : tcap.getLanguages()).flatMap(lang -> lang.getFeaturesMap().entrySet().stream()).filter(entry -> ftypeSet.contains(entry.getKey())).flatMap(entry -> Arrays.stream((Object[])entry.getValue())).map(feature -> feature.getForm()).collect(Collectors.toSet());
        return (Function[])Arrays.stream(AdqlFeature.is21(version) ? GEOM_FUNCS_21 : GEOM_FUNCS_20).filter(f -> geomFuncNames.contains(f.getName().toUpperCase())).toArray(Function[]::new);
    }

    public static Function[] getOptionalFunctions(TapCapability tcap) {
        LinkedHashMap<FeatKey, Function> funcMap = new LinkedHashMap<FeatKey, Function>(OPT_FUNCS_21);
        funcMap.keySet().retainAll(AdqlFeature.getFeatureKeys(tcap));
        return funcMap.values().toArray(new Function[0]);
    }

    public static AdqlFeature[] getOptionalFeatures(TapCapability tcap) {
        LinkedHashMap<FeatKey, AdqlFeature> featMap = new LinkedHashMap<FeatKey, AdqlFeature>(OPT_FEATS_21);
        featMap.keySet().retainAll(AdqlFeature.getFeatureKeys(tcap));
        return featMap.values().toArray(new AdqlFeature[0]);
    }

    private static Set<FeatKey> getFeatureKeys(TapCapability tcap) {
        return Arrays.stream(tcap == null ? new TapLanguage[]{} : tcap.getLanguages()).flatMap(lang -> lang.getFeaturesMap().entrySet().stream()).flatMap(entry -> Arrays.stream((Object[])entry.getValue()).map(feat -> new FeatKey((Ivoid)entry.getKey(), feat.getForm()))).collect(Collectors.toSet());
    }

    private static Function numFunc1(String name, String description, Arg arg) {
        return new Function(name, description, new Arg[]{arg}, Type.DOUBLE);
    }

    private static Function numFunc2(String name, String description, Arg arg1, Arg arg2) {
        return new Function(name, description, new Arg[]{arg1, arg2}, Type.DOUBLE);
    }

    private static Arg numArg(String name) {
        return new Arg(name, Type.DOUBLE);
    }

    private static Function geomFunc(String name, String description, Arg[] args, Type returnType, AdqlVersion version) {
        String fullDescription;
        Arg[] allArgs;
        if (AdqlFeature.is21(version)) {
            allArgs = args;
            fullDescription = description;
        } else {
            ArrayList<Arg> argList = new ArrayList<Arg>();
            argList.add(COOSYS);
            argList.addAll(Arrays.asList(args));
            fullDescription = new StringBuffer().append(description).append(" The initial ").append(COOSYS).append(" argument is supposed to give the name of ").append("a coordinate system, e.g. 'ICRS'. ").append("Services often ignore this parameter ").append("(which is removed in later versions of ADQL)").append("; the empty string '' can often be used.").toString();
            allArgs = argList.toArray(new Arg[0]);
        }
        return new Function(name, fullDescription, allArgs, returnType);
    }

    private static boolean is21(AdqlVersion version) {
        return !version.equals((Object)AdqlVersion.V20);
    }

    private static final Function[] createMathsFunctions() {
        return new Function[]{AdqlFeature.numFunc1("abs", "Returns the absolute value of " + X + ".", X), AdqlFeature.numFunc1("ceiling", "Returns the smallest integer that is not less than " + X + ".", X), AdqlFeature.numFunc1("degrees", "Converts the angle " + X + " from radians to degrees.", X), AdqlFeature.numFunc1("exp", "Returns the exponential of " + X + ".", X), AdqlFeature.numFunc1("floor", "Returns the largest integer that is not greater than " + X + ".", X), AdqlFeature.numFunc1("log", "Returns the natural logarithm (base e) of " + X + ". The value of " + X + " must be greater than zero", X), AdqlFeature.numFunc1("log10", "Returns the base 10 logarithm of " + X + ". The value of " + X + " must be greater than zero", X), AdqlFeature.numFunc2("mod", "Returns the remainder r of " + X + "/" + Y + " as a floating point value, where: r has the same sign as " + X + "; -r is less than -" + Y + "; " + X + "=n*" + Y + "+r for a given integer n.", X, Y), new Function("pi", "The numeric constant \u03c0.", new Arg[0], Type.DOUBLE), AdqlFeature.numFunc2("power", "Returns the value of " + X + " raised to the power of " + Y + ".", X, Y), AdqlFeature.numFunc1("radians", "Converts the angle " + X + " from degrees to radians.", X), AdqlFeature.numFunc1("sqrt", "Returns the positive square root of " + X + ".", X), AdqlFeature.numFunc1("rand", "Returns a random value between 0.0 and 1.0. The optional argument " + X + ", originally intended to provide a random seed, has undefined semantics. Query writers are advised to omit this argument.", X), AdqlFeature.numFunc2("round", "Rounds " + X + " to " + N + " decimal places. The integer " + N + " is optional and defaults to 0 if not specified. A negative value of " + N + " will round to the left of the decimal point.", X, N), AdqlFeature.numFunc2("truncate", "Truncates " + X + " to " + N + " decimal places. The integer " + N + " is optional and defaults to 0 if not specified.", X, N)};
    }

    private static final Function[] createTrigFunctions() {
        return new Function[]{AdqlFeature.numFunc1("acos", "Returns the arc cosine of " + X + ", in the range of 0 through " + PI + " radians. The absolute value of " + X + " must be less than or equal to 1.0.", X), AdqlFeature.numFunc1("asin", "Returns the arc sine of " + X + ", in the range of -" + PI + "/2 through " + PI + "/2 radians. The absolute value of " + X + " must be less than or equal to 1.0.", X), AdqlFeature.numFunc1("atan", "Returns the arc tangent of " + X + ", in the range of -" + PI + "/2 through " + PI + "/2 radians.", X), AdqlFeature.numFunc2("atan2", "Converts rectangular coordinates " + X + ", " + Y + " to polar angle. It computes the arc tangent of " + Y + "/" + X + " in the range of -" + PI + "/2 through " + PI + "/2 radians.", Y, X), AdqlFeature.numFunc1("cos", "Returns the cosine of the angle " + X + " in radians, in the range of -1.0 through 1.0.", X), AdqlFeature.numFunc1("sin", "Returns the sine of the angle " + X + " in radians, in the range of -1.0 through 1.0.", X), AdqlFeature.numFunc1("tan", "Returns the tangent of the angle " + X + " in radians.", X)};
    }

    private static Function[] createGeomFunctions(AdqlVersion version) {
        boolean is21 = AdqlFeature.is21(version);
        ArrayList<Function> list = new ArrayList<Function>();
        list.add(AdqlFeature.numFunc1("AREA", "Computes the area, in square degrees, of a given geometry.", GEOM));
        String boxDescrip1 = "Defines a box on the sky, centered at";
        String boxDescrip2 = String.join((CharSequence)"\n", "and with arms extending, parallel to the coordinate axes", "at the center position, for half the respective sizes", "on either side.", "Angles are in degrees.");
        if (is21) {
            boxDescrip2 = boxDescrip2 + "BOX is a special case of POLYGON defined purely for convenience. It is deprecated and may be removed in future versions of ADQL.";
        }
        list.add(AdqlFeature.geomFunc("BOX", boxDescrip1 + " (clon, clat) " + boxDescrip2, new Arg[]{AdqlFeature.numArg("clon"), AdqlFeature.numArg("clat"), AdqlFeature.numArg("dlon"), AdqlFeature.numArg("dlat")}, Type.POLYGON, version));
        if (is21) {
            list.add(AdqlFeature.geomFunc("BOX", boxDescrip1 + " center " + boxDescrip2, new Arg[]{new Arg("center", Type.POINT), AdqlFeature.numArg("dlon"), AdqlFeature.numArg("dlat")}, Type.POLYGON, version));
        }
        list.add(new Function("CENTROID", "Computes the centroid of a given geometry and returns a POINT.", new Arg[]{new Arg("geom", Type.GEOM)}, Type.POINT));
        String circleDescrip = "Defines a circular region on the sky (a cone in space). Arguments are in degrees.";
        list.add(AdqlFeature.geomFunc("CIRCLE", circleDescrip, new Arg[]{AdqlFeature.numArg("clon"), AdqlFeature.numArg("clat"), AdqlFeature.numArg("radius")}, Type.CIRCLE, version));
        if (is21) {
            list.add(AdqlFeature.geomFunc("CIRCLE", circleDescrip, new Arg[]{POINT, AdqlFeature.numArg("radius")}, Type.CIRCLE, version));
        }
        String containsDescrip = String.join((CharSequence)"\n", "Determines whether a geometry is wholly contained within another.", "This is most commonly used to express a point-in-shape condition.", "Returns the integer value 1 if the first argument is in,", "or on the boundary of, the second argument,", "and the integer value 0 if it is not.", "When used as a predicate in the WHERE clause of a query,", "the returned value must be compared to the integer values 1 or 0,", "e.g. \"WHERE 1=CONTAINS(POINT(25,-19), CIRCLE(25.4,-20,10)\".");
        list.add(new Function("CONTAINS", containsDescrip, new Arg[]{new Arg("inner", Type.GEOM), new Arg("outer", Type.GEOM)}, Type.INTEGER));
        list.add(AdqlFeature.numFunc1("COORD1", "Extracts the first coordinate value in degrees of a given POINT. For example COORD1(POINT(25.0,-19.5)) would return 25.", POINT));
        list.add(AdqlFeature.numFunc1("COORD2", "Extracts the second coordinate value in degrees of a given POINT. For example COORD2(POINT(25.0,-19.5)) would return -19.5.", POINT));
        String coordsysDescrip = "Extracts the coordinate system name from a given geometry.";
        if (is21) {
            coordsysDescrip = coordsysDescrip + " This function doesn't make much sense at ADQL 2.1 and is deprecated; it may be removed in future ADQL versions.";
        }
        list.add(new Function("COORDSYS", coordsysDescrip, new Arg[]{GEOM}, Type.STRING));
        String distanceDescrip = "Computes the arc length along a great circle between two points and returns a numeric value in degrees.";
        list.add(new Function("DISTANCE", distanceDescrip, new Arg[]{new Arg("point1", Type.POINT), new Arg("point2", Type.POINT)}, Type.DOUBLE));
        if (is21) {
            list.add(new Function("DISTANCE", distanceDescrip + " All arguments are in degrees.", new Arg[]{AdqlFeature.numArg("lon1"), AdqlFeature.numArg("lat1"), AdqlFeature.numArg("lon2"), AdqlFeature.numArg("lat2")}, Type.DOUBLE));
        }
        String intersectsDescrip = String.join((CharSequence)"\n", "Determines whether two geometry values overlap.", "This is most commonly used to express a \"shape-vs-shape\"", "intersection test.", "Returns the integer value 1 if the shapes intersect,", "and the integer value 0 if it is not.", "When used as a predicate in the WHERE clause of a query,", "the returned value must be compared to the integer values 1 or 0,", "for example \"WHERE 1=INTERSECTS(...)\".");
        list.add(new Function("INTERSECTS", intersectsDescrip, new Arg[]{new Arg("geom1", Type.GEOM), new Arg("geom2", Type.GEOM)}, Type.INTEGER));
        list.add(AdqlFeature.geomFunc("POINT", "Defines a single location on the sky. The arguments are in degrees.", new Arg[]{AdqlFeature.numArg("lon"), AdqlFeature.numArg("lat")}, Type.POINT, version));
        String polygonDescrip = String.join((CharSequence)"\n", "Defines a region on the sky with boundaries denoted by", "great circles passing through specified coordinates.", "At least three vertices must be specified,", "and the last vertex is implicitly connected to the first vertex.");
        list.add(AdqlFeature.geomFunc("POLYGON", polygonDescrip + " All arguments are in degrees.", new Arg[]{AdqlFeature.numArg("lon1"), AdqlFeature.numArg("lat1"), AdqlFeature.numArg("lon2"), AdqlFeature.numArg("lat2"), AdqlFeature.numArg("lon3"), AdqlFeature.numArg("lat3"), VARARGS}, Type.POLYGON, version));
        if (is21) {
            list.add(AdqlFeature.geomFunc("POLYGON", polygonDescrip, new Arg[]{new Arg("point1", Type.POINT), new Arg("point2", Type.POINT), new Arg("point3", Type.POINT), VARARGS}, Type.POLYGON, version));
        }
        String regionDescrip = String.join((CharSequence)"\n", "Provides a way of expressing a complex region represented by", "a single string literal.", "The argument must be a string literal not a string expression", "or column reference.", "The syntax is service specific;", "it may correspond to the semi-standard STC/S notation.");
        list.add(new Function("REGION", regionDescrip, new Arg[]{new Arg("text", Type.STRING)}, Type.REGION));
        return list.toArray(new Function[0]);
    }

    private static Map<FeatKey, Function> createOptionalFunctions() {
        LinkedHashMap<FeatKey, Function> map = new LinkedHashMap<FeatKey, Function>();
        for (String transform : new String[]{"LOWER", "UPPER"}) {
            map.put(new FeatKey(STRING_FTYPE, transform), new Function(transform, "Maps the input string to " + transform.toLowerCase() + " case in accordance with the rules of the database's locale.", new Arg[]{new Arg("text", Type.STRING)}, Type.STRING));
        }
        map.put(new FeatKey(CONDITIONAL_FTYPE, "COALESCE"), new Function("COALESCE", "Returns the first of its arguments that is not NULL. NULL is returned only if all arguments are NULL. All arguments must be of the same type.", new Arg[]{new Arg("arg", Type.ANY), VARARGS}, Type.ANY));
        String inUnitDescription = String.join((CharSequence)"\n", "Returns the value of the first argument transformed into the unit", "defined by the second argument.", "The first argument must be a numeric expression;", "if it is a column name, the VOUnits for this column ought to", "be found in the metadata attached to this column.", "The second argument must be a string literal giving a unit", "definition in valid VOUnit syntax.", "The system MUST report an error if the second argument", "is not a valid unit description, or if the system is not able", "to convert the value into the requested unit.");
        map.put(new FeatKey(UNIT_FTYPE, "IN_UNIT"), AdqlFeature.numFunc2("IN_UNIT", inUnitDescription, AdqlFeature.numArg("value"), new Arg("unit", Type.STRING)));
        return Collections.unmodifiableMap(map);
    }

    private static Map<FeatKey, AdqlFeature> createOptionalFeatures() {
        LinkedHashMap<FeatKey, AdqlFeature> map = new LinkedHashMap<FeatKey, AdqlFeature>();
        map.put(new FeatKey(STRING_FTYPE, "ILIKE"), new AdqlFeature("ILIKE", "String comparison operator that operates as the standard LIKE operator, but guaranteed case-insensitive."));
        String withDescrip = String.join((CharSequence)"\n", "Common Table Expressions are supported.", "You can write expressions like", "\"WITH subtable AS (SELECT ...) SELECT ... FROM subtable ...\".", "Recursive CTEs are not supported.", "They can be defined only in the main query,", "they are not allowed in sub-queries.");
        map.put(new FeatKey(CTA_FTYPE, "WITH"), new AdqlFeature("WITH", withDescrip));
        String unionDescrip = String.join((CharSequence)"\n", "Operator that combines two SELECT clauses", "giving the union of the two results.", "The joined queries must have the same number of columns", "with the same data types.", "Duplicated rows are removed unless the form UNION ALL is used.");
        map.put(new FeatKey(SETS_FTYPE, "UNION"), new AdqlFeature("UNION", unionDescrip));
        String intersectDescrip = String.join((CharSequence)"\n", "Operator that combines two SELECT clauses", "giving the intersection of the two results.", "The joined queries must have the same number of columns", "with the same data types.", "Duplicated rows are removed unless the form INTERSECT ALL is used.");
        map.put(new FeatKey(SETS_FTYPE, "INTERSECT"), new AdqlFeature("INTERSECT", intersectDescrip));
        String exceptDescrip = String.join((CharSequence)"\n", "Operator that combines two SELECT clauses", "giving those that appear in the first operand but not the second.", "The joined queries must have the same number of columns", "with the same data types.");
        map.put(new FeatKey(SETS_FTYPE, "EXCEPT"), new AdqlFeature("EXCEPT", exceptDescrip));
        String castDescrip = String.join((CharSequence)"\n", "Returns the value of the first argument converted into", "the datatype specified by the second argument.", "The syntax is CAST(value AS target-type).", "At least the following types are supported:", "INTEGER, SMALLINT, BIGINT, REAL, DOUBLE PRECISION,", "CHAR or CHAR(n), VARCHAR or VARCHAR(n), TIMESTAMP.", "Examples are", "\"CAST(value AS INTEGER)\",", "\"CAST('2021-01-14T11:25:00' AS TIMESTAMP)\".");
        map.put(new FeatKey(TYPE_FTYPE, "CAST"), new AdqlFeature("CAST", castDescrip));
        String offsetDescrip = String.join((CharSequence)"\n", "Clause that may be used to remove a specified number of rows", "from the beginning of the result.", "The syntax is \"SELECT ... OFFSET n\",", "where n is the number of rows to omit.", "The OFFSET clause comes right at the end of the SELECT statement,", "after any ORDER BY clause.", "If both OFFSET and TOP clauses are included,", "OFFSET is applied first.");
        map.put(new FeatKey(OFFSET_FTYPE, "OFFSET"), new AdqlFeature("OFFSET", offsetDescrip));
        return Collections.unmodifiableMap(map);
    }

    private static Predicate<Ivoid> createExcludeFilter(Ivoid[] ... excludes) {
        HashSet<Ivoid> excludeSet = new HashSet<Ivoid>();
        for (Ivoid[] items : excludes) {
            excludeSet.addAll(Arrays.asList(items));
        }
        return f -> !excludeSet.contains(f);
    }

    static {
        ADQL21MISC_FTYPES = new Ivoid[]{STRING_FTYPE, CONDITIONAL_FTYPE = TapCapability.createTapRegExtIvoid("#features-adql-conditional"), CTA_FTYPE = TapCapability.createTapRegExtIvoid("#features-adql-common-table"), SETS_FTYPE = TapCapability.createTapRegExtIvoid("#features-adql-sets"), TYPE_FTYPE = TapCapability.createTapRegExtIvoid("#features-adql-type"), UNIT_FTYPE = TapCapability.createTapRegExtIvoid("#features-adql-unit"), OFFSET_FTYPE = TapCapability.createTapRegExtIvoid("#features-adql-offset")};
        UDF_FILTER = ftype -> UDF_FTYPE.equals(ftype);
        ADQLGEO_FILTER = ftype -> Arrays.asList(ADQLGEO_FTYPES).contains(ftype);
        ADQL21MISC_FILTER = ftype -> Arrays.asList(ADQL21MISC_FTYPES).contains(ftype);
        NONSTD_FILTER = AdqlFeature.createExcludeFilter(ADQLGEO_FTYPES, ADQL21MISC_FTYPES, {UDF_FTYPE});
        MATHS_FUNCS = AdqlFeature.createMathsFunctions();
        TRIG_FUNCS = AdqlFeature.createTrigFunctions();
        GEOM_FUNCS_20 = AdqlFeature.createGeomFunctions(AdqlVersion.V20);
        GEOM_FUNCS_21 = AdqlFeature.createGeomFunctions(AdqlVersion.V21);
        OPT_FUNCS_21 = AdqlFeature.createOptionalFunctions();
        OPT_FEATS_21 = AdqlFeature.createOptionalFeatures();
    }

    private static class FeatKey
    extends Bi<Ivoid, String> {
        FeatKey(Ivoid type, String name) {
            super((Object)type, (Object)name.toUpperCase());
        }
    }

    public static enum Type {
        DOUBLE,
        INTEGER,
        STRING,
        POINT,
        CIRCLE,
        POLYGON,
        REGION,
        GEOM,
        ANY;

    }

    public static class Arg {
        private final String name_;
        private final Type type_;

        Arg(String name, Type type) {
            this.name_ = name;
            this.type_ = type;
        }

        public String getName() {
            return this.name_;
        }

        public Type getType() {
            return this.type_;
        }

        public String toString() {
            return this.name_;
        }
    }

    public static class Function
    extends AdqlFeature {
        private final Arg[] args_;
        private final Type returnType_;

        protected Function(String name, String description, Arg[] args, Type returnType) {
            super(name, description);
            this.args_ = args;
            this.returnType_ = returnType;
        }

        public Arg[] getArgs() {
            return this.args_;
        }

        public Type getReturnType() {
            return this.returnType_;
        }
    }
}

