/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.io.IOException;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.votable.Namespacing;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.VOElementFactory;
import uk.ac.starlink.votable.VOStarTable;

public class DalResultXMLFilter
extends XMLFilterImpl {
    private final Namespacing namespacing_;
    private final StringBuffer path_;
    private String resultsPath_;
    private String ignorePath_;
    private static Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");

    public DalResultXMLFilter(XMLReader parent, Namespacing namespacing) {
        super(parent);
        this.namespacing_ = namespacing;
        this.path_ = new StringBuffer();
    }

    private boolean ignore() {
        return this.ignorePath_ != null;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String voTagName = this.namespacing_.getVOTagName(namespaceURI, localName, qName);
        this.path_.append('/').append(voTagName);
        if ("RESOURCE".equals(voTagName) && "results".equals(atts.getValue("type"))) {
            this.resultsPath_ = this.path_.toString();
        }
        if ("TABLE".equals(voTagName) && this.resultsPath_ == null) {
            this.ignorePath_ = this.path_.toString();
        }
        if (!this.ignore()) {
            super.startElement(namespaceURI, localName, qName, atts);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String path;
        if (!this.ignore()) {
            super.endElement(namespaceURI, localName, qName);
        }
        if ((path = this.path_.toString()).equals(this.resultsPath_)) {
            this.resultsPath_ = null;
        } else if (path.equals(this.ignorePath_)) {
            this.ignorePath_ = null;
        }
        String voTagName = this.namespacing_.getVOTagName(namespaceURI, localName, qName);
        assert (this.path_.toString().endsWith("/" + voTagName));
        this.path_.setLength(this.path_.length() - voTagName.length() - 1);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (!this.ignore()) {
            super.startPrefixMapping(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (!this.ignore()) {
            super.endPrefixMapping(prefix);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.ignore()) {
            super.characters(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (!this.ignore()) {
            super.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (!this.ignore()) {
            super.processingInstruction(target, data);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (!this.ignore()) {
            super.skippedEntity(name);
        }
    }

    public static VOElement parseDalResult(VOElementFactory vofact, InputSource inSrc) throws IOException {
        try {
            Namespacing namespacing = Namespacing.LAX;
            SAXParserFactory spfact = SAXParserFactory.newInstance();
            namespacing.configureSAXParserFactory(spfact);
            XMLReader streamReader = spfact.newSAXParser().getXMLReader();
            DalResultXMLFilter resultReader = new DalResultXMLFilter(streamReader, namespacing);
            SAXSource xsrc = new SAXSource(resultReader, inSrc);
            return vofact.makeVOElement((Source)xsrc);
        }
        catch (SAXException e) {
            throw (IOException)new IOException("VOTable document parse error").initCause(e);
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException("XML configuration error").initCause(e);
        }
    }

    public static StarTable getDalResultTable(VOElementFactory vofact, InputSource inSrc) throws IOException {
        NodeList tableNodes;
        int nTable;
        VOElement voEl = DalResultXMLFilter.parseDalResult(vofact, inSrc);
        VOElement resultEl = DalResultXMLFilter.locateElement(voEl, "RESOURCE", "type", "results");
        if (resultEl == null) {
            throw new IOException("No <RESOURCE type='results'> element found");
        }
        VOElement statusEl = DalResultXMLFilter.locateElement(resultEl, "INFO", "name", "QUERY_STATUS");
        if (statusEl == null) {
            logger_.warning("No <INFO name='QUERY_STATUS'> element found - try assuming OK");
        }
        if (statusEl != null) {
            String msg;
            String statusValue = statusEl.getAttribute("value");
            String statusText = DOMUtils.getTextContent((Element)statusEl);
            String string = msg = statusText == null || statusText.trim().length() == 0 ? "QUERY_STATUS is " + statusValue : statusText;
            if (!"OK".equals(statusValue)) {
                if ("ERROR".equals(statusValue)) {
                    throw new IOException(msg);
                }
                logger_.warning(msg);
            }
        }
        if ((nTable = (tableNodes = resultEl.getElementsByVOTagName("TABLE")).getLength()) == 0) {
            throw new IOException("No table found in <RESOURCE type='results'>");
        }
        if (nTable > 1) {
            logger_.warning("Found " + nTable + " tables in <RESOURCE type='results'> - just returning first");
        }
        return new VOStarTable((TableElement)tableNodes.item(0));
    }

    private static VOElement locateElement(VOElement parentEl, String voTagName, String attName, String attValue) {
        VOElement[] children = parentEl.getChildrenByName(voTagName);
        for (int ii = 0; ii < children.length; ++ii) {
            VOElement el = children[ii];
            if (!attValue.equals(el.getAttribute(attName))) continue;
            return el;
        }
        NodeList nodes = parentEl.getElementsByVOTagName(voTagName);
        int nNode = nodes.getLength();
        for (int in = 0; in < nNode; ++in) {
            VOElement el = (VOElement)nodes.item(in);
            if (!attValue.equals(el.getAttribute(attName))) continue;
            return el;
        }
        return null;
    }
}

