/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.MutableComboBoxModel;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.vo.RegistryProtocol;
import uk.ac.starlink.vo.RegistryQuery;
import uk.ac.starlink.vo.RegistrySelector;
import uk.ac.starlink.vo.RegistrySelectorModel;
import uk.ac.starlink.vo.Ri1RegistryQuery;

public class Ri1RegistryQueryPanel
extends JPanel {
    private RegistrySelector urlSelector_;
    private JComboBox<String> querySelector_;

    public Ri1RegistryQueryPanel() {
        super(new BorderLayout());
        Box qBox = Box.createVerticalBox();
        this.add((Component)qBox, "Center");
        this.urlSelector_ = new RegistrySelector(new RegistrySelectorModel(RegistryProtocol.RI1));
        qBox.add(this.urlSelector_);
        qBox.add(Box.createVerticalStrut(5));
        Box queryLine = Box.createHorizontalBox();
        this.querySelector_ = new JComboBox();
        this.querySelector_.setEditable(true);
        queryLine.add(new JLabel("Query: "));
        queryLine.add(this.querySelector_);
        qBox.add(queryLine);
    }

    public void setPresetQueries(String[] queries) {
        this.querySelector_.setModel(new DefaultComboBoxModel<String>(queries));
        this.querySelector_.setSelectedIndex(0);
    }

    public RegistryQuery getRegistryQuery() throws MalformedURLException {
        URL regURL;
        String regServ = this.urlSelector_.getUrl();
        String query = (String)this.querySelector_.getSelectedItem();
        if (query == null || query.trim().length() == 0) {
            throw new MalformedURLException("Query URL is blank");
        }
        if (regServ == null || regServ.trim().length() == 0) {
            throw new MalformedURLException("Registry URL is blank");
        }
        try {
            regURL = URLUtils.newURL((String)regServ);
        }
        catch (MalformedURLException e) {
            throw new MalformedURLException("Bad registry URL: " + regServ);
        }
        ComboBoxModel<String> qModel = this.querySelector_.getModel();
        if (qModel instanceof MutableComboBoxModel) {
            boolean present = false;
            for (int i = 0; !present && i < qModel.getSize(); ++i) {
                if (!query.equals(qModel.getElementAt(i))) continue;
                present = true;
            }
            if (!present) {
                ((MutableComboBoxModel)qModel).addElement(query);
            }
        }
        return new Ri1RegistryQuery(regURL.toString(), query);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.urlSelector_.setEnabled(enabled);
        this.querySelector_.setEnabled(enabled);
    }
}

