/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.pal.Pal;
import uk.ac.starlink.pal.palTime;

public abstract class ValueConverter {
    private final String name_;
    private static final Pattern SEX_PATTERN = Pattern.compile(" *([+\\-]?) *([0-9]+) *[: ] *([0-9]+) *[: ] *([0-9]+\\.?[0-9]*) *");

    public ValueConverter(String name) {
        this.name_ = name;
    }

    public abstract double convertValue(String var1);

    public abstract String unconvertValue(double var1);

    public String getName() {
        return this.name_;
    }

    public String toString() {
        return this.getName();
    }

    private static double dmsToDegrees(String dms) {
        Matcher matcher = SEX_PATTERN.matcher(dms);
        if (!matcher.matches()) {
            throw new NumberFormatException("\"" + dms + "\" not sexagesimal");
        }
        try {
            double sign = "-".equals(matcher.group(1)) ? -1.0 : 1.0;
            int deg = Integer.parseInt(matcher.group(2));
            int min = Integer.parseInt(matcher.group(3));
            double sec = Double.parseDouble(matcher.group(4));
            return sign * ((double)deg + ((double)min + sec / 60.0) / 60.0);
        }
        catch (IllegalArgumentException e) {
            throw new NumberFormatException("\"" + dms + "\" not sexagesimal");
        }
    }

    private static String formatSex(palTime palTime2) {
        String sh = Integer.toString(palTime2.getHour());
        String sm = Integer.toString(palTime2.getMin());
        String ss = Integer.toString(palTime2.getSec());
        return new StringBuffer().append(sh).append(':').append(sm.length() == 1 ? "0" : "").append(sm).append(':').append(ss.length() == 1 ? "0" : "").append(ss).toString();
    }

    public static class HMSDegreesValueConverter
    extends ValueConverter {
        public HMSDegreesValueConverter() {
            super("hh:mm:ss");
        }

        @Override
        public double convertValue(String sval) {
            return 15.0 * ValueConverter.dmsToDegrees(sval);
        }

        @Override
        public String unconvertValue(double dval) {
            return ValueConverter.formatSex(new Pal().Dr2tf(Math.toRadians(dval)));
        }
    }

    public static class DMSDegreesValueConverter
    extends ValueConverter {
        public DMSDegreesValueConverter() {
            super("dd:mm:ss");
        }

        @Override
        public double convertValue(String sval) {
            return ValueConverter.dmsToDegrees(sval);
        }

        @Override
        public String unconvertValue(double dval) {
            return ValueConverter.formatSex(new Pal().Dr2af(Math.toRadians(dval)));
        }
    }

    public static class UnitValueConverter
    extends ValueConverter {
        private final double factor_;

        public UnitValueConverter(String name, double factor) {
            super(name);
            this.factor_ = factor;
        }

        @Override
        public double convertValue(String sval) {
            return Double.parseDouble(sval) * this.factor_;
        }

        @Override
        public String unconvertValue(double dval) {
            return Double.isNaN(dval) ? null : Double.toString(dval / this.factor_);
        }
    }
}

