/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.util.Arrays;
import uk.ac.starlink.vo.AdqlVersion;
import uk.ac.starlink.vo.Ivoid;
import uk.ac.starlink.vo.TapLanguage;

public class VersionedLanguage {
    private final TapLanguage lang_;
    private final String version_;

    public VersionedLanguage(TapLanguage lang, String version) {
        this.lang_ = lang;
        this.version_ = version;
        if (!Arrays.asList(lang.getVersions()).contains(version)) {
            throw new IllegalArgumentException("Language \"" + lang + "\" does not have a version \"" + version + "\"");
        }
    }

    public TapLanguage getLanguage() {
        return this.lang_;
    }

    public String getVersion() {
        return this.version_;
    }

    public AdqlVersion getAdqlVersion() {
        AdqlVersion numVersion;
        if (this.lang_ == null || this.version_ == null) {
            return null;
        }
        Ivoid[] vids = this.lang_.getVersionIds();
        String[] vnames = this.lang_.getVersions();
        if (vids == null || vnames == null || vids.length != vnames.length) {
            return null;
        }
        int iv = Arrays.asList(vnames).indexOf(this.version_);
        if (iv < 0) {
            return null;
        }
        AdqlVersion idVersion = AdqlVersion.byIvoid(vids[iv]);
        if (idVersion != null) {
            return idVersion;
        }
        if ("ADQL".equalsIgnoreCase(this.lang_.getName()) && (numVersion = AdqlVersion.byNumber(vnames[iv])) != null) {
            return numVersion;
        }
        return null;
    }

    public String getVersionedName() {
        StringBuffer sbuf = new StringBuffer().append(this.lang_.getName());
        if (this.version_ != null) {
            sbuf.append('-').append(this.version_);
        }
        return sbuf.toString();
    }

    public String toString() {
        return this.getVersionedName();
    }
}

