/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand;

import adql.db.DBColumn;
import adql.parser.feature.LanguageFeature;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.IdentifierField;
import adql.query.NullADQLIterator;
import adql.query.TextPosition;
import adql.query.from.ADQLTable;
import adql.query.operand.ADQLOperand;
import adql.query.operand.UnknownType;

public class ADQLColumn
implements ADQLOperand,
UnknownType {
    public static final LanguageFeature FEATURE = new LanguageFeature(null, "COLUMN", false, "Name of a database column.");
    private TextPosition position = null;
    private String catalog = null;
    private String schema = null;
    private String table = null;
    private String column;
    private byte caseSensitivity = 0;
    private DBColumn dbLink = null;
    @Deprecated
    private ADQLTable adqlTable = null;
    private char expectedType = (char)63;

    public ADQLColumn(String columnRef) {
        this.setColumn(columnRef);
    }

    public ADQLColumn(String tableName, String columnName) {
        this.setTableName(tableName);
        this.setColumnName(columnName);
    }

    public ADQLColumn(String schema, String table, String column) {
        this(table, column);
        this.setSchemaName(schema);
    }

    public ADQLColumn(String catalog, String schema, String table, String column) {
        this(schema, table, column);
        this.setCatalogName(catalog);
    }

    public ADQLColumn(ADQLColumn toCopy) {
        this.column = toCopy.column;
        this.table = toCopy.table;
    }

    @Override
    public final LanguageFeature getFeatureDescription() {
        return FEATURE;
    }

    protected String normalizeName(String name, IdentifierField field) {
        if (name == null) {
            return null;
        }
        StringBuffer n = new StringBuffer(name);
        n.trimToSize();
        if (n.length() == 0) {
            return null;
        }
        if (n.length() > 1 && n.charAt(0) == '\"' && n.charAt(n.length() - 1) == '\"') {
            n.deleteCharAt(0);
            n.deleteCharAt(n.length() - 1);
            n.trimToSize();
            if (n.length() == 0) {
                return null;
            }
            this.setCaseSensitive(field, true);
        }
        return n.toString();
    }

    @Override
    public final TextPosition getPosition() {
        return this.position;
    }

    public void setPosition(TextPosition pos) {
        this.position = pos;
    }

    public final String getCatalogName() {
        return this.catalog;
    }

    public final void setCatalogName(String catalog) {
        String temp = this.normalizeName(catalog, IdentifierField.CATALOG);
        if (this.catalog == null && temp != null || this.catalog != null && !this.catalog.equalsIgnoreCase(temp)) {
            this.dbLink = null;
        }
        this.catalog = temp;
    }

    public final String getSchemaName() {
        return this.schema;
    }

    public final void setSchemaName(String schema) {
        String temp = this.normalizeName(schema, IdentifierField.SCHEMA);
        if (this.schema == null && temp != null || this.schema != null && !this.schema.equalsIgnoreCase(temp)) {
            this.dbLink = null;
        }
        this.schema = temp;
    }

    public final String getTableName() {
        return this.table;
    }

    public final void setTableName(String tableName) {
        String temp = this.normalizeName(tableName, IdentifierField.TABLE);
        if (this.table == null && temp != null || this.table != null && !this.table.equalsIgnoreCase(temp)) {
            this.dbLink = null;
        }
        this.table = temp;
    }

    public final String getColumnName() {
        return this.column;
    }

    public final String getFullColumnName() {
        if (this.column == null) {
            return "";
        }
        StringBuffer name = this.getFullColumnPrefix();
        if (name.length() > 0) {
            name.append('.');
        }
        if (this.isCaseSensitive(IdentifierField.COLUMN)) {
            name.append('\"').append(this.column).append('\"');
        } else {
            name.append(this.column);
        }
        return name.toString();
    }

    public final StringBuffer getFullColumnPrefix() {
        StringBuffer name = new StringBuffer();
        if (this.catalog != null) {
            if (this.isCaseSensitive(IdentifierField.CATALOG)) {
                name.append('\"').append(this.catalog).append("\".");
            } else {
                name.append(this.catalog).append('.');
            }
        }
        if (this.schema != null) {
            if (this.isCaseSensitive(IdentifierField.SCHEMA)) {
                name.append('\"').append(this.schema).append("\".");
            } else {
                name.append(this.schema).append('.');
            }
        }
        if (this.table != null) {
            if (this.isCaseSensitive(IdentifierField.TABLE)) {
                name.append('\"').append(this.table).append("\"");
            } else {
                name.append(this.table);
            }
        }
        return name;
    }

    public final void setColumnName(String columnName) {
        String temp = this.normalizeName(columnName, IdentifierField.COLUMN);
        if (this.column == null && temp != null || this.column != null && !this.column.equalsIgnoreCase(temp)) {
            this.dbLink = null;
        }
        this.column = temp;
    }

    public final void setColumn(String columnRef) {
        String[] parts;
        String[] stringArray = parts = columnRef == null ? null : columnRef.split("\\.");
        if (parts != null && parts.length > 4) {
            return;
        }
        int i = parts == null ? -1 : parts.length - 1;
        this.setColumnName(i < 0 ? null : parts[i--]);
        this.setTableName(i < 0 ? null : parts[i--]);
        this.setSchemaName(i < 0 ? null : parts[i--]);
        this.setCatalogName(i < 0 ? null : parts[i]);
    }

    public final boolean isCaseSensitive(IdentifierField field) {
        return field.isCaseSensitive(this.caseSensitivity);
    }

    public final void setCaseSensitive(IdentifierField field, boolean sensitive) {
        this.caseSensitivity = field.setCaseSensitive(this.caseSensitivity, sensitive);
    }

    public final boolean isCaseSensitive() {
        return IdentifierField.isFullCaseSensitive(this.caseSensitivity);
    }

    public final void setCaseSensitive(boolean sensitive) {
        this.caseSensitivity = IdentifierField.getFullCaseSensitive(sensitive);
    }

    public final byte getCaseSensitive() {
        return this.caseSensitivity;
    }

    public final void setCaseSensitive(byte sensitivity) {
        this.caseSensitivity = sensitivity;
    }

    public final DBColumn getDBLink() {
        return this.dbLink;
    }

    public final void setDBLink(DBColumn dbLink) {
        this.dbLink = dbLink;
    }

    @Deprecated
    public final ADQLTable getAdqlTable() {
        return this.adqlTable;
    }

    @Deprecated
    public final void setAdqlTable(ADQLTable adqlTable) {
        this.adqlTable = adqlTable;
    }

    @Override
    public char getExpectedType() {
        return this.expectedType;
    }

    @Override
    public void setExpectedType(char c) {
        this.expectedType = c;
    }

    @Override
    public boolean isNumeric() {
        return this.dbLink == null || this.dbLink.getDatatype() == null || this.dbLink.getDatatype().isNumeric() || this.dbLink.getDatatype().isUnknown();
    }

    @Override
    public boolean isString() {
        return this.dbLink == null || this.dbLink.getDatatype() == null || this.dbLink.getDatatype().isString() || this.dbLink.getDatatype().isUnknown() && !this.dbLink.getDatatype().isNumeric();
    }

    @Override
    public boolean isGeometry() {
        return this.dbLink == null || this.dbLink.getDatatype() == null || this.dbLink.getDatatype().isGeometry() || this.dbLink.getDatatype().isUnknown() && !this.dbLink.getDatatype().isNumeric();
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new ADQLColumn(this);
    }

    @Override
    public String getName() {
        if (this.dbLink != null) {
            return this.dbLink.isCaseSensitive() ? this.dbLink.getADQLName() : this.dbLink.getADQLName().toLowerCase();
        }
        return this.getColumnName();
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new NullADQLIterator();
    }

    @Override
    public String toADQL() {
        return this.getFullColumnName();
    }

    public String toString() {
        return this.toADQL();
    }
}

