package fit.gui;

import java.util.ArrayList;
import java.util.List;
import fit.framework.MetadataTable;
import fit.framework.TheorySet;

/**
 * TableModel implementation which represents a {@link fit.framework.TheorySet}.
 * This is an adaptor class.
 *
 * @author   Mark Taylor
 * @since    22 Jan 2007
 */
public class TheorySetTableModel extends ColumnsTableModel {

    private final TheorySet tset_;

    /**
     * Constructor.
     *
     * @param   tset   theory set
     */
    public TheorySetTableModel( final TheorySet tset ) {
        tset_ = tset;
        List colList = new ArrayList();

        /* Add a column containing the theory name. */
        colList.add( new ColDef( "Name", String.class ) {
            public Object getValueAt( int irow ) { 
                return tset.getTheory( irow ).getName();
            }
        } );

        /* Add columns containing the theory metadata. */
        final MetadataTable meta = tset.getMetadataTable();
        if ( meta != null ) {
            for ( int ic = 0; ic < meta.getColumnCount(); ic++ ) {
                final int icol = ic;
                colList.add( new ColDef( meta.getColumnName( icol ),
                                         meta.getColumnClass( icol ) ) {
                    public Object getValueAt( int irow ) {
                        return meta.getValueAt( irow, icol );
                    }
                } );
            }
        }
        setColDefs( (ColDef[]) colList.toArray( new ColDef[ 0 ] ) );
    }

    public int getRowCount() {
        return tset_.getTheoryCount();
    }
}
