package fit.task;

import uk.ac.starlink.task.InvokeUtils;
import uk.ac.starlink.task.MultiTaskInvoker;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.util.IOUtils;
import uk.ac.starlink.util.ObjectFactory;

/**
 * Top-level class used for invoking fitting tasks from the command line.
 */
public class Yafit {

    private static final ObjectFactory taskFactory_ = getTaskFactory();
    public static final String VERSION_RESOURCE = "yafit.version";

    /**
     * Main method.  Invoked with no arguments, a usage message will be output.
     *
     * @param  args  argument vector
     */
    public static void main( String[] args ) {
        MultiTaskInvoker invoker =
            new MultiTaskInvoker( "yafit", taskFactory_ );
        invoker.setVersionMessage( getVersionMessage() );
        int status = invoker.invoke( args );
        if ( status != 0 ) {
            System.exit( status );
        }
    }

    /**
     * Returns a factory which creates {@link uk.ac.starlink.task.Task}
     * objects which can be executed by this tool.
     *
     * @return  task factory
     */
    public static ObjectFactory getTaskFactory() {
        ObjectFactory taskFactory = new ObjectFactory( Task.class );
        String taskPkg = "fit.task.";
        taskFactory.register( "fit", taskPkg + "FitTask" );
        taskFactory.register( "funcs", taskPkg + "ShowFunctionTask" );
        taskFactory.register( "copymodel", taskPkg + "CopyTheorySetTask" );
        taskFactory.register( "tableobs", taskPkg + "TableObservationSetTask" );
        taskFactory.register( "plotmodel", taskPkg + "PlotTheoryTask" );
        taskFactory.register( "plotobs", taskPkg + "PlotObservationTask" );
        return taskFactory;
    }

    /**
     * Returns version string for this tool.
     *
     * @return  one-word version string
     */
    public static String getVersion() {
        return IOUtils.getResourceContents( Yafit.class, VERSION_RESOURCE );
    }

    /**
     * Returns the version message for this tool.
     *
     * @return   formatted multi-line version message
     */
    public static String getVersionMessage() {
        return new StringBuffer()
            .append( "\n" )
            .append( "    This is YAFIT, Yet Another Fitting tool\n" )
            .append( "\n" ) 
            .append( "    YAFIT version " )
            .append( Yafit.getVersion() )
            .append( "\n" )
            .append( "    Java version  " )
            .append( InvokeUtils.getJavaVersion() )
            .append( "\n" )
            .append( "\n" )
            .append( "    Author: Mark Taylor\n" )
            .append( "\n" )
            .toString();
    }
}
