package fit.test;

import fit.framework.MetadataTable;
import fit.util.FitUtils;
import fit.util.StarMetadataTable;
import java.io.IOException;
import junit.framework.TestCase;
import uk.ac.starlink.table.ArrayColumn;
import uk.ac.starlink.table.ColumnStarTable;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;

public class MetadataTableTest extends TestCase {

    public MetadataTableTest( String name ) {
        super( name );
    }

    public void testTables() throws IOException {
        StarTable starTable = getStarTable();
        MetadataTable metaTable = new StarMetadataTable( starTable );
        assertEquals( 0, FitUtils.getColumnIndex( metaTable, "Name" ) );
        assertEquals( -1, FitUtils.getColumnIndex( metaTable, "Duff" ) );
        int ncol = metaTable.getColumnCount();
        assertEquals( ncol, starTable.getColumnCount() );
        int nrow = metaTable.getRowCount();
        assertEquals( nrow, (int) starTable.getRowCount() );
        for ( int icol = 0; icol < ncol; icol++ ) {
            assertEquals( icol, FitUtils
                               .getColumnIndex( metaTable,
                                     metaTable.getColumnName( icol ) ) );
        }
        assertTableEquals( metaTable, metaTable );
        assertTableEquals( metaTable, new StarMetadataTable( getStarTable() ) );

        assertTrue( starTable == FitUtils.getStarTable( metaTable ) );
    }

    public void assertTableEquals( MetadataTable t1, MetadataTable t2 ) {
        int ncol = t1.getColumnCount();
        assertEquals( ncol, t2.getColumnCount() );
        int nrow = t1.getRowCount();
        assertEquals( nrow, t2.getRowCount() );
        for ( int icol = 0; icol < ncol; icol++ ) {
            assertEquals( t1.getColumnName( icol ), t2.getColumnName( icol ) );
            assertEquals( t2.getColumnClass( icol ),
                          t2.getColumnClass( icol ) );
            for ( int irow = 0; irow < nrow; irow++ ) {
                assertEquals( t1.getValueAt( irow, icol ),
                              t2.getValueAt( irow, icol ) );
            }
        }
    }

    private static StarTable getStarTable() {
        ColumnStarTable table = ColumnStarTable.makeTableWithRows( 4 );
        String[] names = new String[] {
            "Thatchers", "Turbo", "Woodpecker", "Andy", };
        float[] abvs = new float[] { 6.9f, 8.4f, 3.6f, 5.1f, };
        int[] maxs = new int[] { 4, 3, 1, 8, };
        ColumnInfo nameInfo =
            new ColumnInfo( "Name", String.class, "Brand name" );
        ColumnInfo abvInfo =
            new ColumnInfo( "ABV", Float.class, "Strength" );
        ColumnInfo maxInfo = 
            new ColumnInfo( "Max", Integer.class, "Maxmimum advisable" );
        abvInfo.setUnitString( "%" );
        maxInfo.setUnitString( "pint" );
        table.addColumn( ArrayColumn.makeColumn( nameInfo, names ) );
        table.addColumn( ArrayColumn.makeColumn( abvInfo, abvs ) );
        table.addColumn( ArrayColumn.makeColumn( maxInfo, maxs ) );
        return table;
    }
}
