package fit.gui;

import java.awt.Component;
import javax.swing.JTable;

/**
 * Defines an object which can modify a component generated by a 
 * {@link javax.swing.table.TableCellRenderer}.
 *
 * @author   Mark Taylor
 * @since    31 Oct 2006
 */
public interface RenderTweaker {

    /**
     * Modifies a component generated to render a cell of a JTable under
     * particular circumstances.
     *
     * @param   comp  rendered cell - this may be modified in place
     * @param   table  table containing the cell
     * @param   value  object which has been rendered to <code>comp</code>
     * @param   isSelected  whether the cell is selected
     * @param   hasFocus  whether the cell has focus
     * @param   irow   row index
     * @param   icol   column index
     */
    void tweakComponent( Component comp, JTable table, Object value,
                         boolean isSelected, boolean hasFocus,
                         int irow, int icol );
}
