package fit.run;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import fit.framework.Comparison;
import fit.framework.ObservationSet;
import fit.framework.ResultSink;
import fit.framework.TheorySet;
import fit.gui.Display;

/**
 * ResultSink implementation which displays the results in a GUI.
 *
 * @author   Mark Taylor
 * @since    27 Oct 2006
 */
public class ResultDisplay implements ResultSink {

    private Display display_;

    /**
     * Constructs a display with a default window title.
     */
    public ResultDisplay() {
        this( "Yafit Fit" );
    }

    /**
     * Constructs a display with a given window title.
     *
     * @param  title  window title
     */
    public ResultDisplay( final String title ) {
        SwingUtilities.invokeLater( new Runnable() {
            public void run() {
                JFrame frame = new JFrame( title );
                display_ = new Display();
                frame.getContentPane().add( display_ );
                frame.setDefaultCloseOperation( JFrame.DISPOSE_ON_CLOSE );
                frame.pack();
                frame.setVisible( true );
            }
        } );
    }

    public void addResult( final ObservationSet obsSet, final int iobs,
                           final Comparison[] comparisons,
                           final TheorySet theorySet ) {
        SwingUtilities.invokeLater( new Runnable() {
            public void run() {
                assert display_ != null;
                if ( obsSet != display_.getObservationSet() ) {
                    display_.setObservationSet( obsSet );
                }
                if ( theorySet != display_.getTheorySet() ) {
                    display_.setTheorySet( theorySet );
                }
                for ( int ic = 0; ic < comparisons.length; ic++ ) {
                    display_.addResult( iobs, comparisons[ ic ] );
                }
            }
        } );
    }

    public void close() {
        SwingUtilities.invokeLater( new Runnable() {
            public void run() {
                display_.dataLoaded();
            }
        } );
    }
}
