/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hapi;

import java.util.Arrays;
import uk.ac.starlink.hapi.HapiBins;
import uk.ac.starlink.hapi.HapiParam;
import uk.ac.starlink.hapi.HapiType;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;

public class ParamReader {
    private final ColumnInfo[] colInfos_;
    private final int nfield_;
    private final int nbyte_;
    private final StringReader stringReader_;
    private final BinaryReader binaryReader_;

    private ParamReader(ColumnInfo[] colInfos, int nfield, int nbyte, StringReader stringReader, BinaryReader binaryReader) {
        this.colInfos_ = colInfos;
        this.nfield_ = nfield;
        this.nbyte_ = nbyte;
        this.stringReader_ = stringReader;
        this.binaryReader_ = binaryReader;
    }

    public int getColumnCount() {
        return this.colInfos_.length;
    }

    public ColumnInfo getColumnInfo(int icol) {
        return this.colInfos_[icol];
    }

    public int getFieldCount() {
        return this.nfield_;
    }

    public int getByteCount() {
        return this.nbyte_;
    }

    public void readStringValues(String[] cells, int istart, Object[] result) {
        this.stringReader_.readStringValues(cells, istart, result);
    }

    public void readBinaryValues(byte[] buf, int istart, Object[] result) {
        this.binaryReader_.readBinaryValues(buf, istart, result);
    }

    public static ParamReader createReader(HapiParam param) {
        HapiBins[] binsArray;
        int[] size = param.getSize();
        HapiType<?, ?> type = param.getType();
        String[] units = param.getUnits();
        String fill = param.getFill();
        int nel = size == null ? 1 : Arrays.stream(size).reduce(1, (a, b) -> a * b);
        boolean multiScalar = false;
        if (nel == 0) {
            return new ParamReader(new ColumnInfo[0], 0, 0, null, null);
        }
        if (nel == 1) {
            int stringLeng;
            ColumnInfo info = new ColumnInfo(param.getName(), type.getScalarClass(), param.getDescription());
            type.adjustInfo(info);
            if (units != null && units.length == 1) {
                info.setUnitString(ParamReader.adjustUnits(units[0]));
            }
            if (String.class.equals(type.getScalarClass()) && (stringLeng = param.getLength()) > 0) {
                info.setElementSize(stringLeng);
            }
            StringReader stringReader = fill == null ? (cells, ipos, result) -> {
                result[0] = type.readStringScalar(cells[ipos]);
            } : (cells, ipos, result) -> {
                String cell = cells[ipos];
                result[0] = fill.equals(cell) ? null : type.readStringScalar(cell);
            };
            int nbyte = type.getByteCount(param.getLength());
            Object fillValue = fill == null ? null : type.readStringScalar(fill);
            BinaryReader binaryReader = fillValue == null ? (buf, ipos, result) -> {
                result[0] = type.readBinaryScalar(buf, ipos, nbyte);
            } : (buf, ipos, result) -> {
                Object out = type.readBinaryScalar(buf, ipos, nbyte);
                result[0] = out.equals(fillValue) ? null : out;
            };
            return new ParamReader(new ColumnInfo[]{info}, 1, nbyte, stringReader, binaryReader);
        }
        ColumnInfo info = new ColumnInfo(param.getName(), type.getArrayClass(), param.getDescription());
        for (HapiBins bins : binsArray = param.getBins() == null ? new HapiBins[]{} : param.getBins()) {
            String binsName = bins.getName();
            if (binsName == null || binsName.trim().length() == 0) {
                binsName = "Bins";
            }
            String binsUnits = bins.getUnits();
            String binsDescription = bins.getDescription();
            double[] centers = bins.getCenters();
            double[][] ranges = bins.getRanges();
            if (centers != null) {
                DefaultValueInfo centersInfo = new DefaultValueInfo(binsName, double[].class);
                centersInfo.setShape(new int[]{centers.length});
                centersInfo.setDescription(binsDescription == null ? "bin centers" : binsDescription);
                if (binsUnits != null) {
                    centersInfo.setUnitString(binsUnits);
                }
                info.getAuxData().add(new DescribedValue(centersInfo, centers));
            }
            if (ranges == null) continue;
            DefaultValueInfo rangesInfo = new DefaultValueInfo(binsName, double[].class);
            int nr = ranges.length;
            rangesInfo.setShape(new int[]{2, nr});
            rangesInfo.setDescription(binsDescription == null ? "bins lower,upper bounds" : binsDescription);
            if (binsUnits != null) {
                rangesInfo.setUnitString(binsUnits);
            }
            double[] flatRanges = new double[2 * nr];
            for (int ir = 0; ir < nr; ++ir) {
                double[] range = ranges[ir];
                flatRanges[2 * ir + 0] = range == null ? Double.NaN : range[0];
                flatRanges[2 * ir + 1] = range == null ? Double.NaN : range[1];
            }
            info.getAuxData().add(new DescribedValue(rangesInfo, flatRanges));
        }
        int[] stilShape = ParamReader.reverse(size);
        info.setShape(stilShape);
        type.adjustInfo(info);
        if (units != null && (units.length == 1 || Arrays.stream(units).distinct().count() == 1L)) {
            info.setUnitString(ParamReader.adjustUnits(units[0]));
        }
        int elSize = type.getByteCount(param.getLength());
        BinaryReader binaryReader = ParamReader.createBinaryArrayReader(type, elSize, nel, fill);
        StringReader stringReader = ParamReader.createStringArrayReader(type, nel, fill);
        return new ParamReader(new ColumnInfo[]{info}, nel, nel * elSize, stringReader, binaryReader);
    }

    private static String adjustUnits(String hapiUnits) {
        if ("dimensionless".equals(hapiUnits) || "UTC".equals(hapiUnits)) {
            return null;
        }
        return hapiUnits;
    }

    private static int[] reverse(int[] array) {
        int n = array.length;
        int[] array1 = new int[n];
        for (int i = 0; i < n; ++i) {
            array1[n - i - 1] = array[i];
        }
        return array1;
    }

    private static <S, A> StringReader createStringArrayReader(HapiType<S, A> type, int nel, String fillTxt) {
        if (fillTxt == null || type.readStringScalar(fillTxt) == null) {
            return (cells, istart, result) -> {
                result[0] = type.readStringArray(cells, istart, nel);
            };
        }
        Object fillValue = type.readStringScalar(fillTxt);
        return (cells, istart, result) -> {
            Object outArray = type.readStringArray(cells, istart, nel);
            type.applyFills(outArray, fillValue);
            result[0] = outArray;
        };
    }

    private static <S, A> BinaryReader createBinaryArrayReader(HapiType<S, A> type, int elSize, int nel, String fillTxt) {
        if (fillTxt == null || type.readStringScalar(fillTxt) == null) {
            return (buf, istart, result) -> {
                result[0] = type.readBinaryArray(buf, istart, elSize, nel);
            };
        }
        Object fillValue = type.readStringScalar(fillTxt);
        return (buf, istart, result) -> {
            Object outArray = type.readBinaryArray(buf, istart, elSize, nel);
            type.applyFills(outArray, fillValue);
            result[0] = outArray;
        };
    }

    @FunctionalInterface
    private static interface BinaryReader {
        public void readBinaryValues(byte[] var1, int var2, Object[] var3);
    }

    @FunctionalInterface
    private static interface StringReader {
        public void readStringValues(String[] var1, int var2, Object[] var3);
    }
}

